/**
 * @file    main.cpp
 * @brief   mbed Connected Home Endpoint main entry point
 * @author  Doug Anson
 * @version 1.0
 * @see
 *
 * Copyright (c) 2014
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// mbed Connector Interface (configuration)
#include "mbedConnectorInterface.h"

// mbed Network Endpoint 
#include "mbedEndpointNetwork.h"

// Static Resources
#include "StaticResource.h"
StaticResource mfg(&logger,"dev/mfg","Nordic Semi");
StaticResource model(&logger,"dev/mdl","nRF51822");

// Heartrate Resource
#include "HeartrateResource.h"
HeartrateResource hr(&logger,"888/0/5850",true);     // observable   

// Enable BLE-based Location
#define ENABLE_BLE_LOCATION                     false // true - enable BLELocation from Proxy (experimental!!). false - use default location below

// Location Resource
#include "LocationResource.h"
LocationResource location(&logger,"999/0/1234",true); // observable

// LED Light Resource
#include "LightResource.h"
LightResource light(&logger,"311/0/5850");

// My Endpoint Name
#define MY_ENDPOINT_NAME                        "mbed-ble-hrm-XX"       // replace "XX" with your number

// My NSP Domain
#define MY_NSP_DOMAIN                           "dfbridgeXX"            // replace "XX" with your number

// Customization Example: My custom NSP IPv4 address and NSP CoAP port 
uint8_t my_nsp_address[NSP_IP_ADDRESS_LENGTH] = {129,41,134,116};       // bluemix vm v2.3
int my_nsp_coap_port                          = 5683;

// called from the Endpoint::start() below to create resources and the endpoint internals...
Connector::Options *configure_endpoint(Connector::OptionsBuilder &config)
{
    // Build the endpoint configuration parameters
    logger.log("configure_endpoint: building endpoint configuration...");
    return config.setEndpointNodename(MY_ENDPOINT_NAME)                   // custom endpoint name
                 .setNSPAddress(my_nsp_address)                           // custom NSP address
                 .setDomain(MY_NSP_DOMAIN)                                // custom NSP domain
                 .setNSPPortNumber(my_nsp_coap_port)                      // custom NSP CoAP port
                 
                 // enable or disable(default) immediate observationing control
                 .setImmedateObservationEnabled(true)
                 
                 // enable or disable(default) GET-based observation control
                 .setEnableGETObservationControl(false)
                 
                 // add the static resource representing this endpoint
                 .addResource(&mfg)
                 .addResource(&model)
                 
                 // add the heartrate resource
                 .addResource(&light)
                 .addResource(&hr)                    // Resource implements its own observationing...
                 .addResource(&location,13245)        // observe every 13.245 seconds
                                      
                 // finalize the configuration...
                 .build();
}

// main entry point...
int main()
{    
    // Announce
    logger.log("\r\n\r\nmbed mDS BLE Heartrate Endpoint");
        
    // we have to plumb our network first
    Connector::Endpoint::plumbNetwork();
     
    // starts the endpoint by finalizing its configuration (configure_endpoint() above called),creating a Thread and reading NSP events...
    logger.log("Start the endpoint to finish setup and enter the main loop...");
    Connector::Endpoint::start();
}