#include "mbed.h"

#include "Thermostat.h"

#include "BufferedSerial.h"
BufferedSerial pc(USBTX, USBRX);
Thermostat *thermostat = NULL;

// check for exit
void checkForExit() {
    if (pc.readable()) {
        char c = pc.getc();
        if (c == 0x03) {    // CTRL-C ASCII
            pc.printf("ctrl-c: closing down thermostat...\r\n");
            if (thermostat != NULL) delete thermostat;
            pc.printf("app exiting...\r\n");
            exit(1);
        }
    }
}

int main() {
    thermostat = new Thermostat();
    if (thermostat != NULL) thermostat->runDemo();
}
