/**
* @author Doug Anson
*
* @section LICENSE
*
* Copyright (c) 2013 mbed
*
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
* THE SOFTWARE.
*
* @section DESCRIPTION
*    SocketIO derivation client library for the Thermostat Demo
*
*/

#ifndef THERMOSTATSOCKETIO_H
#define THERMOSTATSOCKETIO_H

#include "SocketIO.h"

/** 
 * ThermostatSocketIO client class.
 * Derived class from SocketIO library specifically for the ThermostatDemo app
 */

class ThermostatSocketIO : public SocketIO
{
    public:
        /**
        * Constructor
        *
        * @param devname The device's devname for display in the console
        */
        ThermostatSocketIO(char *devname);
        
        /**
        * Constructor
        *
        * @param url The SocketIO url in the form "www.example.com:[port]" (by default: port = 80) - i.e. just the endpoint name
        * @param devname The device's devname for display in the console
        */
        ThermostatSocketIO(char * url, char *devname);
        
        /**
        * Emit (Broadcast) a socket.io message to the SocketIO server - specific to the ThermostatDemo app
        *
        * @param temp - temperature
        * @param latitude - the device latitude
        * @param longitude - the device longitude
        * @param bat - the battery level
        * @param errorState - the devices current error state
        * @param t_status - the devices current error state (string - either OK or FAIL)
        *
        * @returns the number of bytes sent
        */
        int emit(float temp, float latitude, float longitude, float bat, int errorState, char *t_status);
        
        /**
        * Reset the message counter
        */
        void resetMessageCounter();
        
        /**
        * Close the SocketIO connection
        *
        * @return true if the connection has been closed, false otherwise
        */
        bool close();
        
   private:
        // variables
        char *device_name;
        
        // methods
        char *createDeregisterJSON(char *buffer);
        char *createJSON(char *buffer, float temp, float latitude, float longitude, float bat, int errorState, char *t_status);
};

#endif // THERMOSTATSOCKETIO_H