#include "ThermostatSocketIO.h"

// Default SocketIO URL
#define DEFAULT_URL     "mc-control-1.herokuapp.com"

// message counter
int counter = 1;

extern char *lcd_locations[10];
extern int location_index;

// constructor
ThermostatSocketIO::ThermostatSocketIO(char *devname) : SocketIO(DEFAULT_URL) {
    this->device_name = devname;
}

// constructor
ThermostatSocketIO::ThermostatSocketIO(char * myurl, char *devname) : SocketIO(myurl) {
    this->device_name = devname;
}

// reset the message counter
void ThermostatSocketIO::resetMessageCounter() {
    counter = 1;
}

// emit a message (broadcast) to the SocketIO server
int ThermostatSocketIO::emit(float temp, float latitude, float longitude, float bat, int errorState, char *t_status) {
    // create json string with acc/tmp data
    char send[256];
    char *json = this->createJSON(send,temp,latitude,longitude,bat,errorState,t_status);
    
    // handle the message name
    char message_name[32];
    if (counter == 1) 
        // we need to register the device
        sprintf(message_name,"register-device");
    else
        // we are simply issuing readings...
        sprintf(message_name,"readings");
        
    // increment our counter
    ++counter;
  
    // emit this json
    return ((SocketIO *)this)->emit(message_name,json);
}

// Close the thermostat socket.io
bool ThermostatSocketIO::close() {
    char buf[256];
    char message_name[32];
    
    // we need to register the device
    sprintf(message_name,"disconnect");

    // create the deregister JSON message
    char *json = this->createDeregisterJSON(buf);
    
    // now send...
    int sent = ((SocketIO *)this)->emit(message_name,json);
    
    // now close
    return ((SocketIO *)this)->close();
} 

// create the JSON to deregister the device
char *ThermostatSocketIO::createDeregisterJSON(char *buffer) {
    // create the JSON to just register the device
    sprintf(buffer,"[{ \"device_id\": \"%s\" } }]",this->device_name);
        
    // return the JSON
    return buffer;
}

// Create the JSON that is consumable by the demo webservice
char *ThermostatSocketIO::createJSON(char *buffer, float temp, float latitude, float longitude, float bat, int errorState, char *t_status) {
   // create the message name
   if (counter == 1) {
        // create the JSON to just register the device
        sprintf(buffer,"[\"%s\",{\"battery\": %d, \"city\": \"%s\", \"country\": \"US\", \"device_id\": \"%s\", \"lat\": %4.6f, \"long\": %4.6f, \"status\": \"%s\", \"temp\": %4.1f, \"switch\": %d}]", 
               device_name, (int)bat, lcd_locations[location_index], this->device_name, latitude, longitude, t_status, temp, errorState);
   }
   else {
        // create the JSON
        sprintf(buffer,"[{\"battery\": %d, \"city\": \"%s\", \"country\": \"US\", \"device_id\": \"%s\", \"lat\": %4.6f, \"long\": %4.6f, \"status\": \"%s\", \"temp\": %4.1f, \"switch\": %d}]",
          (int)bat, lcd_locations[location_index], this->device_name, latitude, longitude, t_status, temp, errorState);
   }
   
   // return the JSON
   return buffer;        
}
