/* Thermostat.h */
/* Copyright (C) 2013 mbed.org, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
 
#ifndef THERMOSTAT_H_
#define THERMOSTAT_H_

// platform support
#include "mbed.h"

// Support for std args
#include <stdarg.h>

// maximum size of a displayed message
#define MAX_MESSAGE_LENGTH  100

class Thermostat {
    public:
        // Default Constructor
        Thermostat();
        
        // Destructor
        ~Thermostat();
        
        // invoke the demo
        void runDemo();
              
    private: 
        int getErrorState();
        char *createDeregisterJSON(char *buffer);
        char *createJSON(char *buffer, float temp, float latitude, float longitude, float bat);
       
        float getTemperature();
        float getBatteryLevel();
        
        void resetDeviceStatus();
        int translateLEDStatus(const char *status, int current);
        void parseAndActOnControlMessage(char *json);
        void processControlMessage();
        void sendDeregisterMessage();
        void sendStatus();
        void sendStatus(float temp, int battery);
        void sendStatus(float temp, float latitude, float longitude, float bat);
        
        char *receiveFromWSService(char *buffer);
         
        void parseSessionKey(char *response, char *sessionkey);
        char *performSocketIOHandshake(char *sessionkey);
        bool connectWebSocketService();
        bool connectEthernet();
        
        void gracefullyDisconnect();
        void mainLoop();
        
        // Thermostat-LEDUtils.cpp
        void setAllLEDs(int state);
        void resetAllLEDs();
        void blinkAllLEDs();
        void updateRGBLED(float H,float S, float V);
        void setRGBLED(double color, double bright);       
        void turnRGBLEDRed();
        void turnRGBLEDGreen();
        void turnRGBLEDBlue();
        void blinkLED(DigitalOut led);
        void blinkTransportTxLED();
        void blinkTransportRxLED();
        
        // Thermostat-BaseUtils.cpp
        void logMessage(bool do_lcd);
        void display(const char *format, ...);
        void display_lcd(const char *format, ...);
        void displayTextMessage(const char *format, ...);
        
        // Stubs
        void updateCoordinates();
        void initLocation();
        
        // private members
        float  m_latitude;
        float  m_longitude;
        float  m_temperature;
        float  m_battery;
        char  *m_status;
        bool   m_error_state;
        double m_rgbLEDColor;
        double m_rgbLEDBright;
        char   m_display_message[MAX_MESSAGE_LENGTH+1];
};

#endif /* THERMOSTAT_H_ */