/* Copyright C2013 Doug Anson, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files the "Software", to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
 
 #ifndef _MBED_UBLOX_GPS_H_
 #define _MBED_UBLOX_GPS_H_
  
  // UBLOX GPS Support
 #include "GPS.h"
 
  // BaseClass support
 #include "BaseClass.h"
 
 class MBEDUbloxGPS : public BaseClass {
     private: 
        GPSParser    *m_gps;
 #ifdef ENABLE_THREADS
        Thread       *m_gps_poll_thread;
 #endif
        float         m_latitude;
        float         m_longitude;
        
     public:
        MBEDUbloxGPS(Logger *error_handler, void *endpoint,void *gps);
        virtual ~MBEDUbloxGPS();
       
       void  update();
       
       bool  connect();
       bool  disconnect();
              
       float getLatitude();
       float getLongitude();
 };
 
 #endif // _MBED_UBLOX_GPS_H_
 
 