/* Copyright C2013 Doug Anson, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files the "Software", to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
 
 // class support
 #include "MBEDUbloxGPS.h"
 
 // MBEDEndpoint support
 #include "MBEDEndpoint.h"
 
 // our instance
 MBEDUbloxGPS *_ublox_gps_instance = NULL;
 bool _ublox_gps_loop = true;
  
 #ifdef ENABLE_THREADS
 // threaded task
 static void read_gps(void const *args) {
    while (_ublox_gps_loop == true && _ublox_gps_instance != NULL) {
        _ublox_gps_instance->update();
        Thread::wait(UBLOX_GPS_POLL_MS);
    }
    if (_ublox_gps_instance != NULL) _ublox_gps_instance->logger()->log("GPS update thread stopping...");
 }
 #endif
 
 // default constructor
 MBEDUbloxGPS::MBEDUbloxGPS(Logger *error_handler, void *endpoint,void *gps) : BaseClass(error_handler,endpoint) {
 #ifdef ENABLE_THREADS
     this->m_gps_poll_thread = NULL;
 #endif
     this->m_gps = (GPSParser *)gps;
     this->m_latitude = 0;
     this->m_longitude = 0;
     _ublox_gps_instance = this;
 }
 
 // default destructor
 MBEDUbloxGPS::~MBEDUbloxGPS() {
 #ifdef ENABLE_THREADS
     if (this->m_gps_poll_thread != NULL) { this->m_gps_poll_thread->terminate(); delete this->m_gps_poll_thread; }
 #endif
 
 }
 
 // update our GPS info
 void MBEDUbloxGPS::update() {
     char out[20]; 
     memset(out,0,20);
     sprintf(out,"<GPS off>");
     
     // convert the input to latitude/longitude decimal values
     this->logger()->log("GPS: Output: %s",out);
 }
 
 // start the update thread and connect
 bool MBEDUbloxGPS::connect() {
#ifdef ENABLE_THREADS
     if (this->m_gps_poll_thread == NULL) {
          this->logger()->log("starting GPS update thread...");
          this->m_gps_poll_thread = new Thread(read_gps);
     }
#endif
     return true;
 }
 
 // halt the update thread and disconnect
 bool MBEDUbloxGPS::disconnect() { _ublox_gps_loop = false; return true; }
 
 // get latitude
 float MBEDUbloxGPS::getLatitude() { return this->m_latitude; }
 
 // get longitude
 float MBEDUbloxGPS::getLongitude() { return this->m_longitude; }