/* Copyright C2013 Doug Anson, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files the "Software", to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
 
 // class support
 #include "MBEDUbloxCellRadio.h"
 
 // MBEDEndpoint support
 #include "MBEDEndpoint.h"
  
 // default constructor
 MBEDUbloxCellRadio::MBEDUbloxCellRadio(Logger *error_handler,void *endpoint,void *modem) : BaseClass(error_handler,endpoint) {
 #ifdef NSP_CELLULAR_NETWORK
     this->m_modem = (MDMRtos<MDMSerial> *)modem;
 #else
     this->m_modem = (MDMSerial *)modem;
 #endif
 #ifdef CELLULAR_DEBUG
     if (this->m_modem != NULL) this->m_modem->setDebug(4);
 #endif
     this->m_connected = false;
 }
 
 // default destructor
 MBEDUbloxCellRadio::~MBEDUbloxCellRadio() {
 }
 
 // connect
 bool MBEDUbloxCellRadio::connect() {
    if (this->m_connected == false)
        this->m_connected = this->m_modem->connect(SIMPIN, APN,USERNAME,PASSWORD);
    return this->m_connected;
 }
 
 // disconnect
 bool MBEDUbloxCellRadio::disconnect() {
     if (this->m_connected == true) {
         this->m_modem->disconnect();
         this->m_modem->powerOff();
         this->m_connected = false;
     }
     return !this->m_connected;
 }