/* Thermostat-BaseUtils.h */
/* Copyright (C) 2013 mbed.org, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
 
#ifndef THERMOSTAT_BASEUTILS_H_
#define THERMOSTAT_BASEUTILS_H_

// AppBoard LCD Support
#include "C12832_lcd.h"
C12832_LCD lcd;

// Serial Console Support (main.cpp)
extern Serial pc;

// log messages to appropriate outputs
void Thermostat::logMessage(bool do_lcd) {    
    // print to LCD panel
    if (do_lcd) {
        lcd.cls();
        lcd.locate(0,0);
        lcd.printf(this->m_display_message);
    }
    else {
        // print to serial console
        pc.printf(this->m_display_message);
        pc.printf("\r\n");
    }
    
    // wait a bit so that the message can be read
    wait(0.5);
}

// display output
void Thermostat::display(const char *format, ...) {   
    memset(this->m_display_message,'\0',MAX_MESSAGE_LENGTH+1);
    va_list args;
    va_start(args, format);
    vsprintf(this->m_display_message, format, args);
    va_end(args);
    this->logMessage(false);
}

// display output
void Thermostat::display_lcd(const char *format, ...) {
    memset(this->m_display_message,'\0',MAX_MESSAGE_LENGTH+1);
    va_list args;
    va_start(args, format);
    vsprintf(this->m_display_message, format, args);
    va_end(args);
    this->logMessage(true);
}

#endif // THERMOSTAT_BASEUTILS_H_
