/* Copyright C2014 ARM, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files the "Software", to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
 
 #include "SupportPersonnelDB.h"
 
 // min function
 extern "C" int min(int val1,int val2) {
     if (val1 < val2) return val1;
     return val2;
 }
 
 // constructor
 SupportPersonnelDB::SupportPersonnelDB() {
     this->initDB();
 }
 
 // destructor
 SupportPersonnelDB::~SupportPersonnelDB() {
 }
 
 // lookup and return a support person
 SupportPersonEntry *SupportPersonnelDB::lookup(int rfid) {
     SupportPersonEntry *entry = NULL;
     bool         found = false;
     
     // linear search through the list until we end or find something...
     for(int i=0;i<DB_MAX_NUM_SUPPORT_PERSONS &&!found;++i) {
         if (this->m_db[i].rfid == rfid) {
             found = true;
             entry = &(this->m_db[i]);
         }
     }
     
     return entry;
 }
 
 // lookup a support person and return the name
 char *SupportPersonnelDB::lookupName(int rfid) {
     SupportPersonEntry *entry = this->lookup(rfid);
     if (entry != NULL) return entry->name;
     return NULL;
 }
 
  // lookup a support person and return the description
 char *SupportPersonnelDB::lookupDescription(int rfid) {
     SupportPersonEntry *entry = this->lookup(rfid);
     if (entry != NULL) return entry->description;
     return NULL;
 }
     
 // lookup a support person and return the current status
 char *SupportPersonnelDB::lookupStatus(int rfid) {
     SupportPersonEntry *entry = this->lookup(rfid);
     if (entry != NULL) return entry->status;
     return NULL;
 }
 
 // lookup a support person and return the current location(latitude)
 char *SupportPersonnelDB::lookupLocationLatitude(int rfid) {
     SupportPersonEntry *entry = this->lookup(rfid);
     if (entry != NULL) return entry->latitude;
     return NULL;
 }
 
 // lookup a support person and return the current location(longitude)
 char *SupportPersonnelDB::lookupLocationLongitude(int rfid) {
     SupportPersonEntry *entry = this->lookup(rfid);
     if (entry != NULL) return entry->longitude;
     return NULL;
 }
 
 // initialize the simple support personnel DB
 void SupportPersonnelDB::initDB() {
     // First Support Person
     memset((void *)&(this->m_db[FIRST_SUPPORT_PERSON]),0,sizeof(SupportPersonEntry));
     this->m_db[FIRST_SUPPORT_PERSON].rfid = FIRST_SUPPORT_PERSON_RFID;
     strncpy(this->m_db[FIRST_SUPPORT_PERSON].name,FIRST_SUPPORT_PERSON_NAME,min(strlen(FIRST_SUPPORT_PERSON_NAME),DB_MAX_NAME_LENGTH));
     strncpy(this->m_db[FIRST_SUPPORT_PERSON].description,FIRST_SUPPORT_PERSON_DESCRIPTION,min(strlen(FIRST_SUPPORT_PERSON_DESCRIPTION),DB_MAX_DESCRIPTION_LENGTH));
     strncpy(this->m_db[FIRST_SUPPORT_PERSON].status,FIRST_SUPPORT_PERSON_STATUS,min(strlen(FIRST_SUPPORT_PERSON_STATUS),DB_MAX_STATUS_LENGTH));
     strncpy(this->m_db[FIRST_SUPPORT_PERSON].latitude,FIRST_SUPPORT_PERSON_LATITUDE,min(strlen(FIRST_SUPPORT_PERSON_LATITUDE),DB_MAX_LATLONG_LENGTH));
     strncpy(this->m_db[FIRST_SUPPORT_PERSON].longitude,FIRST_SUPPORT_PERSON_LONGITUDE,min(strlen(FIRST_SUPPORT_PERSON_LONGITUDE),DB_MAX_LATLONG_LENGTH));
     
     // Second Support Person
     memset((void *)&(this->m_db[SECOND_SUPPORT_PERSON]),0,sizeof(SupportPersonEntry));
     this->m_db[SECOND_SUPPORT_PERSON].rfid = SECOND_SUPPORT_PERSON_RFID;
     strncpy(this->m_db[SECOND_SUPPORT_PERSON].name,SECOND_SUPPORT_PERSON_NAME,min(strlen(SECOND_SUPPORT_PERSON_NAME),DB_MAX_NAME_LENGTH));
     strncpy(this->m_db[SECOND_SUPPORT_PERSON].description,SECOND_SUPPORT_PERSON_DESCRIPTION,min(strlen(SECOND_SUPPORT_PERSON_DESCRIPTION),DB_MAX_DESCRIPTION_LENGTH));
     strncpy(this->m_db[SECOND_SUPPORT_PERSON].status,SECOND_SUPPORT_PERSON_STATUS,min(strlen(SECOND_SUPPORT_PERSON_STATUS),DB_MAX_STATUS_LENGTH));
     strncpy(this->m_db[SECOND_SUPPORT_PERSON].latitude,SECOND_SUPPORT_PERSON_LATITUDE,min(strlen(SECOND_SUPPORT_PERSON_LATITUDE),DB_MAX_LATLONG_LENGTH));
     strncpy(this->m_db[SECOND_SUPPORT_PERSON].longitude,SECOND_SUPPORT_PERSON_LONGITUDE,min(strlen(SECOND_SUPPORT_PERSON_LONGITUDE),DB_MAX_LATLONG_LENGTH));
     
     // Third Support Person 
     memset((void *)&(this->m_db[THIRD_SUPPORT_PERSON]),0,sizeof(SupportPersonEntry));
     this->m_db[THIRD_SUPPORT_PERSON].rfid = THIRD_SUPPORT_PERSON_RFID;
     strncpy(this->m_db[THIRD_SUPPORT_PERSON].name,THIRD_SUPPORT_PERSON_NAME,min(strlen(THIRD_SUPPORT_PERSON_NAME),DB_MAX_NAME_LENGTH));
     strncpy(this->m_db[THIRD_SUPPORT_PERSON].description,THIRD_SUPPORT_PERSON_DESCRIPTION,min(strlen(THIRD_SUPPORT_PERSON_DESCRIPTION),DB_MAX_DESCRIPTION_LENGTH));
     strncpy(this->m_db[THIRD_SUPPORT_PERSON].status,THIRD_SUPPORT_PERSON_STATUS,min(strlen(THIRD_SUPPORT_PERSON_STATUS),DB_MAX_STATUS_LENGTH));
     strncpy(this->m_db[THIRD_SUPPORT_PERSON].latitude,THIRD_SUPPORT_PERSON_LATITUDE,min(strlen(THIRD_SUPPORT_PERSON_LATITUDE),DB_MAX_LATLONG_LENGTH));
     strncpy(this->m_db[THIRD_SUPPORT_PERSON].longitude,THIRD_SUPPORT_PERSON_LONGITUDE,min(strlen(THIRD_SUPPORT_PERSON_LONGITUDE),DB_MAX_LATLONG_LENGTH));
 }