/* Copyright C2014 ARM, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files the "Software", to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
 
 #ifndef _STATUS_REPORTER_H_
 #define _STATUS_REPORTER_H_
 
 #include "Definitions.h"
 #include "ErrorHandler.h"
 #include "SalesForceCaseGenerator.h"
 #include "WidgetDB.h"
 #include "ID12RFID.h"
 
 class StatusReporter {
     private:
        ErrorHandler            *m_logger;
        WidgetDB                 m_db;
        SalesForceCaseGenerator  m_case_generator;
        ID12RFID                 m_rfid_reader;
        
     public:
        StatusReporter(ErrorHandler *logger);
        virtual ~StatusReporter();
        
        void checkAndReportOnStatus();
 };
 
 #endif // _STATUS_REPORTER_H_