/* Copyright C2014 ARM, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files the "Software", to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
 
 #include "StatusReporter.h"
 
 StatusReporter::StatusReporter(ErrorHandler *logger) : m_case_generator(logger), m_db(), m_rfid_reader(p13,p14) {
     this->m_logger = logger;
 }
 
 StatusReporter::~StatusReporter() {
 }
 
 void StatusReporter::checkAndReportOnStatus() { 
    // look for a readable RFID tag
    if(this->m_rfid_reader.readable()) {
        // capture the RFID id...
        this->m_logger->log("RFID: Found RFID.\r\nReading...");
        int rfid = this->m_rfid_reader.read();
        this->m_logger->log("RFID: ID %d found...\r\nProcessing...",rfid);
        
        // look it up in our WidgetDB... proceed only if we find something we know about...
        char *name = this->m_db.lookupWidgetName(rfid);
        if (name != NULL) {
            // build out a simple subject for the case
            char subject[MAX_NAME_LENGTH+1];
            memset(subject,0,MAX_NAME_LENGTH+1);
            sprintf(subject,"%s case update",name);
            
            // create and dispatch a case
            bool success = this->m_case_generator.createCase(subject,this->m_db.lookupWidgetDescription(rfid));
            if (success == true) {
                this->m_logger->log("Case Generated!\r\nScanning...");
            }
            else {
                this->m_logger->log("Case Generation FAILED\r\nScanning...");
            }
        }
        else {
            // unrecognized RFID
            this->m_logger->log("RFID %d unknown.\r\nScanning...",rfid);
        }
     }
 }