/* Copyright C2014 ARM, MIT License
 *
 * Author: Doug Anson (doug.anson@arm.com)
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files the "Software", to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
 
 #include "SalesForceCaseGenerator.h"
 
  // Logging
 #define LOG(...) { if (this->logger() != NULL) { this->logger()->log(__VA_ARGS__); } }
 #define LOG_CONSOLE(...) { if (this->logger() != NULL) { this->logger()->logConsole(__VA_ARGS__); } }
 
 // constructor
 SalesForceCaseGenerator::SalesForceCaseGenerator(HTTPClient *http,Logger *logger) : SalesforceInterface(http,logger) {
 }
 
 // destructor
 SalesForceCaseGenerator::~SalesForceCaseGenerator() {
 }
 
 // Create an anonymous Case instance
 bool SalesForceCaseGenerator::createAnonymousCase(char *subject,char *description,char *condition,int temperature,char *latitude,char *longitude) {
     bool success = false;
     
     // data buffer and result buffer
     ALLOC_BUFFER(result);
     
     // set addl header information needed for annonymous acceptance (only)
     char headers[] = "User-Agent: curl/7.33.0\nAccept: */*\n" ;
        
     // build the new case to issue to Salesforce.com 
     MbedJSONValue report;
     report["subject"]       = subject;
     report["description"]   = description;
     report["condition"]     = condition;
     report["temperature"]   = temperature;
     report["latitude"]      = latitude;
     report["longitude"]     = longitude;
        
     // covert to the HTTP data types
     ALLOC_BUFFER(data);
     strcpy(data,report.serialize().c_str());
     LOG_CONSOLE("Case JSON: %s",data);
     
     // prepare the result buffer
     HTTPJson new_case(data,strlen(data)+1);
     HTTPText http_result(result,MAX_BUFFER_LENGTH);
     
     // set headers  
     this->http()->setHeader(headers) ;
     
     // for anonymous case generation, we simply use the raw HTTP interface and POST...
     LOG_CONSOLE("Posting Case...");
     HTTPResult ret = this->http()->post(DF_CASE_GEN_URL,new_case,&http_result,7500);
     if (ret == HTTP_OK) {
        LOG_CONSOLE("Parsing Reply...");
        
        // we are looking for { "status": "ok" }...
        success = this->contains(result,"status","ok");
        if (success) {
            LOG_CONSOLE("Case post: SUCCESS");
        }
        else {
            LOG_CONSOLE("Case post: FAILED: status: %d http status: %d error: %s",ret,this->http()->getHTTPResponseCode(),result);
        }
     }
     else {
        LOG_CONSOLE("Case post: FAILED: status: %d http status: %d error: %s",ret,this->http()->getHTTPResponseCode(),result);
     }
     
     // return our status
     return success;
 }