/* Copyright C2014 ARM, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files the "Software", to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
 
 #ifndef _REPORT_DB_H_
 #define _REPORT_DB_H_
 
 #include "Definitions.h"
 
 // trivial widget db entry...
 typedef struct {
     int  rfid;
     char name[DB_MAX_NAME_LENGTH+1];
     char description[DB_MAX_DESCRIPTION_LENGTH+1];
     char condition[DB_MAX_CONDITION_LENGTH+1];
     char latitude[DB_MAX_LATLONG_LENGTH+1];
     char longitude[DB_MAX_LATLONG_LENGTH+1];
     
 } ReportEntry;
 
 // trivial database of reports to generate cases with ...    
 class ReportDB {
     private:
        ReportEntry m_db[DB_MAX_NUM_REPORTS];
     
     public:
        ReportDB();
        virtual ~ReportDB();
        
        char *lookupReportName(int rfid);
        char *lookupReportDescription(int rfid);
        char *lookupReportCondition(int rfid);
        char *lookupReportLatitude(int rfid);
        char *lookupReportLongitude(int rfid);
        
     private:
        void initDB();
        ReportEntry *lookup(int rfid);
 };
 
 #endif // _REPORT_DB_H_