/* Copyright C2014 ARM, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files the "Software", to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
 
 #include "ReportDB.h"
 
 // min function
 extern "C" int min(int val1,int val2) {
     if (val1 < val2) return val1;
     return val2;
 }
 
 // constructor
 ReportDB::ReportDB() {
     this->initDB();
 }
 
 // destructor
 ReportDB::~ReportDB() {
 }
 
 // lookup and return a report
 ReportEntry *ReportDB::lookup(int rfid) {
     ReportEntry *entry = NULL;
     bool         found = false;
     
     // linear search through the list until we end or find something...
     for(int i=0;i<DB_MAX_NUM_REPORTS &&!found;++i) {
         if (this->m_db[i].rfid == rfid) {
             found = true;
             entry = &(this->m_db[i]);
         }
     }
     
     return entry;
 }
 
 // lookup a report and return its name
 char *ReportDB::lookupReportName(int rfid) {
     ReportEntry *entry = this->lookup(rfid);
     if (entry != NULL) return entry->name;
     return NULL;
 }
 
  // lookup a report and return its description
 char *ReportDB::lookupReportDescription(int rfid) {
     ReportEntry *entry = this->lookup(rfid);
     if (entry != NULL) return entry->description;
     return NULL;
 }
     
 // lookup a report and return its condition
 char *ReportDB::lookupReportCondition(int rfid) {
     ReportEntry *entry = this->lookup(rfid);
     if (entry != NULL) return entry->condition;
     return NULL;
 }
 
 // lookup a report and return its latitude
 char *ReportDB::lookupReportLatitude(int rfid) {
     ReportEntry *entry = this->lookup(rfid);
     if (entry != NULL) return entry->latitude;
     return NULL;
 }
 
 // lookup a report and return its longitude
 char *ReportDB::lookupReportLongitude(int rfid) {
     ReportEntry *entry = this->lookup(rfid);
     if (entry != NULL) return entry->longitude;
     return NULL;
 }
 
 // initialize the simple report DB
 void ReportDB::initDB() {
     // First Report
     memset((void *)&(this->m_db[FIRST_REPORT]),0,sizeof(ReportEntry));
     this->m_db[FIRST_REPORT].rfid = FIRST_REPORT_RFID;
     strncpy(this->m_db[FIRST_REPORT].name,FIRST_REPORT_NAME,min(strlen(FIRST_REPORT_NAME),DB_MAX_NAME_LENGTH));
     strncpy(this->m_db[FIRST_REPORT].description,FIRST_REPORT_DESCRIPTION,min(strlen(FIRST_REPORT_DESCRIPTION),DB_MAX_DESCRIPTION_LENGTH));
     strncpy(this->m_db[FIRST_REPORT].condition,FIRST_REPORT_CONDITION,min(strlen(FIRST_REPORT_CONDITION),DB_MAX_CONDITION_LENGTH));
     strncpy(this->m_db[FIRST_REPORT].latitude,FIRST_REPORT_LATITUDE,min(strlen(FIRST_REPORT_LATITUDE),DB_MAX_LATLONG_LENGTH));
     strncpy(this->m_db[FIRST_REPORT].longitude,FIRST_REPORT_LONGITUDE,min(strlen(FIRST_REPORT_LONGITUDE),DB_MAX_LATLONG_LENGTH));
     
     // Second Report
     memset((void *)&(this->m_db[SECOND_REPORT]),0,sizeof(ReportEntry));
     this->m_db[SECOND_REPORT].rfid = SECOND_REPORT_RFID;
     strncpy(this->m_db[SECOND_REPORT].name,SECOND_REPORT_NAME,min(strlen(SECOND_REPORT_NAME),DB_MAX_NAME_LENGTH));
     strncpy(this->m_db[SECOND_REPORT].description,SECOND_REPORT_DESCRIPTION,min(strlen(SECOND_REPORT_DESCRIPTION),DB_MAX_DESCRIPTION_LENGTH));
     strncpy(this->m_db[SECOND_REPORT].condition,SECOND_REPORT_CONDITION,min(strlen(SECOND_REPORT_CONDITION),DB_MAX_CONDITION_LENGTH));
     strncpy(this->m_db[SECOND_REPORT].latitude,SECOND_REPORT_LATITUDE,min(strlen(SECOND_REPORT_LATITUDE),DB_MAX_LATLONG_LENGTH));
     strncpy(this->m_db[SECOND_REPORT].longitude,SECOND_REPORT_LONGITUDE,min(strlen(SECOND_REPORT_LONGITUDE),DB_MAX_LATLONG_LENGTH));
     
     // Third Report
     memset((void *)&(this->m_db[THIRD_REPORT]),0,sizeof(ReportEntry));
     this->m_db[THIRD_REPORT].rfid = THIRD_REPORT_RFID;
     strncpy(this->m_db[THIRD_REPORT].name,THIRD_REPORT_NAME,min(strlen(THIRD_REPORT_NAME),DB_MAX_NAME_LENGTH));
     strncpy(this->m_db[THIRD_REPORT].description,THIRD_REPORT_DESCRIPTION,min(strlen(THIRD_REPORT_DESCRIPTION),DB_MAX_DESCRIPTION_LENGTH));
     strncpy(this->m_db[THIRD_REPORT].condition,THIRD_REPORT_CONDITION,min(strlen(THIRD_REPORT_CONDITION),DB_MAX_CONDITION_LENGTH));
     strncpy(this->m_db[THIRD_REPORT].latitude,THIRD_REPORT_LATITUDE,min(strlen(THIRD_REPORT_LATITUDE),DB_MAX_LATLONG_LENGTH));
     strncpy(this->m_db[THIRD_REPORT].longitude,THIRD_REPORT_LONGITUDE,min(strlen(THIRD_REPORT_LONGITUDE),DB_MAX_LATLONG_LENGTH));
 }