/* Copyright C2014 ARM, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files the "Software", to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
 
 #ifndef _LOGGER_H_
 #define _LOGGER_H_
 
 // our definitions
 #include "Definitions.h"
 
 // biggest log message length
 #define MAX_LOG_MESSAGE_PREFIX         128
 #define MAX_LOG_MESSAGE                (MAX_BUFFER_LENGTH+MAX_LOG_MESSAGE_PREFIX+1)
  
 // Support for varargs
 #include <stdarg.h>
 
 // LCD Support
 #if _UBLOX_PLATFORM
    #include "C12832.h"    
    #define LCDCLASS     C12832
 #endif

 #if _NXP_PLATFORM
   #include "C12832_lcd.h" 
   #define LCDCLASS      C12832_LCD   
 #endif
 
 #if _K64F_PLATFORM
   #include "C12832.h"
   #define LCDCLASS      C12832       // not used
 #endif
 
 /**
 Logger 
 Error handling class for mbed endpoints
 */  
 class Logger {
     private:
        RawSerial *m_pc;
        LCDCLASS  *m_lcd;
        char       m_message[MAX_LOG_MESSAGE+1];
        
     public:
        /**
        Default constructor
        @param pc RawSerial instance
        @param lcd LCDCLASS instance (or NULL)
        */
        Logger(RawSerial *pc,LCDCLASS *lcd);
        
        /**
        Default destructor
        */
        virtual ~Logger();
        
        /**
        log message to the serial console and LCD (if enabled)
        @param format variable argument format 
        */
        void log(const char *format, ...); 
        
        /**
        log message to the serial console only
        @param format variable argument format 
        */
        void logConsole(const char *format, ...); 
        
        /**
        turn the multi-colored LED red
        */
        void turnLEDRed();
        
        /**
        turn the multi-colored LED green
        */
        void turnLEDGreen();
        
        /**
        turn the multi-colored LED blue
        */
        void turnLEDBlue();
        
        /**
        turn the multi-colored LED purple
        */
        void turnLEDPurple();
        
        /**
        turn the multi-colored LED black
        */
        void turnLEDBlack();
        
        /**
        turn the multi-colored LED yellow
        */
        void turnLEDYellow();
        
        /**
        turn the multi-colored LED orange
        */
        void turnLEDOrange();
        
        /**
        blink the transmit LED 
        */
        void blinkTransportTxLED();
        
        /**
        blink the receiver LED
        */
        void blinkTransportRxLED();
        
    private:
        void setRGBLED(float H, float S, float V);
        void blinkLED(DigitalOut led);
 };
 
 #endif // _LOGGER_H_