/* Copyright C2014 ARM, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files the "Software", to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
 
 #include "Definitions.h"
 #include "Logger.h"
 
 // appboard LCD Panel
 #if _NXP_PLATFORM
    #include "C12832_lcd.h"
    C12832_LCD lcd;
 #endif
 #if _UBLOX_PLATFORM
     #include "C12832.h"
     C12832 lcd(D11, D13, D12, D7, D10);  
 #endif
 
 // our Serial port
 #include "BufferedSerial.h"
 BufferedSerial pc(USBTX, USBRX);
 
 // Ethernet
 #include "EthernetInterface.h"
 EthernetInterface ethernet;
 
 // HTTP 
 #include "HTTPClient.h"
 HTTPClient http;
 
 // HARD RESET
 extern "C" void HardFault_Handler() { NVIC_SystemReset(); }

 #ifdef MAC_ADDRESS
 char mac[6] = {MAC_ADDRESS};
 extern "C" void mbed_mac_address(char *s) { for(int i=0;i<6;++i) s[i] = mac[i]; }
 char fmt_mac[RESOURCE_VALUE_LEN+1];
 #endif
 
 // Main Task...
 void mainTask(void const *v) {
    // create our object instances 
#if _NXP_PLATFORM 
    Logger logger(&pc,&lcd);
#endif
#if _UBLOX_PLATFORM
    Logger logger(&pc,&lcd);
#endif
#if _K64F_PLATFORM
    Logger logger(&pc,NULL);
#endif
    
    // announce
    logger.log("ARM/DreamForce 2014 Hello salesforce v%s",APP_VERSION);
    logger.turnLEDBlue();
    
    // initialize Ethernet
    logger.log("Initializing Ethernet...");
    ethernet.init();
    
    // get a DHCP address and bring the network interface up
    logger.log("Getting IP Address...");
    logger.turnLEDOrange();
    if (ethernet.connect() == 0) {
        // log our IP address (DHCP)
        logger.log("IP Address: %s",ethernet.getIPAddress());
        
        // allocate something here...
        
        // entering main loop
        logger.log("Entering Main Loop...\r\nStarting main loop...");
        logger.turnLEDGreen();
        
        // Enter the main loop
        while(true) {
             // Do work with something here...
             Thread::wait(10*WAIT_TIME_MS);;
          }
     }
     else {
         logger.log("No Network... Exiting...");
         logger.turnLEDRed();
         exit(1);
     }
     
     // disconnect
     logger.log("Disconnecting...");
     logger.turnLEDOrange();
     ethernet.disconnect();
     
     // Exit
     logger.log("Exiting...");
     logger.turnLEDBlue();
     exit(1);
  }
  
  // main entry
  int main() {
  #if _K64F_PLATFORM
    Thread workerTask(mainTask, NULL, osPriorityNormal, STACK_SIZE);
    while (true) {
        Thread::wait(10*WAIT_TIME_MS);
    }
  #else
    mainTask(NULL);
  #endif
  }