
#include "mbed.h"
#include "rtos.h"
#include "SDFileSystem.h"
#include "wave_player.h"
#include "uLCD_4DGL.h"
#include "cmsis_os.h"
#include "Mutex.h"

uLCD_4DGL uLCD(p28, p27,p30);
PwmOut redled(p21);
PwmOut blueled(p23);
PwmOut greenled(p22);
Mutex lcd_mutex;
PwmOut led(LED1);
Mutex mode_mutex;
int brown = 0x8B4513;
int blemode = 2;


SDFileSystem sd(p11, p12, p13, p8, "sd"); //SD card

AnalogOut DACout(p18);
int mode = 2;
int color;
char bnum=0;
wave_player waver(&DACout);
Serial blue(p9,p10);

void ble_thread(void const *args) {
    while (true) {
        mode_mutex.lock();
        if(blue.readable())
        if (blue.getc()=='!') {
            if (blue.getc()=='B') { //button data
                bnum = blue.getc(); //button number
                if ((bnum>='1')) //is a number button 1..4
                    mode = 1; //turn on/off that num LED
                if ((bnum>='2')) //is a number button 1..4
                    mode = 2; //turn on/off that num LED
                if ((bnum=='3')) //is a number button 1..4
                    mode = 3; //turn on/off that num LED
            }
        }
        mode_mutex.unlock();
        Thread::wait(1911);
    }
}
uint32_t x = 0;
void light_thread(void const *args) {
    while(true){
        if(mode == 1){
            redled = 0;
            blueled = 1;
            greenled = 1;
        }
        else if(mode == 2){
            redled = 1;
            blueled = 1;
            greenled = 0;
        }
        else if(mode == 3){
            redled = 1;
            blueled = 0;
            greenled = 1;
        }
        Thread::wait(400);
    }
}

void lcd_thread_mode(void const *args) {
    while(true){
        mode_mutex.lock();
        lcd_mutex.lock();
        uLCD.locate(0,0);
        uLCD.printf("       ");
        uLCD.locate(0,0);
        if (mode == 1){
            color = 0xFF0000;
            uLCD.color(color);
        }
        if (mode == 2){
            color = 0x00FF00;
            uLCD.color(color);
        }
        if (mode == 3){
            color = 0x0000FF;
            uLCD.color(color);
        }
        uLCD.printf("Mode: %d", mode);
        lcd_mutex.unlock();
        mode_mutex.unlock();
        Thread::wait(1000);
    }
    
}
void lcd_thread_fire(void const *args) {
    while(true){
        lcd_mutex.lock();
        uLCD.filled_rectangle(0,40,128,128,BLACK);
        uLCD.filled_rectangle(30,100,98,107,brown);
        uLCD.filled_rectangle(40,92,88,99,brown);
        uLCD.filled_rectangle(50,84,78,91,brown);
        for(int i = 0; i<6; i++){
            if(i<3){
                int x = 30+rand()%68;
                int y = 100+rand()%7;
                uLCD.filled_circle(x,y,3,color);
                uLCD.triangle(x-3,y,x+3,y,x,y-6,color);
            }
            else if(i<5){
                int x = 40+rand()%48;
                int y = 92+rand()%7;
                uLCD.filled_circle(x,y,3,color);
                uLCD.triangle(x-3,y,x+3,y,x,y-6,color);
            }
            else if(i<6){
                int x = 50+rand()%28;
                int y = 84+rand()%7;
                uLCD.filled_circle(x,y,3,color);
                uLCD.triangle(x-3,y,x+3,y,x,y-6,color);
            }
        }
        lcd_mutex.unlock();
        Thread::wait(4000);
    }
    
}
FILE *wave_file;
void sound(void const *args) {
    while(true){
        wave_file=fopen("/sd/fire1.wav","r");
        if(mode == 2){
        wave_file=fopen("/sd/fire2.wav","r");
        }
        if(mode == 3){
        wave_file=fopen("/sd/fire3.wav","r");
        }
        if(wave_file==NULL) printf("file open error!\n\n\r");
        waver.play(wave_file);
        fclose(wave_file);
        Thread::wait(3000);
    }
}

int main()
{   led = 1;
    while(true){
        Thread BLUE_light(ble_thread);
        wait(2);
        Thread light(light_thread);
        Thread lcdTXT(lcd_thread_mode);
        //Thread roar(sound);
        Thread lcdFire(lcd_thread_fire);
        while(true){
        if(mode ==1){
        wave_file=fopen("/sd/fire1.wav","r");
        }
        if(mode == 2){
        wave_file=fopen("/sd/fire2.wav","r");
        }
        if(mode == 3){
        wave_file=fopen("/sd/fire3.wav","r");
        }
        if(wave_file==NULL) printf("file open error!\n\n\r");
        waver.play(wave_file);
        fclose(wave_file);
        Thread::wait(1300);
        }
    }
}