#include "mbed.h"
#include "CMPS03.h"

CMPS03 compass(p9, p10, CMPS03_DEFAULT_I2C_ADDRESS);
Serial pc(USBTX, USBRX);

 Serial xbee1(p13,p14);
 DigitalOut rst1(p8); //Digital reset for the XBee, 200ns for reset


DigitalOut myled(LED3);//Create variable for Led 3 on the mbed

int main() { 

    rst1 = 0; //Set reset pin to 0
    myled = 0;//Set LED3 to 0
    wait_ms(1);//Wait at least one millisecond
    rst1 = 1;//Set reset pin to 1
    wait_ms(1);//Wait another millisecond
    int Y;
     
    while (1) {//Neverending Loop
        
        myled = 1; //Turn Led 3 Off
        Y=compass.readBearing();

           printf("data %f \n\r", Y / 10.0);
            xbee1.printf("%d", Y); //XBee write whatever the PC is sending
          // xbee1.putc(Y);
            wait(1);
            myled = 0; //Turn Led 3 on for succcessfull communication
            wait(1);
        }
    }

