#include "mbed.h"
#include "ble/BLE.h"
#include "ble/Gap.h"
#include "ble/services/BatteryService.h"
#include "ble/services/DeviceInformationService.h"

#define LED_SERVICE_UUID_0              0x0000    // Custom SERVICE_UUID 
#define LED_SERVICE_UUID_1              0x0000    // Custom SERVICE_UUID 
#define LED_SERVICE_UUID_2              0x0000    // Custom SERVICE_UUID 
#define LED_SERVICE_UUID_3              0x0000    // Custom SERVICE_UUID 
#define LED_SERVICE_UUID_4              0x0000    // Custom SERVICE_UUID 
#define LED_SERVICE_UUID_5              0x0000    // Custom SERVICE_UUID 
#define LED_SERVICE_UUID_6              0x0000    // Custom SERVICE_UUID 
#define LED_SERVICE_UUID_7              0xFFE0    // Custom SERVICE_UUID 

#define LED_STATE_CHARACTERISTIC_UUID_0 0x0000    // Custom CHARACTERISTIC_UUID
#define LED_STATE_CHARACTERISTIC_UUID_1 0x0000    // Custom CHARACTERISTIC_UUID
#define LED_STATE_CHARACTERISTIC_UUID_2 0x0000    // Custom CHARACTERISTIC_UUID
#define LED_STATE_CHARACTERISTIC_UUID_3 0x0000    // Custom CHARACTERISTIC_UUID
#define LED_STATE_CHARACTERISTIC_UUID_4 0x0000    // Custom CHARACTERISTIC_UUID
#define LED_STATE_CHARACTERISTIC_UUID_5 0x0000    // Custom CHARACTERISTIC_UUID
#define LED_STATE_CHARACTERISTIC_UUID_6 0x0000    // Custom CHARACTERISTIC_UUID
#define LED_STATE_CHARACTERISTIC_UUID_7 0xFFE1    // Custom CHARACTERISTIC_UUID

BLE  ble;

DigitalOut  led1(LED1);

//------------------------------------
// Hyperterminal configuration
// 115200 bauds(Default 9600), 8-bit data, no parity
//------------------------------------
/* No need Serial to UART just usb debugger. */

Serial UART(SERIAL_TX, SERIAL_RX); // TX PA_2 , RX PA_3

static const  char    DEVICE_NAME[] = "CESA BLE 4.0 LED";
//static const uint16_t service_uuid16_list[] = {LED_SERVICE_UUID_7};
static const uint16_t service_uuid128_list[] = {LED_SERVICE_UUID_7};
static const uint16_t characteristic_uuid128_list[] = {LED_STATE_CHARACTERISTIC_UUID_7};

bool LEDCharacteristic_Value = false;                                               

//LEDState is accessible to LED callbacks(CHARACTERISTIC_UUID)
ReadWriteGattCharacteristic<bool> ledState((uint8_t *)characteristic_uuid128_list,&LEDCharacteristic_Value,GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE);


void disconnectionCallback(const Gap::DisconnectionCallbackParams_t *params)
{
    ble.startAdvertising();
}

void periodicCallback(void)
{
    //led1 = !led1; /* Do blinky on LED1 to indicate system aliveness. */
}


void onDataWrittenCallback(const GattWriteCallbackParams *params)
{
    if ((params->handle == ledState.getValueHandle()) && (params->len == 1)) 
    {
        led1 = params->data[0]; 
        
        printf("data = %d\r\n",params->data[0]);
        
    }
}

int main(void)
{
    led1 = 0;
    Ticker ticker;
    ticker.attach(periodicCallback, 1);
    
    UART.baud(115200); // Set BuadRate

    ble.init();
    ble.onDisconnection(disconnectionCallback);
    ble.onDataWritten(onDataWrittenCallback);

    GattCharacteristic *charTable[] = {&ledState};
    GattService  LEDService((uint8_t *)service_uuid128_list, charTable, sizeof(charTable) / sizeof(GattCharacteristic *));
    ble.addService(LEDService);

    /* setup advertising */
    ble.accumulateAdvertisingPayload(GapAdvertisingData::BREDR_NOT_SUPPORTED | GapAdvertisingData::LE_GENERAL_DISCOVERABLE);
    //ble.accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LIST_16BIT_SERVICE_IDS,(uint8_t *)service_uuid16_list, sizeof(service_uuid16_list));
    ble.accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LIST_128BIT_SERVICE_IDS,(uint8_t *)service_uuid128_list, sizeof(service_uuid128_list));
    ble.accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LOCAL_NAME,(uint8_t *)DEVICE_NAME, sizeof(DEVICE_NAME));
    ble.setAdvertisingType(GapAdvertisingParams::ADV_CONNECTABLE_UNDIRECTED);
    
    ble.setAdvertisingInterval(100); /* 100 ms. */
    ble.startAdvertising();

    while (true) 
    {
        ble.waitForEvent();
    }
}