#include "mbed.h"
#include "ble/BLE.h"
#include "ble/Gap.h"
#include "ble/services/BatteryService.h"
#include "ble/services/DeviceInformationService.h"

#define BUTTON_SERVICE_UUID_0              0x0000    // Custom SERVICE_UUID 
#define BUTTON_SERVICE_UUID_1              0x0000    // Custom SERVICE_UUID 
#define BUTTON_SERVICE_UUID_2              0x0000    // Custom SERVICE_UUID 
#define BUTTON_SERVICE_UUID_3              0x0000    // Custom SERVICE_UUID 
#define BUTTON_SERVICE_UUID_4              0x0000    // Custom SERVICE_UUID 
#define BUTTON_SERVICE_UUID_5              0x0000    // Custom SERVICE_UUID 
#define BUTTON_SERVICE_UUID_6              0x0000    // Custom SERVICE_UUID 
#define BUTTON_SERVICE_UUID_7              0xFFF0    // Custom SERVICE_UUID 

#define BUTTON_STATE_CHARACTERISTIC_UUID_0 0x0000    // Custom CHARACTERISTIC_UUID
#define BUTTON_STATE_CHARACTERISTIC_UUID_1 0x0000    // Custom CHARACTERISTIC_UUID
#define BUTTON_STATE_CHARACTERISTIC_UUID_2 0x0000    // Custom CHARACTERISTIC_UUID
#define BUTTON_STATE_CHARACTERISTIC_UUID_3 0x0000    // Custom CHARACTERISTIC_UUID
#define BUTTON_STATE_CHARACTERISTIC_UUID_4 0x0000    // Custom CHARACTERISTIC_UUID
#define BUTTON_STATE_CHARACTERISTIC_UUID_5 0x0000    // Custom CHARACTERISTIC_UUID
#define BUTTON_STATE_CHARACTERISTIC_UUID_6 0x0000    // Custom CHARACTERISTIC_UUID
#define BUTTON_STATE_CHARACTERISTIC_UUID_7 0xFFF1    // Custom CHARACTERISTIC_UUID

BLE  ble;

DigitalOut  led1(LED1);
InterruptIn int_external(PC_13);
DigitalIn  Push_Button(PC_13,PullNone);

static const  char    DEVICE_NAME[] = "CESA BLE 4.0 Button";
//static const uint16_t service_uuid16_list[] = {BUTTON_SERVICE_UUID_7};
static const uint16_t service_uuid128_list[] = {BUTTON_SERVICE_UUID_7};
static const uint16_t characteristic_uuid128_list[] = {BUTTON_STATE_CHARACTERISTIC_UUID_7};
                                               
bool buttonPressed = false;

//buttonState is accessible to button callbacks(CHARACTERISTIC_UUID)
ReadOnlyGattCharacteristic<bool> buttonState((uint8_t *)characteristic_uuid128_list,&buttonPressed,GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_READ);


void buttonPressedCallback(void)
{
    buttonPressed = true;
    ble.updateCharacteristicValue(buttonState.getValueHandle(),(uint8_t *)&buttonPressed, sizeof(bool));
}

void buttonReleasedCallback(void)
{
    buttonPressed = false;
    ble.updateCharacteristicValue(buttonState.getValueHandle(),(uint8_t *)&buttonPressed, sizeof(bool));
}

void disconnectionCallback(const Gap::DisconnectionCallbackParams_t *params)
{
    ble.startAdvertising();
}

void periodicCallback(void)
{
    //led1 = !led1; /* Do blinky on LED1 to indicate system aliveness. */
}

int main(void)
{
    led1 = 1;
    Ticker ticker;
    ticker.attach(periodicCallback, 1);
    int_external.fall(&buttonPressedCallback);
    int_external.rise(&buttonReleasedCallback);

    ble.init();
    ble.onDisconnection(disconnectionCallback);

    GattCharacteristic *charTable[] = {&buttonState};
    GattService  buttonService((uint8_t *)service_uuid128_list, charTable, sizeof(charTable) / sizeof(GattCharacteristic *));
    ble.addService(buttonService);

    /* setup advertising */
    ble.accumulateAdvertisingPayload(GapAdvertisingData::BREDR_NOT_SUPPORTED | GapAdvertisingData::LE_GENERAL_DISCOVERABLE);
    //ble.accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LIST_16BIT_SERVICE_IDS,(uint8_t *)service_uuid16_list, sizeof(service_uuid16_list));
    ble.accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LIST_128BIT_SERVICE_IDS,(uint8_t *)service_uuid128_list, sizeof(service_uuid128_list));
    ble.accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LOCAL_NAME,(uint8_t *)DEVICE_NAME, sizeof(DEVICE_NAME));
    ble.setAdvertisingType(GapAdvertisingParams::ADV_CONNECTABLE_UNDIRECTED);
    
    ble.setAdvertisingInterval(100); /* 100 ms. */
    ble.startAdvertising();

    while (true) 
    {
        ble.waitForEvent();
    }
}