// Headers necessary for mbed and BLE device mode
#include "mbed.h"
#include "ble/BLE.h"
#include "ble/Gap.h"
#include "ble/services/iBeacon.h"

BLE  ble;
Serial UART(SERIAL_TX, SERIAL_RX); // TX PA_2 , RX PA_3

InterruptIn int_external(PC_13);
DigitalIn  Push_Button(PC_13,PullNone);

/**
 * The Beacon payload has the following composition:
 * 128-Bit / 16byte UUID = E2 0A 39 F4 73 F5 4B C4 A1 2F 17 D1 AD 07 A9 61
 * Major/Minor  = 0x1122 / 0x3344
 * Tx Power     = 0xC8 = 200, 2's compliment is 256-200 = (-56dB)
 *
 * Note: please remember to calibrate your beacons TX Power for more accurate results.
 */
static const uint8_t uuid[] = {0x12, 0x34, 0x56, 0x78, 0x9A, 0xBC, 0xDE, 0xFF,
                               0x12, 0x34, 0x56, 0x78, 0x9A, 0xBC, 0xDE, 0x00};
uint16_t majorNumber = 1234;
uint16_t minorNumber = 5678;
uint16_t txPower     = 0xC8;
    
uint16_t count = 0;   

// Optional: Restart advertising when phone app disconnects
void disconnectionCallback(const Gap::DisconnectionCallbackParams_t *params)
{
    ble.gap().startAdvertising();
}

// main program
int main(void)
{
    UART.baud(115200); // Set BuadRate
    
    // Initialize BLE baselayer, always do this first!
    ble.init();

    // Optional: add callback for disconnection
    ble.gap().onDisconnection(disconnectionCallback);
    
    // Sacrifice 2B of 31B to AdvType overhead, rest goes to AdvData array you define
    iBeacon(ble, uuid, majorNumber, minorNumber, txPower); //ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::MANUFACTURER_SPECIFIC_DATA, Company, sizeof(Company));
    // Set advertising interval. Longer interval = longer battery life
    ble.gap().setAdvertisingInterval(100); // 100ms, set as percentage of a second
    ble.gap().startAdvertising();

    // Infinite loop waiting for BLE events
    while(1)
    {
      ble.waitForEvent(); // this saves battery while waiting for callback events
    }
}