// Headers necessary for mbed and BLE device mode
#include "mbed.h"
#include "ble/BLE.h"
#include "ble/Gap.h"
#include "ble/services/BatteryService.h"
#include "ble/services/DeviceInformationService.h"

BLE  ble;
Serial UART(SERIAL_TX, SERIAL_RX); // TX PA_2 , RX PA_3

/* We can arbiturarily choose the GAPButton service UUID to be 0xAA00
 * as long as it does not overlap with the UUIDs defined here:
 * https://developer.bluetooth.org/gatt/services/Pages/ServicesHome.aspx */
#define GAPButtonUUID 0xAA00
static uint16_t uuid16_list[] = {GAPButtonUUID , 0x0000};

// Optional: Device Name, add for human read-ability
 static char     DEVICE_NAME[] = "CESA BLE 4.0"; // Optional: device name

// Optional: Restart advertising when phone app disconnects
void disconnectionCallback(const Gap::DisconnectionCallbackParams_t *params)
{
    ble.gap().startAdvertising();
}


// main program
int main(void)
{
    UART.baud(115200); // Set BuadRate
    
    // Initialize BLE baselayer, always do this first!
    ble.init();

    // Optional: add callback for disconnection
    ble.gap().onDisconnection(disconnectionCallback);

    // Sacrifice 3B of 31B to Advertising Flags
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::BREDR_NOT_SUPPORTED | GapAdvertisingData::LE_GENERAL_DISCOVERABLE );

    // Put the device name in the advertising payload
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LIST_16BIT_SERVICE_IDS, (uint8_t *)uuid16_list, sizeof(uuid16_list));
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LOCAL_NAME, (uint8_t *)DEVICE_NAME, sizeof(DEVICE_NAME));
    
    
    ble.gap().setAdvertisingType(GapAdvertisingParams::ADV_CONNECTABLE_UNDIRECTED);
    // Set advertising interval. Longer interval = longer battery life
    ble.gap().setAdvertisingInterval(100); // 100ms, set as percentage of a second
    ble.gap().startAdvertising();

    // Infinite loop waiting for BLE events
    while(1)
    {
      ble.waitForEvent(); // this saves battery while waiting for callback events
    }
}

