/////////////////////////////////////////////////////////////////////////////
//         Binary Clock                                                    //
//                                                                         //
//  Author            Created                                              //
//  ------            -------                                              //
//  Andrew Harpin     09 December 2009                                     //
//                                                                         //
//  Purpose                                                                //
//  -------                                                                //
//  Create a simple program to test the RTC and serial controls            //
//  on the Mbed device                                                     //
//                                                                         //
//  License                                                                //
//  -------                                                                //
//  MIT Open Source                                                        //
//                                                                         //
//  Warranty                                                               //
//  --------                                                               //
//  None                                                                   //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#include "mbed.h"

// Define your outputs
DigitalOut Sec1(p5);
DigitalOut Sec2(p7);
DigitalOut Sec4(p9);
DigitalOut Sec8(p11);
DigitalOut Sec16(p13);
DigitalOut Sec32(p15);

DigitalOut Min1(p30);
DigitalOut Min2(p28);
DigitalOut Min4(p26);
DigitalOut Min8(p24);
DigitalOut Min16(p22);
DigitalOut Min32(p21);

DigitalOut Hour1(LED4);
DigitalOut Hour2(LED3);
DigitalOut Hour4(LED2);
DigitalOut Hour8(LED1);
DigitalOut Hour16(p20);

void setnewtime();

int main() 
{
    // Get the current time
    time_t seconds = time(NULL);
    
    // Check clock is initialised
    if((seconds < 500) || (seconds == 0xFFFFFFF))
    {
        setnewtime();
    }

    struct tm *tmr;
    
    // You're doing this forever, MWWWAAHAHAHAAA!!!!
    while (1) 
    {
        // Get latest time
        seconds = time(NULL);
        
        // Print to serial
        char buffer[32];
        strftime(buffer, 32, "%I:%M %p\n", localtime(&seconds));
        printf("%s", buffer);
        
        // Put time in accessible format
        tmr = localtime(&seconds);
    
        // Seconds
        Sec1     = (bool)(((uint8_t)tmr->tm_sec) & 0x01);
        Sec2     = (bool)((((uint8_t)tmr->tm_sec) & 0x02) >> 1);
        Sec4     = (bool)((((uint8_t)tmr->tm_sec) & 0x04) >> 2);
        Sec8     = (bool)((((uint8_t)tmr->tm_sec) & 0x08) >> 3);
        Sec16    = (bool)((((uint8_t)tmr->tm_sec) & 0x10) >> 4);
        Sec32    = (bool)((((uint8_t)tmr->tm_sec) & 0x20) >> 5);
        
        // Minutes
        Min1     = (bool)(((uint8_t)tmr->tm_min) & 0x01);
        Min2     = (bool)((((uint8_t)tmr->tm_min) & 0x02) >> 1);
        Min4     = (bool)((((uint8_t)tmr->tm_min) & 0x04) >> 2);
        Min8     = (bool)((((uint8_t)tmr->tm_min) & 0x08) >> 3);
        Min16    = (bool)((((uint8_t)tmr->tm_min) & 0x10) >> 4);
        Min32    = (bool)((((uint8_t)tmr->tm_min) & 0x20) >> 5);
        
        // Hours
        Hour1    = (bool)(((uint8_t)tmr->tm_hour) & 0x01);
        Hour2    = (bool)((((uint8_t)tmr->tm_hour) & 0x02) >> 1);
        Hour4    = (bool)((((uint8_t)tmr->tm_hour) & 0x04) >> 2);
        Hour8    = (bool)((((uint8_t)tmr->tm_hour) & 0x08) >> 3);
        Hour16   = (bool)((((uint8_t)tmr->tm_hour) & 0x10) >> 4);        

        wait(1); // Not my favorite method, but its easy
    }
}

void setnewtime()
{
    struct tm t;
    uint8_t day_limit = 0;

    printf("\n\n*******************************\n");
    printf("Real Time Clock setting utility\n");
    printf("*******************************\n\n");
    
    // Years
    t.tm_year = -1; // Initialise
    
    do
    {
        // Print request and wait for user entry
        printf("\nEnter Year 1900- : ");
        scanf("%d",&t.tm_year);
        
        // Validate entry
        if((t.tm_year < 1900))
        {
            t.tm_year = -1;
            printf("\nInvalid Value!!! ");
        }
    } while(t.tm_year < 0);

    // Months
    t.tm_mon = -1; // Initialise
    
    do
    {
        // Print request and wait for user entry    
        printf("\nEnter month 1-12 : ");
        scanf("%d",&t.tm_mon);
        
        // Validate entry
        if((t.tm_mon < 1) || (t.tm_mon > 12))
        {
            t.tm_mon = -1;
            printf("\nInvalid Value!!! ");
        }
    } while(t.tm_mon < 0);
    
    // Determine maximum number of days in the assigned month
    switch(t.tm_mon)
    {
        case 1:
        case 3:
        case 5:
        case 7:
        case 8:
        case 10:
        case 12:
            day_limit = 31;
        break;
        
        case 2:
            day_limit = 28;
        break;
        
        case 4:
        case 6:
        case 9:
        case 11:
            day_limit = 30;
        break;
    }

    // Days
    t.tm_mday = -1;    // Initialise
    
    do
    {
        // Print request and wait for user entry
        printf("\nEnter day 1-%d : ",day_limit);
        scanf("%d",&t.tm_mday);

        // Validate entry        
        if((t.tm_mday < 1) || (t.tm_mday > day_limit))
        {
            t.tm_mday = -1;
            printf("\nInvalid Value!!! ");
        }
    } while(t.tm_mday < 0);


    // Hours
    t.tm_hour = -1;    // Initialise
    
    do
    {
        // Print request and wait for user entry
        printf("\nEnter Hours 0-23 : ");
        scanf("%d",&t.tm_hour);

        // Validate entry        
        if((t.tm_hour < 0) || (t.tm_hour > 23))
        {
            t.tm_hour = -1;
            printf("\nInvalid Value!!! ");
        }
    } while(t.tm_hour < 0);

    // Minutes
    t.tm_min = -1;    // Initialise
    
    do
    {
        // Print request and wait for user entry
        printf("\nEnter Minutes 0-59 : ");
        scanf("%d",&t.tm_min);

        // Validate entry        
        if((t.tm_min < 0) || (t.tm_min > 59))
        {
            t.tm_min = -1;
            printf("\nInvalid Value!!! ");
        }
    } while(t.tm_min < 0);
    

    // Seconds
    t.tm_sec = -1;    // Initialise
    
    do
    {
        // Print request and wait for user entry
        printf("\nEnter Seconds 0-59 : ");
        scanf("%d",&t.tm_sec);

        // Validate entry        
        if((t.tm_sec < 0) || (t.tm_sec > 59))
        {
            t.tm_sec = -1;
            printf("\nInvalid Value!!! ");
        }
    } while(t.tm_sec < 0);
    
    // adjust for tm structure required values
    t.tm_year = t.tm_year - 1900;
    t.tm_mon = t.tm_mon - 1;
    
    // set the time
    set_time(mktime(&t));
    
    printf("\n\nAnd you're done!\n\nTime now : \n\n");
}