#include "a4960.h"

a4960::a4960() : SPI(NRF_SPI1), _cs_pin(P0_10), _blink_pin(P0_4), _PWM_pin(P0_15)
{
    PWM_freq = 20000.0;
    PWM_duty = 1;
    motor_started = false;

    _config[0] = (0x0 << 10) | (0x8 << 6) | (0x14); // 50 us comm blank time, 2.4 us blank time, 200 ns deadtime
    _config[1] = (0x7 << 6) | (0x0); // Vri = 100% Vref, Vdsth = 800mV
    _config[2] = (0x10); // 35.6 us current control time
    _config[3] = (0x0 << 8) | (0x5 << 4) | (0x4); // current limited, 50% current for hold, 18ms hold time
    _config[4] =  (0x15 << 4) | (0x4); // 0.8ms min comm time, 24 ms start comm time
    _config[5] = (0x0 << 8) | (0x8 << 4) | (0x0); // 16.875deg phase adv, 100% ramp current, 0.4ms ramp rate
    _config[6] = (0x0); // fault detection all on
    _config[7] = (0x0 << 10) | (0x4 << 7) | (0x0 << 6) | (0x0 << 4) | (0x1 << 3) | (0x0 << 2) | (0x0 << 1) | (0x0);
    // auto BEMF hyst, 3.2us zx det window, no stop on fail, DIAG pin = fault, restart on loss of sync, brake off, forward, coast
    
    SPI_init();
}

void a4960::SPI_init()
{
    // initialize pins
    _cs_pin = 1;
    _blink_pin = 1;
    _PWM_pin.period(1/PWM_freq);
    _PWM_pin.write(PWM_duty);
    // initialize SPI connection
    SPI.begin(P0_8, P0_9, P0_11);//SCK, MOSI, MOSI
    // set registers to default config
    for (int i = 0; i < 8; i++) {
        write_to_a4960(i, _config[i]);
    }
    // turn off pin to indicate initialization complete
    _blink_pin = 0;
}
void a4960::write_to_a4960(uint8_t addr, uint16_t msg)
{
    // split 16-bit message to a4960 into two 8-bit messages
    uint8_t ms_half;
    uint8_t ls_half;

    // ---- 1st message (bits 15 - 8)
    // 3 bit address
    ms_half = addr << 5;
    // 12 bit message
    // shift message to get rid of 8 LSB on the end and OR
    // the write bit and the
    // 4 remaining bits into the first-half msg
    ms_half = ms_half | 1 << 4 | (uint8_t)(msg>>8);
    // ---- 2nd message (bits 7 - 0)
    ls_half = (uint8_t)(msg);

    // pull to active low
    _cs_pin = 0;
    wait_us(200);

    // transfer the two messages halves, MSB first
    SPI.transfer(ms_half);
    SPI.transfer(ls_half);

    // wait and pull CS line back to inactive high
    wait_us(200);
    _cs_pin = 1;
}

void a4960::write_run(void)
{
    write_to_a4960(7, _config[7] | 1);
}

void a4960::write_brake(void)
{
    write_to_a4960(7, _config[7]);
}






