#ifndef _A4960_H_
#define _A4960_H_

#include "mbed.h"
#include "spi_master.h"

class a4960
{
public:
    a4960();
    void SPI_init();
    void write_to_a4960(uint8_t addr, uint16_t msg);
    void write_run();
    void write_brake();
    bool motor_started;
    float PWM_freq; // Hz
    float PWM_duty; // 0 to 1
private:
// the default configurations of the 8 a4960 registers
// 0. Config0: basic timing settings
//      CB(2 bits) comm. blank time
//      BT (4 bits) blank time in 400ns increments
//      DT (6 bits) dead time in 50ns increments
// 1. Config1: basic voltage settings
//      VR (4 bits) current limit reference voltage as ratio of Vref
//      VT (6 bits) drain-source thresh. voltage in 25 mV increments
// 2. Config2: PWM settings
//      PT (5 bits) off-time for PWM current control, limits motor current
// 3. Config3: start-up hold settings
//      IDS (1 bit) select current control or duty cycle control for init. holding torque
//      HQ (4 bits) holding torque for initial start position
//                  hold current or duty cycle in increments of 6.25%
//      HT (4 bits) hold time of init. start position, increments of 8ms from 2ms
// 4. Config4: start-up timing settings
//      EC (4 bits) end comm. time in incr. of 200us
//      SC (4 bits) start comm. time in incr. of 8ms
// 5. Config5: start-up ramp settings
//      PA (4 bits) phase advance in incr. of 1.875 deg
//      RQ (4 bits) torque during ramp up (duty cycle or current control dep. on IDS) in 6.25% incr.
//      RR (4 bits) accel. rate during forced comm. ramp up
// 6. Mask: fault masking bit for each fault bit in Diagnostic register
//      each bit: 1 means diagnostic is diabled
// 7. Run: bits to set running conditions
//      BH (2 bits) select BEMF hysteresis
//      BW (3 bits) BEMF window
//      ESF (1 bit) enable stop on fault
//      DG (2 bits) select output routed to DIAG terminal, default general fault output flag (low if fault detected)
//      RSC (1 bit) 1 to enable restart after loss of sync if RUN 1, BRK 0, else coast to stop
//      BRK (1 bit) brake control
//      DIR (1 bit) direction control
//      RUN (1 bit) run control
    uint16_t _config[8];
    SPIClass SPI;
    DigitalOut _cs_pin;
    DigitalOut _blink_pin;
    PwmOut _PWM_pin;
};

#endif