// Print messages when the AnalogIn is greater than 50%

#include "mbed.h"
#include "mlcd_32pt.h"      //Librairie pour l'écran LCD
#include "Serial.h"         //Librairie pour la communication série
#include "rtos.h"

#define ACK 0x06
#define NAK 0x15
#define ON 1
#define OFF 0
#define DEBUT_LIGNE 0
#define BLANC 0xFFFF
#define WIDTH 1
#define HEIGHT 1
#define LIGNE_SUIV 15


AnalogIn ir(p19);           //Initialisation de la pin qui reçoit la valeur du capteur infra-rouge
DigitalOut myled(LED4);     //Sert surtout au dépannage
DigitalOut myled2(LED2);    //Sert surtout au dépannage
DigitalOut myled3(LED3);
Serial terminal (USBTX,USBRX);  //pour envoyer au port de communication

int lignes = 0;
bool couleur;
Mutex flag;
unsigned char message[50];

typedef struct {
    float gris;

} mail_t;

Mail<mail_t, 16> mail_box;

void lectureCapteur (void const *args)  //Lecture du capteur infra-rouge
{
    while(true) {
        if(ir < .6) {
            couleur = false;
            sprintf((char*)message,"c'est noir! (%f)\n \r", ir.read());
            printf((char*)message);
            myled = 1;
            Thread::wait(500);
            myled = 0;
            Thread::wait(500);
        } else {
            couleur = true;
            sprintf((char*)message,"c'est blanc! (%f)\n \r", ir.read());
            printf((char*)message);
            myled2 = 1;
            Thread::wait(500);
            myled2 = 0;
            Thread::wait(500);
        }

    }
}

void envoiMessage (void const *args)    //Envoi du message sur l'écran avec le Mailbox
{
    uint32_t i = 0;

    while(1) {

        i++; // fake data update
        mail_t *mail = mail_box.alloc();
        mail->gris = i;
        mail_box.put(mail);

        drawString(DEBUT_LIGNE, lignes, FONT_8_12, BLANC, WIDTH, HEIGHT, message);
        lignes += LIGNE_SUIV;

        if (lignes >= 225) {
            copier_coller();

            lignes -= LIGNE_SUIV;
        }
    } ;
}

/*void resetEcran (void const *args)
{
    if (double_clic()) {
        flag.lock();
        sprintf((char*)message,"Reset de l'ecran");
        drawString(DEBUT_LIGNE, lignes, FONT_8_12, NOIR, WIDTH, HEIGHT, message);
        lignes = 0;
    }

}
*/

int main()
{
    int retour = 0;
    int bckground = 0;

    // Initialisation de l'écran
    
    init_lcd();
    bckground = rgb(213,44,180);
    retour = setbgColor(bckground);

    if (retour == NAK) {
        myled3 = ON;
    } else {
        sprintf((char*)message,"Lecture du capteur\n\r");
        printf("%s", (char*)message);
        drawString(DEBUT_LIGNE, lignes, FONT_8_12, BLANC, WIDTH, HEIGHT, message);
        lignes += LIGNE_SUIV;
    }

    
    //boucle avec les threads
    
    Thread thread(lectureCapteur);
    Thread thread1(envoiMessage);
    //Thread thread2(resetEcran);
    while(true) {
        osEvent evt = mail_box.get();
        if (evt.status == osEventMail) {
            mail_t *mail = (mail_t*)evt.value.p;
            printf("Valeur du gris", mail->gris);

            mail_box.free(mail);
        };



    }
}
