/* Constantes pour les commandes de l'afficheur µLCD32 : Voir fichierPICASS)-SGC-COMMANDS-SIS-rev8.pdf dans I:\Cours\247-565-SH (SOI)\lab5\4D Systems\doc */
#define ACK         0x06
#define NAK         0x15
#define AUTO_BAUD   'U'
#define ERASE       'E'
#define CHANGE_BAUD 'Q'
#define BGCOLOR     'B'
#define STRING      'S'
#define BUTTON_TEXT 'b'
#define BUTTON_UP   1
#define BUTTON_DOWN 0
#define FONT_5_7    0
#define FONT_8_8    1
#define FONT_8_12   2
#define FONT_12_16  3
#define BAUD9600    0x06
#define BAUD115200  0x0D
#define SET_BAUD    0x51


void raz(void);     // Remise à zéro de l'afficheur
int ack(void);      // Lecture de l'ACK
int rgb(char r, char g, char b);    // Conversion d'une couleur 24 bits sur 16 bits
int drawString(int x, int y, char font, int fgcolor, int width, int height, unsigned char *str);  // Affichage d'une chaîne de caractères
int drawTextButton(char state, int x, int y, int bgcolor,char font, int fgcolor, int width, int height, unsigned char *str);   // Affichage d'un bouton de contrôle
int initMenu(void); // Initialise le menu
int setbgColor(int fgcolor);  // Change la couleur de fond
void pulse(int time);   // Clignotement de la del pour l'ACK
int init_com(int baudrate);  // Change la vitesse de communication série
void init_lcd(void);    // Initialise l'afficheur avec zone tactile
int double_clic(void);  // Double clic...
int copier_coller(void);