#include "mbed.h"
#include "rtos.h"

DigitalOut led1(LED1);
DigitalOut led2(LED2);
CAN can1(p9, p10);
CAN can2(p30, p29);


//Premier message CAN à envoyer
void sendCan1(void const *args)
{

    char counter1 = 80;

    while(1) {


        printf("send()\n");
        if(can1.write(CANMessage(0x0480, &counter1, 1))) {
            printf("wloop()\n");

            printf("Message sent: %d\n", counter1);
            counter1++;
        }
        if (counter1 >89) {
            counter1 = 80;
        }
        led1 = !led1;
        Thread::wait(1842);
    }
}


//Deuxième message CAN à envoyer
void sendCan2(void const *args)
{

    char counter2 = 180;

    while(1) {
        printf("send()\n");
        if(can1.write(CANMessage(0x0580,&counter2,1))) {
            printf("wloop()\n");

            printf("Message sent: %d\n", counter2);
            counter2++;
        }
        if (counter2 >189) {
            counter2 = 180;
        }
        led1 = !led1;
        Thread::wait(2351);
    }
}

//Réception du message
void receptionMsg(void const *args)
{

    CANMessage msg;

    while(1) {
        printf("reception()\n");
        if(can2.read(msg))
            printf("Message received: %x\n", msg.id);
        if (msg.id == 1234)             //Filtre pour recevoir le message voulu et le bon data
            printf("Message received: %d\n", msg.data[0]);
        Thread::wait(958);
        led2 = !led2;
    }
}

int main()
{
    // Fonction principale qui prend en loop les 3 thread
    printf("main()\n");

    Thread thread1(sendCan1);
    Thread thread2(sendCan2);
    Thread thread3(receptionMsg);
    while(true);

}
