#include "mbed.h"
#include "SLCD.h"


#define PROGNAME "lightsense_kl46z_basic v1\n\r"
#define DATATIME 400 // milliseconds
#define LCDLEN 10
#define LIGHTSENSORPORT PTE22
#define LBUT PTC12  // port addresses for buttons
#define RBUT PTC3




SLCD slcd; //define LCD display globally define
Serial pc(USBTX, USBRX);
Timer LEDTimer;

DigitalIn buttons[2] = {RBUT, LBUT};

void LCDMess(char *lMess)
{
    slcd.Home();
    slcd.clear();
    slcd.printf(lMess);
}


int main()
{
    AnalogIn LightSensor(LIGHTSENSORPORT);
    float lightData;
    char lcdData[LCDLEN];
    PwmOut gled(LED_GREEN);
    PwmOut rled(LED_RED);
    unsigned short lightWord;
    bool lButON = false;

    int timeToChangeDF = DATATIME;
    LEDTimer.start();
    LEDTimer.reset();
    pc.printf(PROGNAME);

    while(true) {
        if (LEDTimer.read_ms() > timeToChangeDF) { // check for timer time out transtion
            lightData = (1.0 - LightSensor.read()); // show as increasiing with increasing intensity
            sprintf(lcdData,"%4.3f",lightData);
            LCDMess(lcdData);
            timeToChangeDF = DATATIME;
            //pc.printf(lcdData);
            rled = lightData;
            gled = lightData;
            
            //using if to switch between the RAW and Float output
            if(lButON == true)
            {
                lightWord = LightSensor.read_u16();
                pc.printf("LS => %10d \r\n",  lightWord);
                lButON = false;
            }
            else
            {
                lightData = (1.0 - LightSensor.read());
                pc.printf("ls => %1.3f \r\n", lightData); 
                lButON = true;   
            }
            LEDTimer.reset();
        }
    }// end while
}
