#include "mbed.h"
#include <math.h>  
#include "TSISensor.h"
#include "SLCD.h"

#define LEDON false
#define LEDOFF true
#define NUMBUTS 2
#define LBUT PTC12  // port addresses for buttons
#define RBUT PTC3
#define ARGUMENTSTATE 0
#define ANSWERSTATE 1
#define TSILIMIT 0.01
#define PRINTDELTA 0.01
#define LCDCHARLEN 10
#define DATAINTERVAL 0.1
#define BUTTONTIME 0.1
#define PROGNAME "Recursive_C++_AnnaLouise Martinez\n\r"

SLCD slcd; //define LCD display
Serial pc(USBTX, USBRX);

Timer dataTimer;
Timer ButtonTimer; // for reading button states
DigitalIn buttons[NUMBUTS] = {RBUT, LBUT};
float tsidata;
int displayState;

void initialize_global_vars(){
    pc.printf(PROGNAME);
    // set up DAQ timers
    ButtonTimer.start();
    ButtonTimer.reset();
    dataTimer.start();
    dataTimer.reset(); 
} 

void LCDMess(char *lMess){
        slcd.Home();
        slcd.clear();
        slcd.printf(lMess);
}

int countdown(int number, int increm, int minNum)
{
  int increment = increm;
  int min_number = minNum;
  int intmax = number;
  
   if(intmax <= min_number)
    {
        pc.printf("%d\n\r", intmax);
        return intmax;
    }
    else
    {
      pc.printf("%d\n\r", intmax);
      return countdown(intmax - increment, increment, min_number); 
    }  
}

int main(void) {
    int i;
    char lcdData[LCDCHARLEN];
    float lastTouch = 0.0;
    TSISensor tsi;
    float tempTSI;
    PwmOut gled(LED_GREEN);
    PwmOut rled(LED_RED);
    int num = 50;
    int incr = 2;
    int minNum = 2;
    
    initialize_global_vars();

     while (true) {
        if (ButtonTimer > BUTTONTIME){
            for (i=0; i<NUMBUTS; i++){ // index will be 0 or 1 
                if(!buttons[i]) { 
                    displayState = i;
                   int numReturn = countdown(num, incr, minNum);
                    // do something here.
                } // if ! buttons
            }// for loop to look at buttons
            ButtonTimer.reset();
            sprintf (lcdData,"%0.4f",tsidata);  
            LCDMess(lcdData); 
            rled = 0.0;
            gled = 1.0;
        }
        
        if(dataTimer.read() > DATAINTERVAL){
            dataTimer.reset();                               
            tempTSI = tsi.readPercentage();      
            if (tempTSI > TSILIMIT){
                tsidata = tempTSI;
                if (fabs(tsidata - lastTouch)> PRINTDELTA){

               }           
            }
            lastTouch=tsidata;
        }
    }
}