#include "mbed.h"
#include <math.h>  
#include "TSISensor.h"
#include "SLCD.h"

#define LEDON false
#define LEDOFF true
#define NUMBUTS 2
#define LBUT PTC12  // port addresses for buttons
#define RBUT PTC3
#define ARGUMENTSTATE 0
#define ANSWERSTATE 1
#define TSILIMIT 0.01
#define PRINTDELTA 0.01
#define LCDCHARLEN 10
#define DATAINTERVAL 0.1
#define BUTTONTIME 0.1
#define PROGNAME "SquareRootMidterm_AnnaLouise Martinez\n\r"

SLCD slcd; //define LCD display
Serial pc(USBTX, USBRX);

Timer dataTimer;
Timer ButtonTimer; // for reading button states
DigitalIn buttons[NUMBUTS] = {RBUT, LBUT};
float tsidata;
int displayState;

void initialize_global_vars(){
    pc.printf(PROGNAME);
    // set up DAQ timers
    ButtonTimer.start();
    ButtonTimer.reset();
    dataTimer.start();
    dataTimer.reset(); 
} 

void LCDMess(char *lMess){
        slcd.Home();
        slcd.clear();
        slcd.printf(lMess);
}

float sqroot(float tsiData)
{
 // Newton's method for square root
    float xnew = 0.0;
    int intmax = 20;
    float epsilon = 1e-7;
    float xold = float(tsiData/2.5);
    
    for(int i =0; i< intmax; i++)
    {
        xnew = 0.5*(xold + ((tsiData)/xold)); // Calculation
       float delta = abs(xnew-xold); // Compare old and new values
        
        if (delta < epsilon) //Check for convergence
           { 
                break;
           }
        else
           {
                xold = xnew;  //replace new calculated value to redo the calculation
           }
    }
    //float newtsiData = tsiData * 100;
    pc.printf("The square root of ");
    pc.printf("%0.4f", tsiData);
    pc.printf("  is %0.4f\n\r", xnew);
    return xnew;    
}

int main(void) {
    int i;
    char lcdData[LCDCHARLEN];
    float lastTouch = 0.0;
    TSISensor tsi;
    float tempTSI;
    PwmOut gled(LED_GREEN);
    PwmOut rled(LED_RED);
    
    initialize_global_vars();

     while (true) {
        if (ButtonTimer > BUTTONTIME){
            for (i=0; i<NUMBUTS; i++){ // index will be 0 or 1 
                if(!buttons[i]) { 
                    displayState = i;
                    // do something here.
                    
                } // if ! buttons
            }// for loop to look at buttons
            ButtonTimer.reset();
            sprintf (lcdData,"%0.4f",tsidata);  
            LCDMess(lcdData); 
            rled = 0.0;
            gled = 1.0;
        }
        
        if(dataTimer.read() > DATAINTERVAL){
            dataTimer.reset();                               
            tempTSI = tsi.readPercentage();      
            if (tempTSI > TSILIMIT){
                tsidata = tempTSI;
                if (fabs(tsidata - lastTouch)> PRINTDELTA){
                    pc.printf("Position %0.4f\n\r", tsidata);
                    float sqrt = sqroot(tsidata * 100); 
                }           
            }
            lastTouch=tsidata;
        }
    }
}