#include "mbed.h"
#include "TSISensor.h"
#include "SLCD.h"
#include "Timer.h"
#define TSILIMIT 0.99
#define LCDCHARLEN 10
#define DATAINTERVAL 0.1
#define PROGNAME "kl46z_slider_test_v1\n\r"


SLCD slcd; //define LCD display
Serial pc(USBTX, USBRX);

float tsidata;
Timer T;

void LCDMess(char *lMess){
        slcd.Home();
        slcd.clear();
        slcd.printf(lMess);
}

int main(void) {
    char lcdData[LCDCHARLEN];
    PwmOut gled(LED_GREEN);
    PwmOut rled(LED_RED);
    pc.printf(PROGNAME);
    TSISensor tsi;

     while (true) {
        tsidata = tsi.readPercentage();
        if (tsidata > TSILIMIT){
            gled = 0.0;
            rled = 0.0;
        }
        else 
        {
            if(tsidata >= 0.01)
            {
                pc.printf("\n Position %f\n\r", tsidata);
                sprintf (lcdData,"%0.4f",tsidata);  
                LCDMess(lcdData);  
                gled = tsidata;
                rled = 1.0 - tsidata;
            }
        }
        
                T.start();
                float read = T.read();
                if(read >= 0.1)
                {
                   pc.printf("stopping");
                   T.stop();
                }
                T.reset();
        
       // wait(DATAINTERVAL);
    }
    
}