#include "mbed.h"
#include <math.h> 
#include "MMA8451Q.h"
#include "SLCD.h"

/* 
Test of the accelerometer, digital I/O, on-board LCD screen.
 Looing at vector product of the x-y components of the accelerometer.
 Works pretty well. Still rough, program wise - sc 140710
 */

#define DATAINTERVAL 0.150
#define LCDDATALEN 10
#define LCDAXISLEN 3

#define PROGNAME "ACCLCD341-541\r\n"

#define PRINTDBUG
// 
#if   defined (TARGET_KL25Z) || defined (TARGET_KL46Z)
  PinName const SDA = PTE25;  // Data pins for the accelerometer/magnetometer.
  PinName const SCL = PTE24;  // DO NOT CHANGE
#elif defined (TARGET_KL05Z)
  PinName const SDA = PTB4;
  PinName const SCL = PTB3;
#else
  #error TARGET NOT DEFINED
#endif

#define MMA8451_I2C_ADDRESS (0x1d<<1)

SLCD slcd; //define LCD display
char lcdData[LCDDATALEN]; //buffer needs places dor decimal pt and colon
char lcdAxis[LCDAXISLEN];

MMA8451Q acc(SDA, SCL, MMA8451_I2C_ADDRESS);
Serial pc(USBTX, USBRX);
Timer dataTimer;

   

void LCDMess(char *lMess){
        slcd.Home();
        slcd.clear();
        slcd.printf(lMess);

} 

void LCDsignedFloat(float theNumber, Timer dataTime, char axis){
    sprintf (lcdData," %3.2f",theNumber); 
    if ((dataTime < 0.150) && (axis == 'X'))
    { sprintf (lcdAxis,"%c", axis);
    if (theNumber < 0.0) sprintf (lcdData,"<%3.2f",fabs(theNumber));}
    else if ((dataTime < 0.150) && (axis == 'Y')){
         sprintf (lcdAxis,"%c", axis); 
         if (theNumber < 0.0) sprintf (lcdData,"<%3.2f",fabs(theNumber));}
    else {sprintf (lcdAxis,"%c", axis);
    if (theNumber < 0.0) sprintf (lcdData,"<%3.2f",fabs(theNumber));}; 
    
     
    LCDMess(lcdData); 
} 

void initialize_global_vars(){
    pc.printf(PROGNAME);
    dataTimer.start();
    dataTimer.reset(); 
} 

int main() {
    float xAcc;
    float yAcc; 
    float zAcc; 
    
    initialize_global_vars();
// main loop forever 
    while(true) {
        if(dataTimer.read() > DATAINTERVAL){            
//Get accelerometer data - tilt angles minus offset for zero mark.
            xAcc = acc.getAccX();
             LCDsignedFloat(xAcc, dataTimer, 'X');
              dataTimer.reset(); 
            yAcc = acc.getAccY();
             LCDsignedFloat(yAcc, dataTimer, 'Y'); 
              dataTimer.reset(); 
            zAcc = acc.getAccZ();     
             LCDsignedFloat(zAcc, dataTimer, 'Z');
              dataTimer.reset(); 
 
#ifdef PRINTDBUG
        pc.printf("xAcc = %f\r\n", xAcc);
        pc.printf("yAcc = %f\r\n", yAcc);
        pc.printf("zAcc = %f\r\n", zAcc);
#endif
// Wait then do the whole thing again.
       }
    }
}