#include "mbed.h"
#include "LSM303D.h"
#include "stm32746g_discovery_lcd.h"
#include "stm32746g_discovery_ts.h"
#include "time.h"

//LIGNES D'ECRITURE
#define ligne1 75
#define ligne2 175
#define ligneMilieu 125
//LIMITE ECRAN PAR RAPPORT AU CENTRE DU CERCLE DU JOUEUR
#define limiteMinX 12
#define limiteMinY 12
#define limiteMaxX 467
#define limiteMaxY 259
//PARAMETRE JEU
#define nbrCoup 10

//VARIABLES GLOBALES
char buffer[100];
char bufferM[100];
float randX, randY;
float randXmemoire, randYmemoire;
bool etatRec = false;

//DigitalOut myled(LED1);
LSM303D lsm(PB_9, PB_8);

//FONCTIONS
void affichageValeurs() //AFFICHAGE VALEUR ACCELEROMETRE
{
    for(int i=0; i<20; i++)
    {
        BSP_LCD_DisplayStringAt(0, ligne1, (uint8_t *)buffer, CENTER_MODE);  //ACCELEROMETRE
        //BSP_LCD_DisplayStringAt(0, ligne2, (uint8_t *)bufferM, CENTER_MODE);  //MAGNETOMETRE
    }
}
void nouveauRectangle() //CREATION D'UN NOUVEAU CARRE - POSITION ALEATOIRE
{
    //X
    randX=rand()%limiteMaxX;   //Valeur aléatoire entre 0 à 467
    if(randX<=0)               //si la valeur aléatoire est égale à 0 donc hors limite de l'écran
        randX=limiteMaxX/2;   
    else if(randX<limiteMinX && randX>0)    //sinon si la variable est entre 0 et 12
        randX=randX*37;        //de 0 à 444
    //Y         
    randY=rand()%limiteMaxY;
    if(randX<=0)
        randX=limiteMaxY/2;
    else if(randX<limiteMinY && randX>0)
        randX=randX*21; //de 0 à 252
        
    //ETAT
    etatRec = true;
}
void parametreAffichage()
{
    BSP_LCD_Clear(LCD_COLOR_LIGHTGREEN);
    BSP_LCD_SetFont(&LCD_DEFAULT_FONT);
    BSP_LCD_SetBackColor(LCD_COLOR_LIGHTGREEN);
    BSP_LCD_SetTextColor(LCD_COLOR_DARKCYAN);
}

int main() 
{  
    //DECLARATIONS VARIABLES
        //JEU
    float ax, ay, az, mx, my, mz;
    uint8_t text[30];
    int compteur = 0;
    int compteurCoup = 0;
    clock_t t1, t2;
    float temps;
    float memoireMeilleurScore = 10000.0;
        //ECRAN TACTIL
    TS_StateTypeDef TS_State;
    uint16_t x, y;
    uint8_t status;
    uint8_t idx;
    uint8_t cleared = 0;
    uint8_t prev_nb_touches = 0;
    
    //INITIALISATION INTERFACE
    BSP_LCD_Init();
    BSP_LCD_LayerDefaultInit(LTDC_ACTIVE_LAYER, LCD_FB_START_ADDRESS);
    BSP_LCD_SelectLayer(LTDC_ACTIVE_LAYER);
    parametreAffichage();
    BSP_LCD_DisplayStringAt(0, ligneMilieu, (uint8_t *)"Projet Interfacage", CENTER_MODE);
    HAL_Delay(2000);
    
    //INITIALISATION TACTILE
    status = BSP_TS_Init(BSP_LCD_GetXSize(), BSP_LCD_GetYSize());
    if (status != TS_OK) {
        BSP_LCD_Clear(LCD_COLOR_RED);
        BSP_LCD_SetBackColor(LCD_COLOR_RED);
        BSP_LCD_SetTextColor(LCD_COLOR_WHITE);
        BSP_LCD_DisplayStringAt(0, ligneMilieu, (uint8_t *)"TOUCHSCREEN INIT FAIL", CENTER_MODE);
        HAL_Delay(2000);
    } /*else {
        BSP_LCD_Clear(LCD_COLOR_GREEN);
        BSP_LCD_SetBackColor(LCD_COLOR_GREEN);
        BSP_LCD_SetTextColor(LCD_COLOR_WHITE);
        BSP_LCD_DisplayStringAt(0, LINE(5), (uint8_t *)"TOUCHSCREEN INIT OK", CENTER_MODE);
        HAL_Delay(2000);
    }*/
    
    //TOUCHE DEBUT JEU
    do { 
        parametreAffichage();
        for(int i=0; i<20; i++)
        { 
            BSP_LCD_DisplayStringAt(0, ligneMilieu, (uint8_t *)"Appuyer pour commencer", CENTER_MODE);
        }
        BSP_TS_GetState(&TS_State);
        if (TS_State.touchDetected) 
        {
            // Clear lines corresponding to old touches coordinates
            if (TS_State.touchDetected < prev_nb_touches) 
            {
                for (idx = (TS_State.touchDetected + 1); idx <= 5; idx++) 
                {
                    BSP_LCD_ClearStringLine(idx);
                }
            }
            prev_nb_touches = TS_State.touchDetected;

            cleared = 0;

            for (idx = 0; idx < TS_State.touchDetected; idx++) 
            {
                x = TS_State.touchX[idx];
                y = TS_State.touchY[idx];
                //sprintf((char*)text, "Touch %d: x=%d y=%d    ", idx+1, x, y);
                //BSP_LCD_DisplayStringAt(0, LINE(idx+1), (uint8_t *)&text, LEFT_MODE);
                
                if(x>limiteMinX && x<limiteMaxX && y>limiteMinY && y<limiteMaxY)
                {
                    //JEU
                    compteurCoup = 0;
                    t1 = clock(); //TEMPS DEBUT PARTIE
                    BSP_LCD_Clear(LCD_COLOR_LIGHTGREEN);
                    while(1){
                        //LECTURE VALEURS
                        lsm.read(&ax, &ay, &az, &mx, &my, &mz);
        
                        //AFFICHAGE SUR LE BUFFER
                        sprintf(buffer, "%f  %f  %f", ax, ay, az);  //ACCELEROMETRE
                        //sprintf(bufferM, "%f  %f  %f", mx, my, mz); //MAGNETOMETRE
                        
                        //PARAMETRE AFFICHAGE
                        //BSP_LCD_Clear(LCD_COLOR_LIGHTGREEN);
                        BSP_LCD_SetFont(&Font12); //BSP_LCD_SetFont(&LCD_DEFAULT_FONT);
                        BSP_LCD_SetBackColor(LCD_COLOR_LIGHTGREEN);
                        BSP_LCD_SetTextColor(LCD_COLOR_DARKCYAN);
                        
                        
                        //AFFICHAGE VALEURS 
                        //affichageValeurs();
                        
                        //LIMITES TERRAIN
                        //si le cercle du joueur sort du terrain, il restera à la limite
                        if(ax < limiteMinX)
                            ax = limiteMinX; 
                        if(ay < limiteMinY)
                            ay = limiteMinY; 
                        if(ax > limiteMaxX)
                            ax = limiteMaxX; 
                        if(ay > limiteMaxY)
                            ay = limiteMaxY; 
                        
                        //AFFICHE CERCLE JOUEUR
                        BSP_LCD_SetTextColor(LCD_COLOR_RED);
                        for(int i=0; i<20; i++) 
                        {   
                            BSP_LCD_FillCircle(ax, ay, 10);
                        }   
                        //HAL_Delay(25);
        
                        //VERIFICATION ETAT PRECEDENT
                        if(etatRec==false)
                        {
                            nouveauRectangle();
                            compteurCoup++;
                        }
                        
                        //AFFICHAGE VALEUR RECTANGLE
                        sprintf((char*)text, "x=%f y=%f ", randX, randY);   
                        //BSP_LCD_DisplayStringAt(0, LINE(3), (uint8_t *)&text, LEFT_MODE);
                        
                        
                        //AFFICHAGE RECTANGLE
                        BSP_LCD_SetTextColor(LCD_COLOR_DARKBLUE);
                        for(int i=0; i<20; i++)
                            BSP_LCD_FillRect(randX, randY, 15, 15);
        
        
                        //VERIFICATION ETAT
                        if(ax>randX-10 && ax<randX+10 && ay>randY-10 && ay<randY+10)
                        {
                            etatRec=false;
                        }
                        
                        //COMPTEUR DE COUP
                        if(compteurCoup>nbrCoup)
                            break; //sortir de la boucle
        
                    }//FIN WHILE JEU
                    t2 = clock();   //temps à la fin du jeu
                    temps = (float)(t2-t1)/CLOCKS_PER_SEC; //calcul du temps de la partie
                    compteur++;
                    parametreAffichage();
                    
                    if(compteur == 1) //s'il s'agit de la 1ère partie
                    {
                        memoireMeilleurScore = temps;
                        sprintf((char*)text, "Score : %f s", temps);   
                        BSP_LCD_DisplayStringAt(0, ligneMilieu, (uint8_t *)&text, CENTER_MODE);
                    }
                    else //sinon
                    {
                        if(temps < memoireMeilleurScore)
                        {
                            memoireMeilleurScore = temps;
                            sprintf((char*)text, "Bravo ! Score battu");   
                            BSP_LCD_DisplayStringAt(0, 75, (uint8_t *)&text, CENTER_MODE);
                            sprintf((char*)text, "Score : %f s", temps);   
                            BSP_LCD_DisplayStringAt(0, 175, (uint8_t *)&text, CENTER_MODE);
                        }
                        else
                        {
                            sprintf((char*)text, "Score : %f s", temps);   
                            BSP_LCD_DisplayStringAt(0, 75, (uint8_t *)&text, CENTER_MODE);
                            BSP_LCD_SetFont(&Font16);
                            sprintf((char*)text, "  Meilleur score : %f s", memoireMeilleurScore);   
                            BSP_LCD_DisplayStringAt(0, 175, (uint8_t *)&text, LEFT_MODE);
                        }
                    }
                    HAL_Delay(8000);
                    break;
                }//FIN IF   
                
            }//FIN FOR
            
        }//FIN IF
        
    }while(1); //x<limiteMinX && x>limiteMaxX); 
    //BSP_LCD_DisplayStringAt(0, ligneMilieu, (uint8_t *)"Suivant", CENTER_MODE);
    //HAL_Delay(2000);
} //FIN MAIN
