/* mbed Microcontroller Library
 * Copyright (c) 2006-2015 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "mbed.h"
#include "ble/BLE.h"
#include "ble/services/HeartRateService.h"
#include "ble/services/HealthThermometerService.h"
#include "ble/services/BatteryService.h"
#include "ble/services/DeviceInformationService.h"
#include "PulseSensor.h"

BLE  ble;
DigitalOut led1(LED1);

const static char     DEVICE_NAME[]        = "HRM1";
static const uint16_t uuid16_list[]        = {GattService::UUID_HEART_RATE_SERVICE,
                                              GattService::UUID_HEALTH_THERMOMETER_SERVICE,
                                              GattService::UUID_DEVICE_INFORMATION_SERVICE};
static volatile bool  triggerSensorPolling = false;

void disconnectionCallback(Gap::Handle_t handle, Gap::DisconnectionReason_t reason)
{
    ble.gap().startAdvertising(); // restart advertising
}

HeartRateService * hrService;
HealthThermometerService * htService;
void sendDataToProcessing(int, int);

int main(void)
{
    led1 = 1;
    
    ble.init();
    ble.gap().onDisconnection(disconnectionCallback);

    /* Setup primary service. */
    uint8_t hrmCounter = 100; // init HRM to 100bps
    int htCounter = 100;
    hrService = new HeartRateService(ble, hrmCounter, HeartRateService::LOCATION_FINGER);
    htService = new HealthThermometerService(ble, hrmCounter, HealthThermometerService::LOCATION_BODY);

    /* Setup auxiliary service. */
    DeviceInformationService deviceInfo(ble, "ARM", "Model1", "SN1", "hw-rev1", "fw-rev1", "soft-rev1");

    /* Setup advertising. */
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::BREDR_NOT_SUPPORTED | GapAdvertisingData::LE_GENERAL_DISCOVERABLE);
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LIST_16BIT_SERVICE_IDS, (uint8_t *)uuid16_list, sizeof(uuid16_list));
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::GENERIC_HEART_RATE_SENSOR);
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::GENERIC_THERMOMETER);
    
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LOCAL_NAME, (uint8_t *)DEVICE_NAME, sizeof(DEVICE_NAME));
    ble.gap().setAdvertisingType(GapAdvertisingParams::ADV_CONNECTABLE_UNDIRECTED);
    ble.gap().setAdvertisingInterval(1000); /* 1000ms */
    ble.gap().startAdvertising();
    
    //PulseSensor sensor(P0_5, sendDataToProcessing);
    //sensor.start();
    
    /*while (1){
        led1 = 0;
        wait(1);
        led1 = 1;
        wait(1);
    }*/
        

    // infinite loop
    
    while (1) {
        // check for trigger from periodicCallback()
        if (1)
        //(triggerSensorPolling && ble.getGapState().connected)
         {
            triggerSensorPolling = false;
            
            led1 = 1;
            wait(1);
            // Do blocking calls or whatever is necessary for sensor polling.
            // In our case, we simply update the HRM measurement.
            hrmCounter++;
            htCounter--;

            //  100 <= HRM bps <=175
            if (hrmCounter == 175) {
                hrmCounter = 100;
            }
            if (htCounter == 1) {
                htCounter = 100;
            }
            

            // update bps
            sendDataToProcessing(hrmCounter, htCounter);
            led1 = 0;
            wait(1);
        } else {
            //ble.waitForEvent(); // low power wait for event
            led1 = 1;
        }
    }
}

//PulseSensor.h expects a function with argument (int)..you can't use uint8 here
 void sendDataToProcessing(int hrmCounter, int htCounter){
    hrService->updateHeartRate((uint8_t)hrmCounter);
    htService->updateTemperature((float)htCounter);
    //or you could just cast it to unit8..this just eases debugging
    //int* ans = &hrmCounter;
}

