/*******************************************************************************
* DISCLAIMER
* This software is supplied by Renesas Electronics Corporation and is only
* intended for use with Renesas products. No other uses are authorized. This
* software is owned by Renesas Electronics Corporation and is protected under
* all applicable laws, including copyright laws.
* THIS SOFTWARE IS PROVIDED "AS IS" AND RENESAS MAKES NO WARRANTIES REGARDING
* THIS SOFTWARE, WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING BUT NOT
* LIMITED TO WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE
* AND NON-INFRINGEMENT. ALL SUCH WARRANTIES ARE EXPRESSLY DISCLAIMED.
* TO THE MAXIMUM EXTENT PERMITTED NOT PROHIBITED BY LAW, NEITHER RENESAS
* ELECTRONICS CORPORATION NOR ANY OF ITS AFFILIATED COMPANIES SHALL BE LIABLE
* FOR ANY DIRECT, INDIRECT, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES FOR
* ANY REASON RELATED TO THIS SOFTWARE, EVEN IF RENESAS OR ITS AFFILIATES HAVE
* BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
* Renesas reserves the right, without notice, to make changes to this software
* and to discontinue the availability of this software. By using this software,
* you agree to the additional terms and conditions found by accessing the
* following link:
* http://www.renesas.com/disclaimer
*
* Copyright (C) 2018 Renesas Electronics Corporation. All rights reserved.
*******************************************************************************/
/*******************************************************************************
* System Name  : DRP Driver
* File Name    : drp_iodefine.h
* Device       : RZ
* Abstract     : Control software of DRP.
* Tool-Chain   : Renesas e2 studio
* OS           : Not use
* H/W Platform : Renesas Starter Kit
* Description  : IO define of DRP Driver.
* Limitation   : None
*******************************************************************************/
/*******************************************************************************
* History      : History is managed by Revision Control System.
*******************************************************************************/

#ifndef DRP_IODEFINE_H
#define DRP_IODEFINE_H

/*******************************************************************************
Includes <System Includes> , "Project Includes"
*******************************************************************************/

/*******************************************************************************
Macro definitions
*******************************************************************************/
/* CLKC */
#define DRP_regStandby (*(volatile unsigned long *)0xEAFD4018)
#define DRP_regClkRst0 (*(volatile unsigned long *)0xEAFD4020)
#define DRP_regClkRst1 (*(volatile unsigned long *)0xEAFD4028)
#define DRP_regClkRst2 (*(volatile unsigned long *)0xEAFD4030)
#define DRP_regClkRst3 (*(volatile unsigned long *)0xEAFD4038)
#define DRP_regClkRst4 (*(volatile unsigned long *)0xEAFD4040)
#define DRP_regClkRst5 (*(volatile unsigned long *)0xEAFD4048)
#define DRP_regClkRst6 (*(volatile unsigned long *)0xEAFD4050)
#define DRP_regClkRst7 (*(volatile unsigned long *)0xEAFD4058)
#define DRP_regSftRst0 (*(volatile unsigned long *)0xEAFD4060)
#define DRP_regSftRst1 (*(volatile unsigned long *)0xEAFD4068)
#define DRP_regSftRst2 (*(volatile unsigned long *)0xEAFD4070)
#define DRP_regSftRst3 (*(volatile unsigned long *)0xEAFD4078)
#define DRP_regSftRst4 (*(volatile unsigned long *)0xEAFD4080)
#define DRP_regSftRst5 (*(volatile unsigned long *)0xEAFD4088)
#define DRP_regSftRst6 (*(volatile unsigned long *)0xEAFD4090)
#define DRP_regSftRst7 (*(volatile unsigned long *)0xEAFD4098)
#define DRP_StandbyOut (*(volatile unsigned long *)0xEAFD40A0)
#define DRP_SleepOut (*(volatile unsigned long *)0xEAFD40A8)
#define DRP_regIDREG1 (*(volatile unsigned long *)0xEAFD40B0)
#define DRP_regIDREG5 (*(volatile unsigned long *)0xEAFD40D0)
#define DRP_CHIPID32 (*(volatile unsigned long *)0xEAFD40D8)
#define DRP_regStandbyWait (*(volatile unsigned long *)0xEAFD40F0)
#define DRP_regStandbyWaitClr (*(volatile unsigned long *)0xEAFD40F8)
/* COMCFGC COMREGC */
#define DRP_CMCFG_TILEWE (*(volatile unsigned long *)0xEAFFE000)
#define DRP_CMCFG_TILESRC (*(volatile unsigned long *)0xEAFFE004)
#define DRP_CMREG_TILEWE (*(volatile unsigned long *)0xEAFD6000)
#define DRP_CMREG_TILESRC (*(volatile unsigned long *)0xEAFD6004)
/* drpkc */
#define DRP_PORT0 (*(volatile unsigned long *)0xEAFD5000)
#define DRP_PORT1 (*(volatile unsigned long *)0xEAFD5004)
#define DRP_PORT2 (*(volatile unsigned long *)0xEAFD5008)
#define DRP_PORT3 (*(volatile unsigned long *)0xEAFD500C)
#define DRP_PORT4 (*(volatile unsigned long *)0xEAFD5010)
#define DRP_PORT5 (*(volatile unsigned long *)0xEAFD5014)
#define DRP_PORT6 (*(volatile unsigned long *)0xEAFD5018)
#define DRP_PORT7 (*(volatile unsigned long *)0xEAFD501C)
#define DRP_PORT8 (*(volatile unsigned long *)0xEAFD5020)
#define DRP_PORT9 (*(volatile unsigned long *)0xEAFD5024)
#define DRP_PORT10 (*(volatile unsigned long *)0xEAFD5028)
#define DRP_PORT11 (*(volatile unsigned long *)0xEAFD502C)
#define DRP_PORT12 (*(volatile unsigned long *)0xEAFD5030)
#define DRP_PORT13 (*(volatile unsigned long *)0xEAFD5034)
#define DRP_PORT14 (*(volatile unsigned long *)0xEAFD5038)
#define DRP_PORT15 (*(volatile unsigned long *)0xEAFD503C)
#define DRP_PORT16 (*(volatile unsigned long *)0xEAFD5040)
#define DRP_PORT17 (*(volatile unsigned long *)0xEAFD5044)
#define DRP_PORT18 (*(volatile unsigned long *)0xEAFD5048)
#define DRP_PORT19 (*(volatile unsigned long *)0xEAFD504C)
#define DRP_PORT20 (*(volatile unsigned long *)0xEAFD5050)
#define DRP_PORT21 (*(volatile unsigned long *)0xEAFD5054)
#define DRP_PORT22 (*(volatile unsigned long *)0xEAFD5058)
#define DRP_PORT23 (*(volatile unsigned long *)0xEAFD505C)
#define DRP_PORT24 (*(volatile unsigned long *)0xEAFD5060)
#define DRP_PORT25 (*(volatile unsigned long *)0xEAFD5064)
#define DRP_PORT26 (*(volatile unsigned long *)0xEAFD5068)
#define DRP_PORT27 (*(volatile unsigned long *)0xEAFD506C)
#define DRP_PORT28 (*(volatile unsigned long *)0xEAFD5070)
#define DRP_PORT29 (*(volatile unsigned long *)0xEAFD5074)
#define DRP_PORT30 (*(volatile unsigned long *)0xEAFD5078)
#define DRP_PORT31 (*(volatile unsigned long *)0xEAFD507C)
#define DRP_PINCNST (*(volatile unsigned long *)0xEAFD5080)
#define DRP_PIEMONI (*(volatile unsigned long *)0xEAFD5084)
#define DRP_POUTMONI (*(volatile unsigned long *)0xEAFD5088)
#define DRP_POEMONI (*(volatile unsigned long *)0xEAFD508C)
#define DRP_TILE0 (*(volatile unsigned long *)0xEAFD50C0)
#define DRP_TILE1 (*(volatile unsigned long *)0xEAFD50C2)
#define DRP_TILE2 (*(volatile unsigned long *)0xEAFD50C4)
#define DRP_TILE3 (*(volatile unsigned long *)0xEAFD50C6)
#define DRP_TILE4 (*(volatile unsigned long *)0xEAFD50C8)
#define DRP_TILE5 (*(volatile unsigned long *)0xEAFD50CA)
#define DRP_TILEPAT (*(volatile unsigned long *)0xEAFD5100)
/* IDMAC */
#define DRP_IDIF_INT (*(volatile unsigned long *)0xEAFF9000)
#define DRP_IDIF_INTMSK (*(volatile unsigned long *)0xEAFF9004)
#define DRP_IDIF_EINT (*(volatile unsigned long *)0xEAFF9008)
#define DRP_IDIF_EINTMSK (*(volatile unsigned long *)0xEAFF900C)
#define DRP_IDIF_EINT_DSC (*(volatile unsigned long *)0xEAFF9010)
#define DRP_IDIF_EINTMSK_DSC (*(volatile unsigned long *)0xEAFF9014)
#define DRP_IDIF_INTMSKSET (*(volatile unsigned long *)0xEAFF9020)
#define DRP_IDIF_INTMSKCLR (*(volatile unsigned long *)0xEAFF9024)
#define DRP_IDIF_EINTMSKSET (*(volatile unsigned long *)0xEAFF9030)
#define DRP_IDIF_EINTMSKCLR (*(volatile unsigned long *)0xEAFF9034)
#define DRP_IDIF_EINTMSKDSCSET (*(volatile unsigned long *)0xEAFF9038)
#define DRP_IDIF_EINTMSKDSCCLR (*(volatile unsigned long *)0xEAFF903C)
#define DRP_IDIF_ERRCSMON (*(volatile unsigned long *)0xEAFF9080)
#define DRP_IDIF_ERRADMON (*(volatile unsigned long *)0xEAFF9084)
#define DRP_IDIF_ERRSZMON (*(volatile unsigned long *)0xEAFF9088)
#define DRP_IDIF_ERRMONST (*(volatile unsigned long *)0xEAFF908C)
#define DRP_IDIF_DMACNTI0 (*(volatile unsigned long *)0xEAFF9100)
#define DRP_IDIF_BADRI0 (*(volatile unsigned long *)0xEAFF9108)
#define DRP_IDIF_DAMONI0 (*(volatile unsigned long *)0xEAFF910C)
#define DRP_IDIF_DSMONLI0 (*(volatile unsigned long *)0xEAFF9110)
#define DRP_IDIF_STCNTI0 (*(volatile unsigned long *)0xEAFF9114)
#define DRP_IDIF_LCSMONLI0 (*(volatile unsigned long *)0xEAFF911C)
#define DRP_IDIF_LADMONMI0 (*(volatile unsigned long *)0xEAFF9120)
#define DRP_IDIF_LSZMONHI0 (*(volatile unsigned long *)0xEAFF9124)
#define DRP_IDIF_BPCTLI0 (*(volatile unsigned long *)0xEAFF9128)
#define DRP_IDIF_BPSETI0 (*(volatile unsigned long *)0xEAFF912C)
#define DRP_IDIF_BPDISADRI0 (*(volatile unsigned long *)0xEAFF9130)
#define DRP_IDIF_BPACTLI0 (*(volatile unsigned long *)0xEAFF9134)
#define DRP_IDIF_WPMONI0 (*(volatile unsigned long *)0xEAFF9138)
#define DRP_IDIF_RPMONI0 (*(volatile unsigned long *)0xEAFF913C)
#define DRP_IDIF_FIFOMONI0 (*(volatile unsigned long *)0xEAFF9180)
#define DRP_IDIF_DMACNTI1 (*(volatile unsigned long *)0xEAFF9200)
#define DRP_IDIF_BADRI1 (*(volatile unsigned long *)0xEAFF9208)
#define DRP_IDIF_DAMONI1 (*(volatile unsigned long *)0xEAFF920C)
#define DRP_IDIF_DSMONLI1 (*(volatile unsigned long *)0xEAFF9210)
#define DRP_IDIF_STCNTI1 (*(volatile unsigned long *)0xEAFF9214)
#define DRP_IDIF_LCSMONLI1 (*(volatile unsigned long *)0xEAFF921C)
#define DRP_IDIF_LADMONMI1 (*(volatile unsigned long *)0xEAFF9220)
#define DRP_IDIF_LSZMONHI1 (*(volatile unsigned long *)0xEAFF9224)
#define DRP_IDIF_BPCTLI1 (*(volatile unsigned long *)0xEAFF9228)
#define DRP_IDIF_BPSETI1 (*(volatile unsigned long *)0xEAFF922C)
#define DRP_IDIF_BPDISADRI1 (*(volatile unsigned long *)0xEAFF9230)
#define DRP_IDIF_BPACTLI1 (*(volatile unsigned long *)0xEAFF9234)
#define DRP_IDIF_WPMONI1 (*(volatile unsigned long *)0xEAFF9238)
#define DRP_IDIF_RPMONI1 (*(volatile unsigned long *)0xEAFF923C)
#define DRP_IDIF_FIFOMONI1 (*(volatile unsigned long *)0xEAFF9280)
#define DRP_IDIF_DMACNTI2 (*(volatile unsigned long *)0xEAFF9300)
#define DRP_IDIF_BADRI2 (*(volatile unsigned long *)0xEAFF9308)
#define DRP_IDIF_DAMONI2 (*(volatile unsigned long *)0xEAFF930C)
#define DRP_IDIF_DSMONLI2 (*(volatile unsigned long *)0xEAFF9310)
#define DRP_IDIF_STCNTI2 (*(volatile unsigned long *)0xEAFF9314)
#define DRP_IDIF_LCSMONLI2 (*(volatile unsigned long *)0xEAFF931C)
#define DRP_IDIF_LADMONMI2 (*(volatile unsigned long *)0xEAFF9320)
#define DRP_IDIF_LSZMONHI2 (*(volatile unsigned long *)0xEAFF9324)
#define DRP_IDIF_BPCTLI2 (*(volatile unsigned long *)0xEAFF9328)
#define DRP_IDIF_BPSETI2 (*(volatile unsigned long *)0xEAFF932C)
#define DRP_IDIF_BPDISADRI2 (*(volatile unsigned long *)0xEAFF9330)
#define DRP_IDIF_BPACTLI2 (*(volatile unsigned long *)0xEAFF9334)
#define DRP_IDIF_WPMONI2 (*(volatile unsigned long *)0xEAFF9338)
#define DRP_IDIF_RPMONI2 (*(volatile unsigned long *)0xEAFF933C)
#define DRP_IDIF_FIFOMONI2 (*(volatile unsigned long *)0xEAFF9380)
#define DRP_IDIF_DMACNTI3 (*(volatile unsigned long *)0xEAFF9400)
#define DRP_IDIF_BADRI3 (*(volatile unsigned long *)0xEAFF9408)
#define DRP_IDIF_DAMONI3 (*(volatile unsigned long *)0xEAFF940C)
#define DRP_IDIF_DSMONLI3 (*(volatile unsigned long *)0xEAFF9410)
#define DRP_IDIF_STCNTI3 (*(volatile unsigned long *)0xEAFF9414)
#define DRP_IDIF_LCSMONLI3 (*(volatile unsigned long *)0xEAFF941C)
#define DRP_IDIF_LADMONMI3 (*(volatile unsigned long *)0xEAFF9420)
#define DRP_IDIF_LSZMONHI3 (*(volatile unsigned long *)0xEAFF9424)
#define DRP_IDIF_BPCTLI3 (*(volatile unsigned long *)0xEAFF9428)
#define DRP_IDIF_BPSETI3 (*(volatile unsigned long *)0xEAFF942C)
#define DRP_IDIF_BPDISADRI3 (*(volatile unsigned long *)0xEAFF9430)
#define DRP_IDIF_BPACTLI3 (*(volatile unsigned long *)0xEAFF9434)
#define DRP_IDIF_WPMONI3 (*(volatile unsigned long *)0xEAFF9438)
#define DRP_IDIF_RPMONI3 (*(volatile unsigned long *)0xEAFF943C)
#define DRP_IDIF_FIFOMONI3 (*(volatile unsigned long *)0xEAFF9480)
#define DRP_IDIF_DMACNTI4 (*(volatile unsigned long *)0xEAFF9500)
#define DRP_IDIF_BADRI4 (*(volatile unsigned long *)0xEAFF9508)
#define DRP_IDIF_DAMONI4 (*(volatile unsigned long *)0xEAFF950C)
#define DRP_IDIF_DSMONLI4 (*(volatile unsigned long *)0xEAFF9510)
#define DRP_IDIF_STCNTI4 (*(volatile unsigned long *)0xEAFF9514)
#define DRP_IDIF_LCSMONLI4 (*(volatile unsigned long *)0xEAFF951C)
#define DRP_IDIF_LADMONMI4 (*(volatile unsigned long *)0xEAFF9520)
#define DRP_IDIF_LSZMONHI4 (*(volatile unsigned long *)0xEAFF9524)
#define DRP_IDIF_BPCTLI4 (*(volatile unsigned long *)0xEAFF9528)
#define DRP_IDIF_BPSETI4 (*(volatile unsigned long *)0xEAFF952C)
#define DRP_IDIF_BPDISADRI4 (*(volatile unsigned long *)0xEAFF9530)
#define DRP_IDIF_BPACTLI4 (*(volatile unsigned long *)0xEAFF9534)
#define DRP_IDIF_WPMONI4 (*(volatile unsigned long *)0xEAFF9538)
#define DRP_IDIF_RPMONI4 (*(volatile unsigned long *)0xEAFF953C)
#define DRP_IDIF_FIFOMONI4 (*(volatile unsigned long *)0xEAFF9580)
#define DRP_IDIF_DMACNTI5 (*(volatile unsigned long *)0xEAFF9600)
#define DRP_IDIF_BADRI5 (*(volatile unsigned long *)0xEAFF9608)
#define DRP_IDIF_DAMONI5 (*(volatile unsigned long *)0xEAFF960C)
#define DRP_IDIF_DSMONLI5 (*(volatile unsigned long *)0xEAFF9610)
#define DRP_IDIF_STCNTI5 (*(volatile unsigned long *)0xEAFF9614)
#define DRP_IDIF_LCSMONLI5 (*(volatile unsigned long *)0xEAFF961C)
#define DRP_IDIF_LADMONMI5 (*(volatile unsigned long *)0xEAFF9620)
#define DRP_IDIF_LSZMONHI5 (*(volatile unsigned long *)0xEAFF9624)
#define DRP_IDIF_BPCTLI5 (*(volatile unsigned long *)0xEAFF9628)
#define DRP_IDIF_BPSETI5 (*(volatile unsigned long *)0xEAFF962C)
#define DRP_IDIF_BPDISADRI5 (*(volatile unsigned long *)0xEAFF9630)
#define DRP_IDIF_BPACTLI5 (*(volatile unsigned long *)0xEAFF9634)
#define DRP_IDIF_WPMONI5 (*(volatile unsigned long *)0xEAFF9638)
#define DRP_IDIF_RPMONI5 (*(volatile unsigned long *)0xEAFF963C)
#define DRP_IDIF_FIFOMONI5 (*(volatile unsigned long *)0xEAFF9680)
#define DRP_IDIF_DMACNTI6 (*(volatile unsigned long *)0xEAFF9700)
#define DRP_IDIF_BADRI6 (*(volatile unsigned long *)0xEAFF9708)
#define DRP_IDIF_DAMONI6 (*(volatile unsigned long *)0xEAFF970C)
#define DRP_IDIF_DSMONLI6 (*(volatile unsigned long *)0xEAFF9710)
#define DRP_IDIF_STCNTI6 (*(volatile unsigned long *)0xEAFF9714)
#define DRP_IDIF_LCSMONLI6 (*(volatile unsigned long *)0xEAFF971C)
#define DRP_IDIF_LADMONMI6 (*(volatile unsigned long *)0xEAFF9720)
#define DRP_IDIF_LSZMONHI6 (*(volatile unsigned long *)0xEAFF9724)
#define DRP_IDIF_BPCTLI6 (*(volatile unsigned long *)0xEAFF9728)
#define DRP_IDIF_BPSETI6 (*(volatile unsigned long *)0xEAFF972C)
#define DRP_IDIF_BPDISADRI6 (*(volatile unsigned long *)0xEAFF9730)
#define DRP_IDIF_BPACTLI6 (*(volatile unsigned long *)0xEAFF9734)
#define DRP_IDIF_WPMONI6 (*(volatile unsigned long *)0xEAFF9738)
#define DRP_IDIF_RPMONI6 (*(volatile unsigned long *)0xEAFF973C)
#define DRP_IDIF_FIFOMONI6 (*(volatile unsigned long *)0xEAFF9780)
#define DRP_IDIF_DMACNTI7 (*(volatile unsigned long *)0xEAFF9800)
#define DRP_IDIF_BADRI7 (*(volatile unsigned long *)0xEAFF9808)
#define DRP_IDIF_DAMONI7 (*(volatile unsigned long *)0xEAFF980C)
#define DRP_IDIF_DSMONLI7 (*(volatile unsigned long *)0xEAFF9810)
#define DRP_IDIF_STCNTI7 (*(volatile unsigned long *)0xEAFF9814)
#define DRP_IDIF_LCSMONLI7 (*(volatile unsigned long *)0xEAFF981C)
#define DRP_IDIF_LADMONMI7 (*(volatile unsigned long *)0xEAFF9820)
#define DRP_IDIF_LSZMONHI7 (*(volatile unsigned long *)0xEAFF9824)
#define DRP_IDIF_BPCTLI7 (*(volatile unsigned long *)0xEAFF9828)
#define DRP_IDIF_BPSETI7 (*(volatile unsigned long *)0xEAFF982C)
#define DRP_IDIF_BPDISADRI7 (*(volatile unsigned long *)0xEAFF9830)
#define DRP_IDIF_BPACTLI7 (*(volatile unsigned long *)0xEAFF9834)
#define DRP_IDIF_WPMONI7 (*(volatile unsigned long *)0xEAFF9838)
#define DRP_IDIF_RPMONI7 (*(volatile unsigned long *)0xEAFF983C)
#define DRP_IDIF_FIFOMONI7 (*(volatile unsigned long *)0xEAFF9880)
#define DRP_IDIF_DMACNTCW (*(volatile unsigned long *)0xEAFF9900)
#define DRP_IDIF_BADRCW (*(volatile unsigned long *)0xEAFF9908)
#define DRP_IDIF_DAMONCW (*(volatile unsigned long *)0xEAFF990C)
#define DRP_IDIF_DSMONLCW (*(volatile unsigned long *)0xEAFF9910)
#define DRP_IDIF_LCSMONLCW (*(volatile unsigned long *)0xEAFF991C)
#define DRP_IDIF_LADMONMCW (*(volatile unsigned long *)0xEAFF9920)
#define DRP_IDIF_LSZMONHCW (*(volatile unsigned long *)0xEAFF9924)
#define DRP_IDIF_FIFOMONCW (*(volatile unsigned long *)0xEAFF9980)
/* INTMON */
#define DRP_INTSTSMON (*(volatile unsigned long *)0xEAFD8000)
#define DRP_EINTSTSMON (*(volatile unsigned long *)0xEAFD8008)
#define DRP_FIFOSTS0 (*(volatile unsigned long *)0xEAFD8100)
#define DRP_FIFOSTS1 (*(volatile unsigned long *)0xEAFD8104)
#define DRP_FIFOSTS2 (*(volatile unsigned long *)0xEAFD8108)
#define DRP_FIFOSTS3 (*(volatile unsigned long *)0xEAFD810C)
#define DRP_FIFOSTS4 (*(volatile unsigned long *)0xEAFD8110)
#define DRP_FIFOSTS5 (*(volatile unsigned long *)0xEAFD8114)
#define DRP_FIFOSTS6 (*(volatile unsigned long *)0xEAFD8118)
#define DRP_FIFOSTS7 (*(volatile unsigned long *)0xEAFD811C)
/* DSCC */
#define DRP_DSCC_INT (*(volatile unsigned long *)0xEAFF8000)
#define DRP_DSCC_INTMSK (*(volatile unsigned long *)0xEAFF8004)
#define DRP_DSCC_INTMSKSET (*(volatile unsigned long *)0xEAFF8020)
#define DRP_DSCC_INTMSKCLR (*(volatile unsigned long *)0xEAFF8024)
#define DRP_SYNC0STS (*(volatile unsigned long *)0xEAFF8040)
#define DRP_SYNC1STS (*(volatile unsigned long *)0xEAFF8044)
#define DRP_SYNC2STS (*(volatile unsigned long *)0xEAFF8048)
#define DRP_SYNC3STS (*(volatile unsigned long *)0xEAFF804C)
#define DRP_SYNC4STS (*(volatile unsigned long *)0xEAFF8050)
#define DRP_SYNC5STS (*(volatile unsigned long *)0xEAFF8054)
#define DRP_SYNC6STS (*(volatile unsigned long *)0xEAFF8058)
#define DRP_SYNC7STS (*(volatile unsigned long *)0xEAFF805C)
#define DRP_DSCC_IDOFS0 (*(volatile unsigned long *)0xEAFF8080)
#define DRP_DSCC_IDOFS1 (*(volatile unsigned long *)0xEAFF8084)
#define DRP_DSCC_ARBIFMON (*(volatile unsigned long *)0xEAFF8090)
#define DRP_DSCC_ARBIFADRMON (*(volatile unsigned long *)0xEAFF8094)
#define DRP_DSCC_ARBMON (*(volatile unsigned long *)0xEAFF8098)
#define DRP_DSCC_ARBADRMON (*(volatile unsigned long *)0xEAFF809C)
#define DRP_DSCC_DCTLI0 (*(volatile unsigned long *)0xEAFF8100)
#define DRP_DSCC_DPFCI0 (*(volatile unsigned long *)0xEAFF8104)
#define DRP_DSCC_DPAI0 (*(volatile unsigned long *)0xEAFF8108)
#define DRP_DSCC_PAMONI0 (*(volatile unsigned long *)0xEAFF8118)
#define DRP_DSCC_CCMONI0 (*(volatile unsigned long *)0xEAFF8120)
#define DRP_DSCC_DBGMONI0 (*(volatile unsigned long *)0xEAFF8130)
#define DRP_DSCC_DCTLI1 (*(volatile unsigned long *)0xEAFF8140)
#define DRP_DSCC_DPFCI1 (*(volatile unsigned long *)0xEAFF8144)
#define DRP_DSCC_DPAI1 (*(volatile unsigned long *)0xEAFF8148)
#define DRP_DSCC_PAMON1 (*(volatile unsigned long *)0xEAFF8158)
#define DRP_DSCC_CCMON1 (*(volatile unsigned long *)0xEAFF8160)
#define DRP_DSCC_DBGMONI1 (*(volatile unsigned long *)0xEAFF8170)
#define DRP_DSCC_DCTLI2 (*(volatile unsigned long *)0xEAFF8180)
#define DRP_DSCC_DPFCI2 (*(volatile unsigned long *)0xEAFF8184)
#define DRP_DSCC_DPAI2 (*(volatile unsigned long *)0xEAFF8188)
#define DRP_DSCC_PAMONI2 (*(volatile unsigned long *)0xEAFF8198)
#define DRP_DSCC_CCMONI2 (*(volatile unsigned long *)0xEAFF81A0)
#define DRP_DSCC_DBGMONI2 (*(volatile unsigned long *)0xEAFF81B0)
#define DRP_DSCC_DCTLI3 (*(volatile unsigned long *)0xEAFF81C0)
#define DRP_DSCC_DPFCI3 (*(volatile unsigned long *)0xEAFF81C4)
#define DRP_DSCC_DPAI3 (*(volatile unsigned long *)0xEAFF81C8)
#define DRP_DSCC_PAMONI3 (*(volatile unsigned long *)0xEAFF81D8)
#define DRP_DSCC_CCMONI3 (*(volatile unsigned long *)0xEAFF81E0)
#define DRP_DSCC_DBGMONI3 (*(volatile unsigned long *)0xEAFF81F0)
#define DRP_DSCC_DCTLI4 (*(volatile unsigned long *)0xEAFF8200)
#define DRP_DSCC_DPFCI4 (*(volatile unsigned long *)0xEAFF8204)
#define DRP_DSCC_DPAI4 (*(volatile unsigned long *)0xEAFF8208)
#define DRP_DSCC_PAMONI4 (*(volatile unsigned long *)0xEAFF8218)
#define DRP_DSCC_CCMONI4 (*(volatile unsigned long *)0xEAFF8220)
#define DRP_DSCC_DBGMONI4 (*(volatile unsigned long *)0xEAFF8230)
#define DRP_DSCC_DCTLI5 (*(volatile unsigned long *)0xEAFF8240)
#define DRP_DSCC_DPFCI5 (*(volatile unsigned long *)0xEAFF8244)
#define DRP_DSCC_DPAI5 (*(volatile unsigned long *)0xEAFF8248)
#define DRP_DSCC_PAMONI5 (*(volatile unsigned long *)0xEAFF8258)
#define DRP_DSCC_CCMONI5 (*(volatile unsigned long *)0xEAFF8260)
#define DRP_DSCC_DBGMONI5 (*(volatile unsigned long *)0xEAFF8270)
#define DRP_DSCC_DCTLI6 (*(volatile unsigned long *)0xEAFF8280)
#define DRP_DSCC_DPFCI6 (*(volatile unsigned long *)0xEAFF8284)
#define DRP_DSCC_DPAI6 (*(volatile unsigned long *)0xEAFF8288)
#define DRP_DSCC_PAMONI6 (*(volatile unsigned long *)0xEAFF8298)
#define DRP_DSCC_CCMONI6 (*(volatile unsigned long *)0xEAFF82A0)
#define DRP_DSCC_DBGMONI6 (*(volatile unsigned long *)0xEAFF82B0)
#define DRP_DSCC_DCTLI7 (*(volatile unsigned long *)0xEAFF82C0)
#define DRP_DSCC_DPFCI7 (*(volatile unsigned long *)0xEAFF82C4)
#define DRP_DSCC_DPAI7 (*(volatile unsigned long *)0xEAFF82C8)
#define DRP_DSCC_PAMONI7 (*(volatile unsigned long *)0xEAFF82D8)
#define DRP_DSCC_CCMONI7 (*(volatile unsigned long *)0xEAFF82E0)
#define DRP_DSCC_DBGMONI7 (*(volatile unsigned long *)0xEAFF82F0)
/* DRPIF */
#define DRP_T0_ICH0INP_STS (*(volatile unsigned long *)0xEA1D1000)
#define DRP_T0_ICH0INPDATAL (*(volatile unsigned long *)0xEA1D1010)
#define DRP_T0_ICH0INPDATAM (*(volatile unsigned long *)0xEA1D1014)
#define DRP_T0_ICH0INPDATAH (*(volatile unsigned long *)0xEA1D1018)
#define DRP_T0_ICH0FIFO_STS (*(volatile unsigned long *)0xEA1D1030)
#define DRP_T0_ICH0FIFODT1L (*(volatile unsigned long *)0xEA1D1040)
#define DRP_T0_ICH0FIFODT1M (*(volatile unsigned long *)0xEA1D1044)
#define DRP_T0_ICH0FIFODT1H (*(volatile unsigned long *)0xEA1D1048)
#define DRP_T0_ICH0FIFODT2L (*(volatile unsigned long *)0xEA1D1050)
#define DRP_T0_ICH0FIFODT2M (*(volatile unsigned long *)0xEA1D1054)
#define DRP_T0_ICH0FIFODT2H (*(volatile unsigned long *)0xEA1D1058)
#define DRP_T0_ICH1INP_STS (*(volatile unsigned long *)0xEA1D1080)
#define DRP_T0_ICH1INPDATAL (*(volatile unsigned long *)0xEA1D1090)
#define DRP_T0_ICH1INPDATAM (*(volatile unsigned long *)0xEA1D1094)
#define DRP_T0_ICH1INPDATAH (*(volatile unsigned long *)0xEA1D1098)
#define DRP_T0_ICH1FIFO_STS (*(volatile unsigned long *)0xEA1D10B0)
#define DRP_T0_ICH1FIFODT1L (*(volatile unsigned long *)0xEA1D10C0)
#define DRP_T0_ICH1FIFODT1M (*(volatile unsigned long *)0xEA1D10C4)
#define DRP_T0_ICH1FIFODT1H (*(volatile unsigned long *)0xEA1D10C8)
#define DRP_T0_ICH1FIFODT2L (*(volatile unsigned long *)0xEA1D10D0)
#define DRP_T0_ICH1FIFODT2M (*(volatile unsigned long *)0xEA1D10D4)
#define DRP_T0_ICH1FIFODT2H (*(volatile unsigned long *)0xEA1D10D8)
#define DRP_T0_ICH2INP_STS (*(volatile unsigned long *)0xEA1D1100)
#define DRP_T0_ICH2INPDATAL (*(volatile unsigned long *)0xEA1D1110)
#define DRP_T0_ICH2INPDATAM (*(volatile unsigned long *)0xEA1D1114)
#define DRP_T0_ICH2INPDATAH (*(volatile unsigned long *)0xEA1D1118)
#define DRP_T0_ICH2FIFO_STS (*(volatile unsigned long *)0xEA1D1130)
#define DRP_T0_ICH2FIFODT1L (*(volatile unsigned long *)0xEA1D1140)
#define DRP_T0_ICH2FIFODT1M (*(volatile unsigned long *)0xEA1D1144)
#define DRP_T0_ICH2FIFODT1H (*(volatile unsigned long *)0xEA1D1148)
#define DRP_T0_ICH2FIFODT2L (*(volatile unsigned long *)0xEA1D1150)
#define DRP_T0_ICH2FIFODT2M (*(volatile unsigned long *)0xEA1D1154)
#define DRP_T0_ICH2FIFODT2H (*(volatile unsigned long *)0xEA1D1158)
#define DRP_T0_ICH3INP_STS (*(volatile unsigned long *)0xEA1D1180)
#define DRP_T0_ICH3INPDATAL (*(volatile unsigned long *)0xEA1D1190)
#define DRP_T0_ICH3INPDATAM (*(volatile unsigned long *)0xEA1D1194)
#define DRP_T0_ICH3INPDATAH (*(volatile unsigned long *)0xEA1D1198)
#define DRP_T0_ICH3FIFO_STS (*(volatile unsigned long *)0xEA1D11B0)
#define DRP_T0_ICH3FIFODT1L (*(volatile unsigned long *)0xEA1D11C0)
#define DRP_T0_ICH3FIFODT1M (*(volatile unsigned long *)0xEA1D11C4)
#define DRP_T0_ICH3FIFODT1H (*(volatile unsigned long *)0xEA1D11C8)
#define DRP_T0_ICH3FIFODT2L (*(volatile unsigned long *)0xEA1D11D0)
#define DRP_T0_ICH3FIFODT2M (*(volatile unsigned long *)0xEA1D11D4)
#define DRP_T0_ICH3FIFODT2H (*(volatile unsigned long *)0xEA1D11D8)
#define DRP_T0_READCTLSTS (*(volatile unsigned long *)0xEA1D1400)
#define DRP_T0_READCMD (*(volatile unsigned long *)0xEA1D1410)
#define DRP_T0_READADDR (*(volatile unsigned long *)0xEA1D1414)
#define DRP_T0_READSIZE (*(volatile unsigned long *)0xEA1D1418)
#define DRP_T0_READSTRD (*(volatile unsigned long *)0xEA1D141C)
#define DRP_T0_IFIFOCMDSTS (*(volatile unsigned long *)0xEA1D1430)
#define DRP_T0_IFIFOCMD1L (*(volatile unsigned long *)0xEA1D1440)
#define DRP_T0_IFIFOCMD1M (*(volatile unsigned long *)0xEA1D1444)
#define DRP_T0_IFIFOCMD1H (*(volatile unsigned long *)0xEA1D1448)
#define DRP_T0_IFIFOCMD1HH (*(volatile unsigned long *)0xEA1D144C)
#define DRP_T0_IFIFOCMD2L (*(volatile unsigned long *)0xEA1D1450)
#define DRP_T0_IFIFOCMD2M (*(volatile unsigned long *)0xEA1D1454)
#define DRP_T0_IFIFOCMD2H (*(volatile unsigned long *)0xEA1D1458)
#define DRP_T0_IFIFOCMD2HH (*(volatile unsigned long *)0xEA1D145C)
#define DRP_T0_IFIFOCMD3L (*(volatile unsigned long *)0xEA1D1460)
#define DRP_T0_IFIFOCMD3M (*(volatile unsigned long *)0xEA1D1464)
#define DRP_T0_IFIFOCMD3H (*(volatile unsigned long *)0xEA1D1468)
#define DRP_T0_IFIFOCMD3HH (*(volatile unsigned long *)0xEA1D146C)
#define DRP_T0_IFIFOCMD4L (*(volatile unsigned long *)0xEA1D1470)
#define DRP_T0_IFIFOCMD4M (*(volatile unsigned long *)0xEA1D1474)
#define DRP_T0_IFIFOCMD4H (*(volatile unsigned long *)0xEA1D1478)
#define DRP_T0_IFIFOCMD4HH (*(volatile unsigned long *)0xEA1D147C)
#define DRP_T0_ICTRLFLGMON (*(volatile unsigned long *)0xEA1D1600)
#define DRP_T0_ISTPUPDT (*(volatile unsigned long *)0xEA1D1610)
#define DRP_T0_SPAIFTX (*(volatile unsigned long *)0xEA1D1614)
#define DRP_T0_IHOLDCNTCTL (*(volatile unsigned long *)0xEA1D1700)
#define DRP_T0_IHOLDCNT (*(volatile unsigned long *)0xEA1D1704)
#define DRP_T0_DATAREQCTL (*(volatile unsigned long *)0xEA1D1710)
#define DRP_T0_DATAREQCNTL (*(volatile unsigned long *)0xEA1D1714)
#define DRP_T0_DATAREQCNTH (*(volatile unsigned long *)0xEA1D1718)
#define DRP_T0_RCMDVALIDCTL (*(volatile unsigned long *)0xEA1D1720)
#define DRP_T0_RCMDVALIDCNTL (*(volatile unsigned long *)0xEA1D1724)
#define DRP_T0_RCMDVALIDCNTH (*(volatile unsigned long *)0xEA1D1728)
#define DRP_T0_OCH0INP_STS (*(volatile unsigned long *)0xEA1D1800)
#define DRP_T0_OCH0OUTDATAL (*(volatile unsigned long *)0xEA1D1810)
#define DRP_T0_OCH0OUTDATAM (*(volatile unsigned long *)0xEA1D1814)
#define DRP_T0_OCH0OUTDATAH (*(volatile unsigned long *)0xEA1D1818)
#define DRP_T0_OCH0FIFO_STS (*(volatile unsigned long *)0xEA1D1830)
#define DRP_T0_OCH0FIFODT1L (*(volatile unsigned long *)0xEA1D1840)
#define DRP_T0_OCH0FIFODT1M (*(volatile unsigned long *)0xEA1D1844)
#define DRP_T0_OCH0FIFODT1H (*(volatile unsigned long *)0xEA1D1848)
#define DRP_T0_OCH0FIFODT2L (*(volatile unsigned long *)0xEA1D1850)
#define DRP_T0_OCH0FIFODT2M (*(volatile unsigned long *)0xEA1D1854)
#define DRP_T0_OCH0FIFODT2H (*(volatile unsigned long *)0xEA1D1858)
#define DRP_T0_OCH0FIFODT3L (*(volatile unsigned long *)0xEA1D1860)
#define DRP_T0_OCH0FIFODT3M (*(volatile unsigned long *)0xEA1D1864)
#define DRP_T0_OCH0FIFODT3H (*(volatile unsigned long *)0xEA1D1868)
#define DRP_T0_OCH0FIFODT4L (*(volatile unsigned long *)0xEA1D1870)
#define DRP_T0_OCH0FIFODT4M (*(volatile unsigned long *)0xEA1D1874)
#define DRP_T0_OCH0FIFODT4H (*(volatile unsigned long *)0xEA1D1878)
#define DRP_T0_OCH1INP_STS (*(volatile unsigned long *)0xEA1D1880)
#define DRP_T0_OCH1OUTDATAL (*(volatile unsigned long *)0xEA1D1890)
#define DRP_T0_OCH1OUTDATAM (*(volatile unsigned long *)0xEA1D1894)
#define DRP_T0_OCH1OUTDATAH (*(volatile unsigned long *)0xEA1D1898)
#define DRP_T0_OCH1FIFO_STS (*(volatile unsigned long *)0xEA1D18B0)
#define DRP_T0_OCH1FIFODT1L (*(volatile unsigned long *)0xEA1D18C0)
#define DRP_T0_OCH1FIFODT1M (*(volatile unsigned long *)0xEA1D18C4)
#define DRP_T0_OCH1FIFODT1H (*(volatile unsigned long *)0xEA1D18C8)
#define DRP_T0_OCH1FIFODT2L (*(volatile unsigned long *)0xEA1D18D0)
#define DRP_T0_OCH1FIFODT2M (*(volatile unsigned long *)0xEA1D18D4)
#define DRP_T0_OCH1FIFODT2H (*(volatile unsigned long *)0xEA1D18D8)
#define DRP_T0_OCH1FIFODT3L (*(volatile unsigned long *)0xEA1D18E0)
#define DRP_T0_OCH1FIFODT3M (*(volatile unsigned long *)0xEA1D18E4)
#define DRP_T0_OCH1FIFODT3H (*(volatile unsigned long *)0xEA1D18E8)
#define DRP_T0_OCH1FIFODT4L (*(volatile unsigned long *)0xEA1D18F0)
#define DRP_T0_OCH1FIFODT4M (*(volatile unsigned long *)0xEA1D18F4)
#define DRP_T0_OCH1FIFODT4H (*(volatile unsigned long *)0xEA1D18F8)
#define DRP_T0_OCH2INP_STS (*(volatile unsigned long *)0xEA1D1900)
#define DRP_T0_OCH2OUTDATAL (*(volatile unsigned long *)0xEA1D1910)
#define DRP_T0_OCH2OUTDATAM (*(volatile unsigned long *)0xEA1D1914)
#define DRP_T0_OCH2OUTDATAH (*(volatile unsigned long *)0xEA1D1918)
#define DRP_T0_OCH2FIFO_STS (*(volatile unsigned long *)0xEA1D1930)
#define DRP_T0_OCH2FIFODT1L (*(volatile unsigned long *)0xEA1D1940)
#define DRP_T0_OCH2FIFODT1M (*(volatile unsigned long *)0xEA1D1944)
#define DRP_T0_OCH2FIFODT1H (*(volatile unsigned long *)0xEA1D1948)
#define DRP_T0_OCH2FIFODT2L (*(volatile unsigned long *)0xEA1D1950)
#define DRP_T0_OCH2FIFODT2M (*(volatile unsigned long *)0xEA1D1954)
#define DRP_T0_OCH2FIFODT2H (*(volatile unsigned long *)0xEA1D1958)
#define DRP_T0_OCH2FIFODT3L (*(volatile unsigned long *)0xEA1D1960)
#define DRP_T0_OCH2FIFODT3M (*(volatile unsigned long *)0xEA1D1964)
#define DRP_T0_OCH2FIFODT3H (*(volatile unsigned long *)0xEA1D1968)
#define DRP_T0_OCH2FIFODT4L (*(volatile unsigned long *)0xEA1D1970)
#define DRP_T0_OCH2FIFODT4M (*(volatile unsigned long *)0xEA1D1974)
#define DRP_T0_OCH2FIFODT4H (*(volatile unsigned long *)0xEA1D1978)
#define DRP_T0_OCH3INP_STS (*(volatile unsigned long *)0xEA1D1980)
#define DRP_T0_OCH3OUTDATAL (*(volatile unsigned long *)0xEA1D1990)
#define DRP_T0_OCH3OUTDATAM (*(volatile unsigned long *)0xEA1D1994)
#define DRP_T0_OCH3OUTDATAH (*(volatile unsigned long *)0xEA1D1998)
#define DRP_T0_OCH3FIFO_STS (*(volatile unsigned long *)0xEA1D19B0)
#define DRP_T0_OCH3FIFODT1L (*(volatile unsigned long *)0xEA1D19C0)
#define DRP_T0_OCH3FIFODT1M (*(volatile unsigned long *)0xEA1D19C4)
#define DRP_T0_OCH3FIFODT1H (*(volatile unsigned long *)0xEA1D19C8)
#define DRP_T0_OCH3FIFODT2L (*(volatile unsigned long *)0xEA1D19D0)
#define DRP_T0_OCH3FIFODT2M (*(volatile unsigned long *)0xEA1D19D4)
#define DRP_T0_OCH3FIFODT2H (*(volatile unsigned long *)0xEA1D19D8)
#define DRP_T0_OCH3FIFODT3L (*(volatile unsigned long *)0xEA1D19E0)
#define DRP_T0_OCH3FIFODT3M (*(volatile unsigned long *)0xEA1D19E4)
#define DRP_T0_OCH3FIFODT3H (*(volatile unsigned long *)0xEA1D19E8)
#define DRP_T0_OCH3FIFODT4L (*(volatile unsigned long *)0xEA1D19F0)
#define DRP_T0_OCH3FIFODT4M (*(volatile unsigned long *)0xEA1D19F4)
#define DRP_T0_OCH3FIFODT4H (*(volatile unsigned long *)0xEA1D19F8)
#define DRP_T0_WRITECMDSTS (*(volatile unsigned long *)0xEA1D1C00)
#define DRP_T0_WRITECMD (*(volatile unsigned long *)0xEA1D1C10)
#define DRP_T0_WRITEADDR (*(volatile unsigned long *)0xEA1D1C14)
#define DRP_T0_WRITESIZE (*(volatile unsigned long *)0xEA1D1C18)
#define DRP_T0_WRITESTRD (*(volatile unsigned long *)0xEA1D1C1C)
#define DRP_T0_OFIFOCMDSTS (*(volatile unsigned long *)0xEA1D1C30)
#define DRP_T0_OFIFOCMD1L (*(volatile unsigned long *)0xEA1D1C40)
#define DRP_T0_OFIFOCMD1M (*(volatile unsigned long *)0xEA1D1C44)
#define DRP_T0_OFIFOCMD1H (*(volatile unsigned long *)0xEA1D1C48)
#define DRP_T0_OFIFOCMD1HH (*(volatile unsigned long *)0xEA1D1C4C)
#define DRP_T0_OFIFOCMD2L (*(volatile unsigned long *)0xEA1D1C50)
#define DRP_T0_OFIFOCMD2M (*(volatile unsigned long *)0xEA1D1C54)
#define DRP_T0_OFIFOCMD2H (*(volatile unsigned long *)0xEA1D1C58)
#define DRP_T0_OFIFOCMD2HH (*(volatile unsigned long *)0xEA1D1C5C)
#define DRP_T0_OFIFOCMD3L (*(volatile unsigned long *)0xEA1D1C60)
#define DRP_T0_OFIFOCMD3M (*(volatile unsigned long *)0xEA1D1C64)
#define DRP_T0_OFIFOCMD3H (*(volatile unsigned long *)0xEA1D1C68)
#define DRP_T0_OFIFOCMD3HH (*(volatile unsigned long *)0xEA1D1C6C)
#define DRP_T0_OFIFOCMD4L (*(volatile unsigned long *)0xEA1D1C70)
#define DRP_T0_OFIFOCMD4M (*(volatile unsigned long *)0xEA1D1C74)
#define DRP_T0_OFIFOCMD4H (*(volatile unsigned long *)0xEA1D1C78)
#define DRP_T0_OFIFOCMD4HH (*(volatile unsigned long *)0xEA1D1C7C)
#define DRP_T0_OCTRLFLGMON (*(volatile unsigned long *)0xEA1D1E00)
#define DRP_T0_OHOLDCNTCTL (*(volatile unsigned long *)0xEA1D1F00)
#define DRP_T0_OHOLDCNT (*(volatile unsigned long *)0xEA1D1F04)
#define DRP_T0_DATAVALIDCTL (*(volatile unsigned long *)0xEA1D1F10)
#define DRP_T0_DATAVALIDCNTL (*(volatile unsigned long *)0xEA1D1F14)
#define DRP_T0_DATAVALIDCNTH (*(volatile unsigned long *)0xEA1D1F18)
#define DRP_T0_WCMDVALIDCTL (*(volatile unsigned long *)0xEA1D1F20)
#define DRP_T0_WCMDVALIDCNTL (*(volatile unsigned long *)0xEA1D1F24)
#define DRP_T0_WCMDVALIDCNTH (*(volatile unsigned long *)0xEA1D1F28)
#define DRP_T1_ICH0INP_STS (*(volatile unsigned long *)0xEA3D1000)
#define DRP_T1_ICH0INPDATAL (*(volatile unsigned long *)0xEA3D1010)
#define DRP_T1_ICH0INPDATAM (*(volatile unsigned long *)0xEA3D1014)
#define DRP_T1_ICH0INPDATAH (*(volatile unsigned long *)0xEA3D1018)
#define DRP_T1_ICH0FIFO_STS (*(volatile unsigned long *)0xEA3D1030)
#define DRP_T1_ICH0FIFODT1L (*(volatile unsigned long *)0xEA3D1040)
#define DRP_T1_ICH0FIFODT1M (*(volatile unsigned long *)0xEA3D1044)
#define DRP_T1_ICH0FIFODT1H (*(volatile unsigned long *)0xEA3D1048)
#define DRP_T1_ICH0FIFODT2L (*(volatile unsigned long *)0xEA3D1050)
#define DRP_T1_ICH0FIFODT2M (*(volatile unsigned long *)0xEA3D1054)
#define DRP_T1_ICH0FIFODT2H (*(volatile unsigned long *)0xEA3D1058)
#define DRP_T1_ICH1INP_STS (*(volatile unsigned long *)0xEA3D1080)
#define DRP_T1_ICH1INPDATAL (*(volatile unsigned long *)0xEA3D1090)
#define DRP_T1_ICH1INPDATAM (*(volatile unsigned long *)0xEA3D1094)
#define DRP_T1_ICH1INPDATAH (*(volatile unsigned long *)0xEA3D1098)
#define DRP_T1_ICH1FIFO_STS (*(volatile unsigned long *)0xEA3D10B0)
#define DRP_T1_ICH1FIFODT1L (*(volatile unsigned long *)0xEA3D10C0)
#define DRP_T1_ICH1FIFODT1M (*(volatile unsigned long *)0xEA3D10C4)
#define DRP_T1_ICH1FIFODT1H (*(volatile unsigned long *)0xEA3D10C8)
#define DRP_T1_ICH1FIFODT2L (*(volatile unsigned long *)0xEA3D10D0)
#define DRP_T1_ICH1FIFODT2M (*(volatile unsigned long *)0xEA3D10D4)
#define DRP_T1_ICH1FIFODT2H (*(volatile unsigned long *)0xEA3D10D8)
#define DRP_T1_ICH2INP_STS (*(volatile unsigned long *)0xEA3D1100)
#define DRP_T1_ICH2INPDATAL (*(volatile unsigned long *)0xEA3D1110)
#define DRP_T1_ICH2INPDATAM (*(volatile unsigned long *)0xEA3D1114)
#define DRP_T1_ICH2INPDATAH (*(volatile unsigned long *)0xEA3D1118)
#define DRP_T1_ICH2FIFO_STS (*(volatile unsigned long *)0xEA3D1130)
#define DRP_T1_ICH2FIFODT1L (*(volatile unsigned long *)0xEA3D1140)
#define DRP_T1_ICH2FIFODT1M (*(volatile unsigned long *)0xEA3D1144)
#define DRP_T1_ICH2FIFODT1H (*(volatile unsigned long *)0xEA3D1148)
#define DRP_T1_ICH2FIFODT2L (*(volatile unsigned long *)0xEA3D1150)
#define DRP_T1_ICH2FIFODT2M (*(volatile unsigned long *)0xEA3D1154)
#define DRP_T1_ICH2FIFODT2H (*(volatile unsigned long *)0xEA3D1158)
#define DRP_T1_ICH3INP_STS (*(volatile unsigned long *)0xEA3D1180)
#define DRP_T1_ICH3INPDATAL (*(volatile unsigned long *)0xEA3D1190)
#define DRP_T1_ICH3INPDATAM (*(volatile unsigned long *)0xEA3D1194)
#define DRP_T1_ICH3INPDATAH (*(volatile unsigned long *)0xEA3D1198)
#define DRP_T1_ICH3FIFO_STS (*(volatile unsigned long *)0xEA3D11B0)
#define DRP_T1_ICH3FIFODT1L (*(volatile unsigned long *)0xEA3D11C0)
#define DRP_T1_ICH3FIFODT1M (*(volatile unsigned long *)0xEA3D11C4)
#define DRP_T1_ICH3FIFODT1H (*(volatile unsigned long *)0xEA3D11C8)
#define DRP_T1_ICH3FIFODT2L (*(volatile unsigned long *)0xEA3D11D0)
#define DRP_T1_ICH3FIFODT2M (*(volatile unsigned long *)0xEA3D11D4)
#define DRP_T1_ICH3FIFODT2H (*(volatile unsigned long *)0xEA3D11D8)
#define DRP_T1_READCTLSTS (*(volatile unsigned long *)0xEA3D1400)
#define DRP_T1_READCMD (*(volatile unsigned long *)0xEA3D1410)
#define DRP_T1_READADDR (*(volatile unsigned long *)0xEA3D1414)
#define DRP_T1_READSIZE (*(volatile unsigned long *)0xEA3D1418)
#define DRP_T1_READSTRD (*(volatile unsigned long *)0xEA3D141C)
#define DRP_T1_IFIFOCMDSTS (*(volatile unsigned long *)0xEA3D1430)
#define DRP_T1_IFIFOCMD1L (*(volatile unsigned long *)0xEA3D1440)
#define DRP_T1_IFIFOCMD1M (*(volatile unsigned long *)0xEA3D1444)
#define DRP_T1_IFIFOCMD1H (*(volatile unsigned long *)0xEA3D1448)
#define DRP_T1_IFIFOCMD1HH (*(volatile unsigned long *)0xEA3D144C)
#define DRP_T1_IFIFOCMD2L (*(volatile unsigned long *)0xEA3D1450)
#define DRP_T1_IFIFOCMD2M (*(volatile unsigned long *)0xEA3D1454)
#define DRP_T1_IFIFOCMD2H (*(volatile unsigned long *)0xEA3D1458)
#define DRP_T1_IFIFOCMD2HH (*(volatile unsigned long *)0xEA3D145C)
#define DRP_T1_IFIFOCMD3L (*(volatile unsigned long *)0xEA3D1460)
#define DRP_T1_IFIFOCMD3M (*(volatile unsigned long *)0xEA3D1464)
#define DRP_T1_IFIFOCMD3H (*(volatile unsigned long *)0xEA3D1468)
#define DRP_T1_IFIFOCMD3HH (*(volatile unsigned long *)0xEA3D146C)
#define DRP_T1_IFIFOCMD4L (*(volatile unsigned long *)0xEA3D1470)
#define DRP_T1_IFIFOCMD4M (*(volatile unsigned long *)0xEA3D1474)
#define DRP_T1_IFIFOCMD4H (*(volatile unsigned long *)0xEA3D1478)
#define DRP_T1_IFIFOCMD4HH (*(volatile unsigned long *)0xEA3D147C)
#define DRP_T1_ICTRLFLGMON (*(volatile unsigned long *)0xEA3D1600)
#define DRP_T1_ISTPUPDT (*(volatile unsigned long *)0xEA3D1610)
#define DRP_T1_SPAIFTX (*(volatile unsigned long *)0xEA3D1614)
#define DRP_T1_IHOLDCNTCTL (*(volatile unsigned long *)0xEA3D1700)
#define DRP_T1_IHOLDCNT (*(volatile unsigned long *)0xEA3D1704)
#define DRP_T1_DATAREQCTL (*(volatile unsigned long *)0xEA3D1710)
#define DRP_T1_DATAREQCNTL (*(volatile unsigned long *)0xEA3D1714)
#define DRP_T1_DATAREQCNTH (*(volatile unsigned long *)0xEA3D1718)
#define DRP_T1_RCMDVALIDCTL (*(volatile unsigned long *)0xEA3D1720)
#define DRP_T1_RCMDVALIDCNTL (*(volatile unsigned long *)0xEA3D1724)
#define DRP_T1_RCMDVALIDCNTH (*(volatile unsigned long *)0xEA3D1728)
#define DRP_T1_OCH0INP_STS (*(volatile unsigned long *)0xEA3D1800)
#define DRP_T1_OCH0OUTDATAL (*(volatile unsigned long *)0xEA3D1810)
#define DRP_T1_OCH0OUTDATAM (*(volatile unsigned long *)0xEA3D1814)
#define DRP_T1_OCH0OUTDATAH (*(volatile unsigned long *)0xEA3D1818)
#define DRP_T1_OCH0FIFO_STS (*(volatile unsigned long *)0xEA3D1830)
#define DRP_T1_OCH0FIFODT1L (*(volatile unsigned long *)0xEA3D1840)
#define DRP_T1_OCH0FIFODT1M (*(volatile unsigned long *)0xEA3D1844)
#define DRP_T1_OCH0FIFODT1H (*(volatile unsigned long *)0xEA3D1848)
#define DRP_T1_OCH0FIFODT2L (*(volatile unsigned long *)0xEA3D1850)
#define DRP_T1_OCH0FIFODT2M (*(volatile unsigned long *)0xEA3D1854)
#define DRP_T1_OCH0FIFODT2H (*(volatile unsigned long *)0xEA3D1858)
#define DRP_T1_OCH0FIFODT3L (*(volatile unsigned long *)0xEA3D1860)
#define DRP_T1_OCH0FIFODT3M (*(volatile unsigned long *)0xEA3D1864)
#define DRP_T1_OCH0FIFODT3H (*(volatile unsigned long *)0xEA3D1868)
#define DRP_T1_OCH0FIFODT4L (*(volatile unsigned long *)0xEA3D1870)
#define DRP_T1_OCH0FIFODT4M (*(volatile unsigned long *)0xEA3D1874)
#define DRP_T1_OCH0FIFODT4H (*(volatile unsigned long *)0xEA3D1878)
#define DRP_T1_OCH1INP_STS (*(volatile unsigned long *)0xEA3D1880)
#define DRP_T1_OCH1OUTDATAL (*(volatile unsigned long *)0xEA3D1890)
#define DRP_T1_OCH1OUTDATAM (*(volatile unsigned long *)0xEA3D1894)
#define DRP_T1_OCH1OUTDATAH (*(volatile unsigned long *)0xEA3D1898)
#define DRP_T1_OCH1FIFO_STS (*(volatile unsigned long *)0xEA3D18B0)
#define DRP_T1_OCH1FIFODT1L (*(volatile unsigned long *)0xEA3D18C0)
#define DRP_T1_OCH1FIFODT1M (*(volatile unsigned long *)0xEA3D18C4)
#define DRP_T1_OCH1FIFODT1H (*(volatile unsigned long *)0xEA3D18C8)
#define DRP_T1_OCH1FIFODT2L (*(volatile unsigned long *)0xEA3D18D0)
#define DRP_T1_OCH1FIFODT2M (*(volatile unsigned long *)0xEA3D18D4)
#define DRP_T1_OCH1FIFODT2H (*(volatile unsigned long *)0xEA3D18D8)
#define DRP_T1_OCH1FIFODT3L (*(volatile unsigned long *)0xEA3D18E0)
#define DRP_T1_OCH1FIFODT3M (*(volatile unsigned long *)0xEA3D18E4)
#define DRP_T1_OCH1FIFODT3H (*(volatile unsigned long *)0xEA3D18E8)
#define DRP_T1_OCH1FIFODT4L (*(volatile unsigned long *)0xEA3D18F0)
#define DRP_T1_OCH1FIFODT4M (*(volatile unsigned long *)0xEA3D18F4)
#define DRP_T1_OCH1FIFODT4H (*(volatile unsigned long *)0xEA3D18F8)
#define DRP_T1_OCH2INP_STS (*(volatile unsigned long *)0xEA3D1900)
#define DRP_T1_OCH2OUTDATAL (*(volatile unsigned long *)0xEA3D1910)
#define DRP_T1_OCH2OUTDATAM (*(volatile unsigned long *)0xEA3D1914)
#define DRP_T1_OCH2OUTDATAH (*(volatile unsigned long *)0xEA3D1918)
#define DRP_T1_OCH2FIFO_STS (*(volatile unsigned long *)0xEA3D1930)
#define DRP_T1_OCH2FIFODT1L (*(volatile unsigned long *)0xEA3D1940)
#define DRP_T1_OCH2FIFODT1M (*(volatile unsigned long *)0xEA3D1944)
#define DRP_T1_OCH2FIFODT1H (*(volatile unsigned long *)0xEA3D1948)
#define DRP_T1_OCH2FIFODT2L (*(volatile unsigned long *)0xEA3D1950)
#define DRP_T1_OCH2FIFODT2M (*(volatile unsigned long *)0xEA3D1954)
#define DRP_T1_OCH2FIFODT2H (*(volatile unsigned long *)0xEA3D1958)
#define DRP_T1_OCH2FIFODT3L (*(volatile unsigned long *)0xEA3D1960)
#define DRP_T1_OCH2FIFODT3M (*(volatile unsigned long *)0xEA3D1964)
#define DRP_T1_OCH2FIFODT3H (*(volatile unsigned long *)0xEA3D1968)
#define DRP_T1_OCH2FIFODT4L (*(volatile unsigned long *)0xEA3D1970)
#define DRP_T1_OCH2FIFODT4M (*(volatile unsigned long *)0xEA3D1974)
#define DRP_T1_OCH2FIFODT4H (*(volatile unsigned long *)0xEA3D1978)
#define DRP_T1_OCH3INP_STS (*(volatile unsigned long *)0xEA3D1980)
#define DRP_T1_OCH3OUTDATAL (*(volatile unsigned long *)0xEA3D1990)
#define DRP_T1_OCH3OUTDATAM (*(volatile unsigned long *)0xEA3D1994)
#define DRP_T1_OCH3OUTDATAH (*(volatile unsigned long *)0xEA3D1998)
#define DRP_T1_OCH3FIFO_STS (*(volatile unsigned long *)0xEA3D19B0)
#define DRP_T1_OCH3FIFODT1L (*(volatile unsigned long *)0xEA3D19C0)
#define DRP_T1_OCH3FIFODT1M (*(volatile unsigned long *)0xEA3D19C4)
#define DRP_T1_OCH3FIFODT1H (*(volatile unsigned long *)0xEA3D19C8)
#define DRP_T1_OCH3FIFODT2L (*(volatile unsigned long *)0xEA3D19D0)
#define DRP_T1_OCH3FIFODT2M (*(volatile unsigned long *)0xEA3D19D4)
#define DRP_T1_OCH3FIFODT2H (*(volatile unsigned long *)0xEA3D19D8)
#define DRP_T1_OCH3FIFODT3L (*(volatile unsigned long *)0xEA3D19E0)
#define DRP_T1_OCH3FIFODT3M (*(volatile unsigned long *)0xEA3D19E4)
#define DRP_T1_OCH3FIFODT3H (*(volatile unsigned long *)0xEA3D19E8)
#define DRP_T1_OCH3FIFODT4L (*(volatile unsigned long *)0xEA3D19F0)
#define DRP_T1_OCH3FIFODT4M (*(volatile unsigned long *)0xEA3D19F4)
#define DRP_T1_OCH3FIFODT4H (*(volatile unsigned long *)0xEA3D19F8)
#define DRP_T1_WRITECMDSTS (*(volatile unsigned long *)0xEA3D1C00)
#define DRP_T1_WRITECMD (*(volatile unsigned long *)0xEA3D1C10)
#define DRP_T1_WRITEADDR (*(volatile unsigned long *)0xEA3D1C14)
#define DRP_T1_WRITESIZE (*(volatile unsigned long *)0xEA3D1C18)
#define DRP_T1_WRITESTRD (*(volatile unsigned long *)0xEA3D1C1C)
#define DRP_T1_OFIFOCMDSTS (*(volatile unsigned long *)0xEA3D1C30)
#define DRP_T1_OFIFOCMD1L (*(volatile unsigned long *)0xEA3D1C40)
#define DRP_T1_OFIFOCMD1M (*(volatile unsigned long *)0xEA3D1C44)
#define DRP_T1_OFIFOCMD1H (*(volatile unsigned long *)0xEA3D1C48)
#define DRP_T1_OFIFOCMD1HH (*(volatile unsigned long *)0xEA3D1C4C)
#define DRP_T1_OFIFOCMD2L (*(volatile unsigned long *)0xEA3D1C50)
#define DRP_T1_OFIFOCMD2M (*(volatile unsigned long *)0xEA3D1C54)
#define DRP_T1_OFIFOCMD2H (*(volatile unsigned long *)0xEA3D1C58)
#define DRP_T1_OFIFOCMD2HH (*(volatile unsigned long *)0xEA3D1C5C)
#define DRP_T1_OFIFOCMD3L (*(volatile unsigned long *)0xEA3D1C60)
#define DRP_T1_OFIFOCMD3M (*(volatile unsigned long *)0xEA3D1C64)
#define DRP_T1_OFIFOCMD3H (*(volatile unsigned long *)0xEA3D1C68)
#define DRP_T1_OFIFOCMD3HH (*(volatile unsigned long *)0xEA3D1C6C)
#define DRP_T1_OFIFOCMD4L (*(volatile unsigned long *)0xEA3D1C70)
#define DRP_T1_OFIFOCMD4M (*(volatile unsigned long *)0xEA3D1C74)
#define DRP_T1_OFIFOCMD4H (*(volatile unsigned long *)0xEA3D1C78)
#define DRP_T1_OFIFOCMD4HH (*(volatile unsigned long *)0xEA3D1C7C)
#define DRP_T1_OCTRLFLGMON (*(volatile unsigned long *)0xEA3D1E00)
#define DRP_T1_OHOLDCNTCTL (*(volatile unsigned long *)0xEA3D1F00)
#define DRP_T1_OHOLDCNT (*(volatile unsigned long *)0xEA3D1F04)
#define DRP_T1_DATAVALIDCTL (*(volatile unsigned long *)0xEA3D1F10)
#define DRP_T1_DATAVALIDCNTL (*(volatile unsigned long *)0xEA3D1F14)
#define DRP_T1_DATAVALIDCNTH (*(volatile unsigned long *)0xEA3D1F18)
#define DRP_T1_WCMDVALIDCTL (*(volatile unsigned long *)0xEA3D1F20)
#define DRP_T1_WCMDVALIDCNTL (*(volatile unsigned long *)0xEA3D1F24)
#define DRP_T1_WCMDVALIDCNTH (*(volatile unsigned long *)0xEA3D1F28)
#define DRP_T2_ICH0INP_STS (*(volatile unsigned long *)0xEA5D1000)
#define DRP_T2_ICH0INPDATAL (*(volatile unsigned long *)0xEA5D1010)
#define DRP_T2_ICH0INPDATAM (*(volatile unsigned long *)0xEA5D1014)
#define DRP_T2_ICH0INPDATAH (*(volatile unsigned long *)0xEA5D1018)
#define DRP_T2_ICH0FIFO_STS (*(volatile unsigned long *)0xEA5D1030)
#define DRP_T2_ICH0FIFODT1L (*(volatile unsigned long *)0xEA5D1040)
#define DRP_T2_ICH0FIFODT1M (*(volatile unsigned long *)0xEA5D1044)
#define DRP_T2_ICH0FIFODT1H (*(volatile unsigned long *)0xEA5D1048)
#define DRP_T2_ICH0FIFODT2L (*(volatile unsigned long *)0xEA5D1050)
#define DRP_T2_ICH0FIFODT2M (*(volatile unsigned long *)0xEA5D1054)
#define DRP_T2_ICH0FIFODT2H (*(volatile unsigned long *)0xEA5D1058)
#define DRP_T2_ICH1INP_STS (*(volatile unsigned long *)0xEA5D1080)
#define DRP_T2_ICH1INPDATAL (*(volatile unsigned long *)0xEA5D1090)
#define DRP_T2_ICH1INPDATAM (*(volatile unsigned long *)0xEA5D1094)
#define DRP_T2_ICH1INPDATAH (*(volatile unsigned long *)0xEA5D1098)
#define DRP_T2_ICH1FIFO_STS (*(volatile unsigned long *)0xEA5D10B0)
#define DRP_T2_ICH1FIFODT1L (*(volatile unsigned long *)0xEA5D10C0)
#define DRP_T2_ICH1FIFODT1M (*(volatile unsigned long *)0xEA5D10C4)
#define DRP_T2_ICH1FIFODT1H (*(volatile unsigned long *)0xEA5D10C8)
#define DRP_T2_ICH1FIFODT2L (*(volatile unsigned long *)0xEA5D10D0)
#define DRP_T2_ICH1FIFODT2M (*(volatile unsigned long *)0xEA5D10D4)
#define DRP_T2_ICH1FIFODT2H (*(volatile unsigned long *)0xEA5D10D8)
#define DRP_T2_ICH2INP_STS (*(volatile unsigned long *)0xEA5D1100)
#define DRP_T2_ICH2INPDATAL (*(volatile unsigned long *)0xEA5D1110)
#define DRP_T2_ICH2INPDATAM (*(volatile unsigned long *)0xEA5D1114)
#define DRP_T2_ICH2INPDATAH (*(volatile unsigned long *)0xEA5D1118)
#define DRP_T2_ICH2FIFO_STS (*(volatile unsigned long *)0xEA5D1130)
#define DRP_T2_ICH2FIFODT1L (*(volatile unsigned long *)0xEA5D1140)
#define DRP_T2_ICH2FIFODT1M (*(volatile unsigned long *)0xEA5D1144)
#define DRP_T2_ICH2FIFODT1H (*(volatile unsigned long *)0xEA5D1148)
#define DRP_T2_ICH2FIFODT2L (*(volatile unsigned long *)0xEA5D1150)
#define DRP_T2_ICH2FIFODT2M (*(volatile unsigned long *)0xEA5D1154)
#define DRP_T2_ICH2FIFODT2H (*(volatile unsigned long *)0xEA5D1158)
#define DRP_T2_ICH3INP_STS (*(volatile unsigned long *)0xEA5D1180)
#define DRP_T2_ICH3INPDATAL (*(volatile unsigned long *)0xEA5D1190)
#define DRP_T2_ICH3INPDATAM (*(volatile unsigned long *)0xEA5D1194)
#define DRP_T2_ICH3INPDATAH (*(volatile unsigned long *)0xEA5D1198)
#define DRP_T2_ICH3FIFO_STS (*(volatile unsigned long *)0xEA5D11B0)
#define DRP_T2_ICH3FIFODT1L (*(volatile unsigned long *)0xEA5D11C0)
#define DRP_T2_ICH3FIFODT1M (*(volatile unsigned long *)0xEA5D11C4)
#define DRP_T2_ICH3FIFODT1H (*(volatile unsigned long *)0xEA5D11C8)
#define DRP_T2_ICH3FIFODT2L (*(volatile unsigned long *)0xEA5D11D0)
#define DRP_T2_ICH3FIFODT2M (*(volatile unsigned long *)0xEA5D11D4)
#define DRP_T2_ICH3FIFODT2H (*(volatile unsigned long *)0xEA5D11D8)
#define DRP_T2_READCTLSTS (*(volatile unsigned long *)0xEA5D1400)
#define DRP_T2_READCMD (*(volatile unsigned long *)0xEA5D1410)
#define DRP_T2_READADDR (*(volatile unsigned long *)0xEA5D1414)
#define DRP_T2_READSIZE (*(volatile unsigned long *)0xEA5D1418)
#define DRP_T2_READSTRD (*(volatile unsigned long *)0xEA5D141C)
#define DRP_T2_IFIFOCMDSTS (*(volatile unsigned long *)0xEA5D1430)
#define DRP_T2_IFIFOCMD1L (*(volatile unsigned long *)0xEA5D1440)
#define DRP_T2_IFIFOCMD1M (*(volatile unsigned long *)0xEA5D1444)
#define DRP_T2_IFIFOCMD1H (*(volatile unsigned long *)0xEA5D1448)
#define DRP_T2_IFIFOCMD1HH (*(volatile unsigned long *)0xEA5D144C)
#define DRP_T2_IFIFOCMD2L (*(volatile unsigned long *)0xEA5D1450)
#define DRP_T2_IFIFOCMD2M (*(volatile unsigned long *)0xEA5D1454)
#define DRP_T2_IFIFOCMD2H (*(volatile unsigned long *)0xEA5D1458)
#define DRP_T2_IFIFOCMD2HH (*(volatile unsigned long *)0xEA5D145C)
#define DRP_T2_IFIFOCMD3L (*(volatile unsigned long *)0xEA5D1460)
#define DRP_T2_IFIFOCMD3M (*(volatile unsigned long *)0xEA5D1464)
#define DRP_T2_IFIFOCMD3H (*(volatile unsigned long *)0xEA5D1468)
#define DRP_T2_IFIFOCMD3HH (*(volatile unsigned long *)0xEA5D146C)
#define DRP_T2_IFIFOCMD4L (*(volatile unsigned long *)0xEA5D1470)
#define DRP_T2_IFIFOCMD4M (*(volatile unsigned long *)0xEA5D1474)
#define DRP_T2_IFIFOCMD4H (*(volatile unsigned long *)0xEA5D1478)
#define DRP_T2_IFIFOCMD4HH (*(volatile unsigned long *)0xEA5D147C)
#define DRP_T2_ICTRLFLGMON (*(volatile unsigned long *)0xEA5D1600)
#define DRP_T2_ISTPUPDT (*(volatile unsigned long *)0xEA5D1610)
#define DRP_T2_SPAIFTX (*(volatile unsigned long *)0xEA5D1614)
#define DRP_T2_IHOLDCNTCTL (*(volatile unsigned long *)0xEA5D1700)
#define DRP_T2_IHOLDCNT (*(volatile unsigned long *)0xEA5D1704)
#define DRP_T2_DATAREQCTL (*(volatile unsigned long *)0xEA5D1710)
#define DRP_T2_DATAREQCNTL (*(volatile unsigned long *)0xEA5D1714)
#define DRP_T2_DATAREQCNTH (*(volatile unsigned long *)0xEA5D1718)
#define DRP_T2_RCMDVALIDCTL (*(volatile unsigned long *)0xEA5D1720)
#define DRP_T2_RCMDVALIDCNTL (*(volatile unsigned long *)0xEA5D1724)
#define DRP_T2_RCMDVALIDCNTH (*(volatile unsigned long *)0xEA5D1728)
#define DRP_T2_OCH0INP_STS (*(volatile unsigned long *)0xEA5D1800)
#define DRP_T2_OCH0OUTDATAL (*(volatile unsigned long *)0xEA5D1810)
#define DRP_T2_OCH0OUTDATAM (*(volatile unsigned long *)0xEA5D1814)
#define DRP_T2_OCH0OUTDATAH (*(volatile unsigned long *)0xEA5D1818)
#define DRP_T2_OCH0FIFO_STS (*(volatile unsigned long *)0xEA5D1830)
#define DRP_T2_OCH0FIFODT1L (*(volatile unsigned long *)0xEA5D1840)
#define DRP_T2_OCH0FIFODT1M (*(volatile unsigned long *)0xEA5D1844)
#define DRP_T2_OCH0FIFODT1H (*(volatile unsigned long *)0xEA5D1848)
#define DRP_T2_OCH0FIFODT2L (*(volatile unsigned long *)0xEA5D1850)
#define DRP_T2_OCH0FIFODT2M (*(volatile unsigned long *)0xEA5D1854)
#define DRP_T2_OCH0FIFODT2H (*(volatile unsigned long *)0xEA5D1858)
#define DRP_T2_OCH0FIFODT3L (*(volatile unsigned long *)0xEA5D1860)
#define DRP_T2_OCH0FIFODT3M (*(volatile unsigned long *)0xEA5D1864)
#define DRP_T2_OCH0FIFODT3H (*(volatile unsigned long *)0xEA5D1868)
#define DRP_T2_OCH0FIFODT4L (*(volatile unsigned long *)0xEA5D1870)
#define DRP_T2_OCH0FIFODT4M (*(volatile unsigned long *)0xEA5D1874)
#define DRP_T2_OCH0FIFODT4H (*(volatile unsigned long *)0xEA5D1878)
#define DRP_T2_OCH1INP_STS (*(volatile unsigned long *)0xEA5D1880)
#define DRP_T2_OCH1OUTDATAL (*(volatile unsigned long *)0xEA5D1890)
#define DRP_T2_OCH1OUTDATAM (*(volatile unsigned long *)0xEA5D1894)
#define DRP_T2_OCH1OUTDATAH (*(volatile unsigned long *)0xEA5D1898)
#define DRP_T2_OCH1FIFO_STS (*(volatile unsigned long *)0xEA5D18B0)
#define DRP_T2_OCH1FIFODT1L (*(volatile unsigned long *)0xEA5D18C0)
#define DRP_T2_OCH1FIFODT1M (*(volatile unsigned long *)0xEA5D18C4)
#define DRP_T2_OCH1FIFODT1H (*(volatile unsigned long *)0xEA5D18C8)
#define DRP_T2_OCH1FIFODT2L (*(volatile unsigned long *)0xEA5D18D0)
#define DRP_T2_OCH1FIFODT2M (*(volatile unsigned long *)0xEA5D18D4)
#define DRP_T2_OCH1FIFODT2H (*(volatile unsigned long *)0xEA5D18D8)
#define DRP_T2_OCH1FIFODT3L (*(volatile unsigned long *)0xEA5D18E0)
#define DRP_T2_OCH1FIFODT3M (*(volatile unsigned long *)0xEA5D18E4)
#define DRP_T2_OCH1FIFODT3H (*(volatile unsigned long *)0xEA5D18E8)
#define DRP_T2_OCH1FIFODT4L (*(volatile unsigned long *)0xEA5D18F0)
#define DRP_T2_OCH1FIFODT4M (*(volatile unsigned long *)0xEA5D18F4)
#define DRP_T2_OCH1FIFODT4H (*(volatile unsigned long *)0xEA5D18F8)
#define DRP_T2_OCH2INP_STS (*(volatile unsigned long *)0xEA5D1900)
#define DRP_T2_OCH2OUTDATAL (*(volatile unsigned long *)0xEA5D1910)
#define DRP_T2_OCH2OUTDATAM (*(volatile unsigned long *)0xEA5D1914)
#define DRP_T2_OCH2OUTDATAH (*(volatile unsigned long *)0xEA5D1918)
#define DRP_T2_OCH2FIFO_STS (*(volatile unsigned long *)0xEA5D1930)
#define DRP_T2_OCH2FIFODT1L (*(volatile unsigned long *)0xEA5D1940)
#define DRP_T2_OCH2FIFODT1M (*(volatile unsigned long *)0xEA5D1944)
#define DRP_T2_OCH2FIFODT1H (*(volatile unsigned long *)0xEA5D1948)
#define DRP_T2_OCH2FIFODT2L (*(volatile unsigned long *)0xEA5D1950)
#define DRP_T2_OCH2FIFODT2M (*(volatile unsigned long *)0xEA5D1954)
#define DRP_T2_OCH2FIFODT2H (*(volatile unsigned long *)0xEA5D1958)
#define DRP_T2_OCH2FIFODT3L (*(volatile unsigned long *)0xEA5D1960)
#define DRP_T2_OCH2FIFODT3M (*(volatile unsigned long *)0xEA5D1964)
#define DRP_T2_OCH2FIFODT3H (*(volatile unsigned long *)0xEA5D1968)
#define DRP_T2_OCH2FIFODT4L (*(volatile unsigned long *)0xEA5D1970)
#define DRP_T2_OCH2FIFODT4M (*(volatile unsigned long *)0xEA5D1974)
#define DRP_T2_OCH2FIFODT4H (*(volatile unsigned long *)0xEA5D1978)
#define DRP_T2_OCH3INP_STS (*(volatile unsigned long *)0xEA5D1980)
#define DRP_T2_OCH3OUTDATAL (*(volatile unsigned long *)0xEA5D1990)
#define DRP_T2_OCH3OUTDATAM (*(volatile unsigned long *)0xEA5D1994)
#define DRP_T2_OCH3OUTDATAH (*(volatile unsigned long *)0xEA5D1998)
#define DRP_T2_OCH3FIFO_STS (*(volatile unsigned long *)0xEA5D19B0)
#define DRP_T2_OCH3FIFODT1L (*(volatile unsigned long *)0xEA5D19C0)
#define DRP_T2_OCH3FIFODT1M (*(volatile unsigned long *)0xEA5D19C4)
#define DRP_T2_OCH3FIFODT1H (*(volatile unsigned long *)0xEA5D19C8)
#define DRP_T2_OCH3FIFODT2L (*(volatile unsigned long *)0xEA5D19D0)
#define DRP_T2_OCH3FIFODT2M (*(volatile unsigned long *)0xEA5D19D4)
#define DRP_T2_OCH3FIFODT2H (*(volatile unsigned long *)0xEA5D19D8)
#define DRP_T2_OCH3FIFODT3L (*(volatile unsigned long *)0xEA5D19E0)
#define DRP_T2_OCH3FIFODT3M (*(volatile unsigned long *)0xEA5D19E4)
#define DRP_T2_OCH3FIFODT3H (*(volatile unsigned long *)0xEA5D19E8)
#define DRP_T2_OCH3FIFODT4L (*(volatile unsigned long *)0xEA5D19F0)
#define DRP_T2_OCH3FIFODT4M (*(volatile unsigned long *)0xEA5D19F4)
#define DRP_T2_OCH3FIFODT4H (*(volatile unsigned long *)0xEA5D19F8)
#define DRP_T2_WRITECMDSTS (*(volatile unsigned long *)0xEA5D1C00)
#define DRP_T2_WRITECMD (*(volatile unsigned long *)0xEA5D1C10)
#define DRP_T2_WRITEADDR (*(volatile unsigned long *)0xEA5D1C14)
#define DRP_T2_WRITESIZE (*(volatile unsigned long *)0xEA5D1C18)
#define DRP_T2_WRITESTRD (*(volatile unsigned long *)0xEA5D1C1C)
#define DRP_T2_OFIFOCMDSTS (*(volatile unsigned long *)0xEA5D1C30)
#define DRP_T2_OFIFOCMD1L (*(volatile unsigned long *)0xEA5D1C40)
#define DRP_T2_OFIFOCMD1M (*(volatile unsigned long *)0xEA5D1C44)
#define DRP_T2_OFIFOCMD1H (*(volatile unsigned long *)0xEA5D1C48)
#define DRP_T2_OFIFOCMD1HH (*(volatile unsigned long *)0xEA5D1C4C)
#define DRP_T2_OFIFOCMD2L (*(volatile unsigned long *)0xEA5D1C50)
#define DRP_T2_OFIFOCMD2M (*(volatile unsigned long *)0xEA5D1C54)
#define DRP_T2_OFIFOCMD2H (*(volatile unsigned long *)0xEA5D1C58)
#define DRP_T2_OFIFOCMD2HH (*(volatile unsigned long *)0xEA5D1C5C)
#define DRP_T2_OFIFOCMD3L (*(volatile unsigned long *)0xEA5D1C60)
#define DRP_T2_OFIFOCMD3M (*(volatile unsigned long *)0xEA5D1C64)
#define DRP_T2_OFIFOCMD3H (*(volatile unsigned long *)0xEA5D1C68)
#define DRP_T2_OFIFOCMD3HH (*(volatile unsigned long *)0xEA5D1C6C)
#define DRP_T2_OFIFOCMD4L (*(volatile unsigned long *)0xEA5D1C70)
#define DRP_T2_OFIFOCMD4M (*(volatile unsigned long *)0xEA5D1C74)
#define DRP_T2_OFIFOCMD4H (*(volatile unsigned long *)0xEA5D1C78)
#define DRP_T2_OFIFOCMD4HH (*(volatile unsigned long *)0xEA5D1C7C)
#define DRP_T2_OCTRLFLGMON (*(volatile unsigned long *)0xEA5D1E00)
#define DRP_T2_OHOLDCNTCTL (*(volatile unsigned long *)0xEA5D1F00)
#define DRP_T2_OHOLDCNT (*(volatile unsigned long *)0xEA5D1F04)
#define DRP_T2_DATAVALIDCTL (*(volatile unsigned long *)0xEA5D1F10)
#define DRP_T2_DATAVALIDCNTL (*(volatile unsigned long *)0xEA5D1F14)
#define DRP_T2_DATAVALIDCNTH (*(volatile unsigned long *)0xEA5D1F18)
#define DRP_T2_WCMDVALIDCTL (*(volatile unsigned long *)0xEA5D1F20)
#define DRP_T2_WCMDVALIDCNTL (*(volatile unsigned long *)0xEA5D1F24)
#define DRP_T2_WCMDVALIDCNTH (*(volatile unsigned long *)0xEA5D1F28)
#define DRP_T3_ICH0INP_STS (*(volatile unsigned long *)0xEA7D1000)
#define DRP_T3_ICH0INPDATAL (*(volatile unsigned long *)0xEA7D1010)
#define DRP_T3_ICH0INPDATAM (*(volatile unsigned long *)0xEA7D1014)
#define DRP_T3_ICH0INPDATAH (*(volatile unsigned long *)0xEA7D1018)
#define DRP_T3_ICH0FIFO_STS (*(volatile unsigned long *)0xEA7D1030)
#define DRP_T3_ICH0FIFODT1L (*(volatile unsigned long *)0xEA7D1040)
#define DRP_T3_ICH0FIFODT1M (*(volatile unsigned long *)0xEA7D1044)
#define DRP_T3_ICH0FIFODT1H (*(volatile unsigned long *)0xEA7D1048)
#define DRP_T3_ICH0FIFODT2L (*(volatile unsigned long *)0xEA7D1050)
#define DRP_T3_ICH0FIFODT2M (*(volatile unsigned long *)0xEA7D1054)
#define DRP_T3_ICH0FIFODT2H (*(volatile unsigned long *)0xEA7D1058)
#define DRP_T3_ICH1INP_STS (*(volatile unsigned long *)0xEA7D1080)
#define DRP_T3_ICH1INPDATAL (*(volatile unsigned long *)0xEA7D1090)
#define DRP_T3_ICH1INPDATAM (*(volatile unsigned long *)0xEA7D1094)
#define DRP_T3_ICH1INPDATAH (*(volatile unsigned long *)0xEA7D1098)
#define DRP_T3_ICH1FIFO_STS (*(volatile unsigned long *)0xEA7D10B0)
#define DRP_T3_ICH1FIFODT1L (*(volatile unsigned long *)0xEA7D10C0)
#define DRP_T3_ICH1FIFODT1M (*(volatile unsigned long *)0xEA7D10C4)
#define DRP_T3_ICH1FIFODT1H (*(volatile unsigned long *)0xEA7D10C8)
#define DRP_T3_ICH1FIFODT2L (*(volatile unsigned long *)0xEA7D10D0)
#define DRP_T3_ICH1FIFODT2M (*(volatile unsigned long *)0xEA7D10D4)
#define DRP_T3_ICH1FIFODT2H (*(volatile unsigned long *)0xEA7D10D8)
#define DRP_T3_ICH2INP_STS (*(volatile unsigned long *)0xEA7D1100)
#define DRP_T3_ICH2INPDATAL (*(volatile unsigned long *)0xEA7D1110)
#define DRP_T3_ICH2INPDATAM (*(volatile unsigned long *)0xEA7D1114)
#define DRP_T3_ICH2INPDATAH (*(volatile unsigned long *)0xEA7D1118)
#define DRP_T3_ICH2FIFO_STS (*(volatile unsigned long *)0xEA7D1130)
#define DRP_T3_ICH2FIFODT1L (*(volatile unsigned long *)0xEA7D1140)
#define DRP_T3_ICH2FIFODT1M (*(volatile unsigned long *)0xEA7D1144)
#define DRP_T3_ICH2FIFODT1H (*(volatile unsigned long *)0xEA7D1148)
#define DRP_T3_ICH2FIFODT2L (*(volatile unsigned long *)0xEA7D1150)
#define DRP_T3_ICH2FIFODT2M (*(volatile unsigned long *)0xEA7D1154)
#define DRP_T3_ICH2FIFODT2H (*(volatile unsigned long *)0xEA7D1158)
#define DRP_T3_ICH3INP_STS (*(volatile unsigned long *)0xEA7D1180)
#define DRP_T3_ICH3INPDATAL (*(volatile unsigned long *)0xEA7D1190)
#define DRP_T3_ICH3INPDATAM (*(volatile unsigned long *)0xEA7D1194)
#define DRP_T3_ICH3INPDATAH (*(volatile unsigned long *)0xEA7D1198)
#define DRP_T3_ICH3FIFO_STS (*(volatile unsigned long *)0xEA7D11B0)
#define DRP_T3_ICH3FIFODT1L (*(volatile unsigned long *)0xEA7D11C0)
#define DRP_T3_ICH3FIFODT1M (*(volatile unsigned long *)0xEA7D11C4)
#define DRP_T3_ICH3FIFODT1H (*(volatile unsigned long *)0xEA7D11C8)
#define DRP_T3_ICH3FIFODT2L (*(volatile unsigned long *)0xEA7D11D0)
#define DRP_T3_ICH3FIFODT2M (*(volatile unsigned long *)0xEA7D11D4)
#define DRP_T3_ICH3FIFODT2H (*(volatile unsigned long *)0xEA7D11D8)
#define DRP_T3_READCTLSTS (*(volatile unsigned long *)0xEA7D1400)
#define DRP_T3_READCMD (*(volatile unsigned long *)0xEA7D1410)
#define DRP_T3_READADDR (*(volatile unsigned long *)0xEA7D1414)
#define DRP_T3_READSIZE (*(volatile unsigned long *)0xEA7D1418)
#define DRP_T3_READSTRD (*(volatile unsigned long *)0xEA7D141C)
#define DRP_T3_IFIFOCMDSTS (*(volatile unsigned long *)0xEA7D1430)
#define DRP_T3_IFIFOCMD1L (*(volatile unsigned long *)0xEA7D1440)
#define DRP_T3_IFIFOCMD1M (*(volatile unsigned long *)0xEA7D1444)
#define DRP_T3_IFIFOCMD1H (*(volatile unsigned long *)0xEA7D1448)
#define DRP_T3_IFIFOCMD1HH (*(volatile unsigned long *)0xEA7D144C)
#define DRP_T3_IFIFOCMD2L (*(volatile unsigned long *)0xEA7D1450)
#define DRP_T3_IFIFOCMD2M (*(volatile unsigned long *)0xEA7D1454)
#define DRP_T3_IFIFOCMD2H (*(volatile unsigned long *)0xEA7D1458)
#define DRP_T3_IFIFOCMD2HH (*(volatile unsigned long *)0xEA7D145C)
#define DRP_T3_IFIFOCMD3L (*(volatile unsigned long *)0xEA7D1460)
#define DRP_T3_IFIFOCMD3M (*(volatile unsigned long *)0xEA7D1464)
#define DRP_T3_IFIFOCMD3H (*(volatile unsigned long *)0xEA7D1468)
#define DRP_T3_IFIFOCMD3HH (*(volatile unsigned long *)0xEA7D146C)
#define DRP_T3_IFIFOCMD4L (*(volatile unsigned long *)0xEA7D1470)
#define DRP_T3_IFIFOCMD4M (*(volatile unsigned long *)0xEA7D1474)
#define DRP_T3_IFIFOCMD4H (*(volatile unsigned long *)0xEA7D1478)
#define DRP_T3_IFIFOCMD4HH (*(volatile unsigned long *)0xEA7D147C)
#define DRP_T3_ICTRLFLGMON (*(volatile unsigned long *)0xEA7D1600)
#define DRP_T3_ISTPUPDT (*(volatile unsigned long *)0xEA7D1610)
#define DRP_T3_SPAIFTX (*(volatile unsigned long *)0xEA7D1614)
#define DRP_T3_IHOLDCNTCTL (*(volatile unsigned long *)0xEA7D1700)
#define DRP_T3_IHOLDCNT (*(volatile unsigned long *)0xEA7D1704)
#define DRP_T3_DATAREQCTL (*(volatile unsigned long *)0xEA7D1710)
#define DRP_T3_DATAREQCNTL (*(volatile unsigned long *)0xEA7D1714)
#define DRP_T3_DATAREQCNTH (*(volatile unsigned long *)0xEA7D1718)
#define DRP_T3_RCMDVALIDCTL (*(volatile unsigned long *)0xEA7D1720)
#define DRP_T3_RCMDVALIDCNTL (*(volatile unsigned long *)0xEA7D1724)
#define DRP_T3_RCMDVALIDCNTH (*(volatile unsigned long *)0xEA7D1728)
#define DRP_T3_OCH0INP_STS (*(volatile unsigned long *)0xEA7D1800)
#define DRP_T3_OCH0OUTDATAL (*(volatile unsigned long *)0xEA7D1810)
#define DRP_T3_OCH0OUTDATAM (*(volatile unsigned long *)0xEA7D1814)
#define DRP_T3_OCH0OUTDATAH (*(volatile unsigned long *)0xEA7D1818)
#define DRP_T3_OCH0FIFO_STS (*(volatile unsigned long *)0xEA7D1830)
#define DRP_T3_OCH0FIFODT1L (*(volatile unsigned long *)0xEA7D1840)
#define DRP_T3_OCH0FIFODT1M (*(volatile unsigned long *)0xEA7D1844)
#define DRP_T3_OCH0FIFODT1H (*(volatile unsigned long *)0xEA7D1848)
#define DRP_T3_OCH0FIFODT2L (*(volatile unsigned long *)0xEA7D1850)
#define DRP_T3_OCH0FIFODT2M (*(volatile unsigned long *)0xEA7D1854)
#define DRP_T3_OCH0FIFODT2H (*(volatile unsigned long *)0xEA7D1858)
#define DRP_T3_OCH0FIFODT3L (*(volatile unsigned long *)0xEA7D1860)
#define DRP_T3_OCH0FIFODT3M (*(volatile unsigned long *)0xEA7D1864)
#define DRP_T3_OCH0FIFODT3H (*(volatile unsigned long *)0xEA7D1868)
#define DRP_T3_OCH0FIFODT4L (*(volatile unsigned long *)0xEA7D1870)
#define DRP_T3_OCH0FIFODT4M (*(volatile unsigned long *)0xEA7D1874)
#define DRP_T3_OCH0FIFODT4H (*(volatile unsigned long *)0xEA7D1878)
#define DRP_T3_OCH1INP_STS (*(volatile unsigned long *)0xEA7D1880)
#define DRP_T3_OCH1OUTDATAL (*(volatile unsigned long *)0xEA7D1890)
#define DRP_T3_OCH1OUTDATAM (*(volatile unsigned long *)0xEA7D1894)
#define DRP_T3_OCH1OUTDATAH (*(volatile unsigned long *)0xEA7D1898)
#define DRP_T3_OCH1FIFO_STS (*(volatile unsigned long *)0xEA7D18B0)
#define DRP_T3_OCH1FIFODT1L (*(volatile unsigned long *)0xEA7D18C0)
#define DRP_T3_OCH1FIFODT1M (*(volatile unsigned long *)0xEA7D18C4)
#define DRP_T3_OCH1FIFODT1H (*(volatile unsigned long *)0xEA7D18C8)
#define DRP_T3_OCH1FIFODT2L (*(volatile unsigned long *)0xEA7D18D0)
#define DRP_T3_OCH1FIFODT2M (*(volatile unsigned long *)0xEA7D18D4)
#define DRP_T3_OCH1FIFODT2H (*(volatile unsigned long *)0xEA7D18D8)
#define DRP_T3_OCH1FIFODT3L (*(volatile unsigned long *)0xEA7D18E0)
#define DRP_T3_OCH1FIFODT3M (*(volatile unsigned long *)0xEA7D18E4)
#define DRP_T3_OCH1FIFODT3H (*(volatile unsigned long *)0xEA7D18E8)
#define DRP_T3_OCH1FIFODT4L (*(volatile unsigned long *)0xEA7D18F0)
#define DRP_T3_OCH1FIFODT4M (*(volatile unsigned long *)0xEA7D18F4)
#define DRP_T3_OCH1FIFODT4H (*(volatile unsigned long *)0xEA7D18F8)
#define DRP_T3_OCH2INP_STS (*(volatile unsigned long *)0xEA7D1900)
#define DRP_T3_OCH2OUTDATAL (*(volatile unsigned long *)0xEA7D1910)
#define DRP_T3_OCH2OUTDATAM (*(volatile unsigned long *)0xEA7D1914)
#define DRP_T3_OCH2OUTDATAH (*(volatile unsigned long *)0xEA7D1918)
#define DRP_T3_OCH2FIFO_STS (*(volatile unsigned long *)0xEA7D1930)
#define DRP_T3_OCH2FIFODT1L (*(volatile unsigned long *)0xEA7D1940)
#define DRP_T3_OCH2FIFODT1M (*(volatile unsigned long *)0xEA7D1944)
#define DRP_T3_OCH2FIFODT1H (*(volatile unsigned long *)0xEA7D1948)
#define DRP_T3_OCH2FIFODT2L (*(volatile unsigned long *)0xEA7D1950)
#define DRP_T3_OCH2FIFODT2M (*(volatile unsigned long *)0xEA7D1954)
#define DRP_T3_OCH2FIFODT2H (*(volatile unsigned long *)0xEA7D1958)
#define DRP_T3_OCH2FIFODT3L (*(volatile unsigned long *)0xEA7D1960)
#define DRP_T3_OCH2FIFODT3M (*(volatile unsigned long *)0xEA7D1964)
#define DRP_T3_OCH2FIFODT3H (*(volatile unsigned long *)0xEA7D1968)
#define DRP_T3_OCH2FIFODT4L (*(volatile unsigned long *)0xEA7D1970)
#define DRP_T3_OCH2FIFODT4M (*(volatile unsigned long *)0xEA7D1974)
#define DRP_T3_OCH2FIFODT4H (*(volatile unsigned long *)0xEA7D1978)
#define DRP_T3_OCH3INP_STS (*(volatile unsigned long *)0xEA7D1980)
#define DRP_T3_OCH3OUTDATAL (*(volatile unsigned long *)0xEA7D1990)
#define DRP_T3_OCH3OUTDATAM (*(volatile unsigned long *)0xEA7D1994)
#define DRP_T3_OCH3OUTDATAH (*(volatile unsigned long *)0xEA7D1998)
#define DRP_T3_OCH3FIFO_STS (*(volatile unsigned long *)0xEA7D19B0)
#define DRP_T3_OCH3FIFODT1L (*(volatile unsigned long *)0xEA7D19C0)
#define DRP_T3_OCH3FIFODT1M (*(volatile unsigned long *)0xEA7D19C4)
#define DRP_T3_OCH3FIFODT1H (*(volatile unsigned long *)0xEA7D19C8)
#define DRP_T3_OCH3FIFODT2L (*(volatile unsigned long *)0xEA7D19D0)
#define DRP_T3_OCH3FIFODT2M (*(volatile unsigned long *)0xEA7D19D4)
#define DRP_T3_OCH3FIFODT2H (*(volatile unsigned long *)0xEA7D19D8)
#define DRP_T3_OCH3FIFODT3L (*(volatile unsigned long *)0xEA7D19E0)
#define DRP_T3_OCH3FIFODT3M (*(volatile unsigned long *)0xEA7D19E4)
#define DRP_T3_OCH3FIFODT3H (*(volatile unsigned long *)0xEA7D19E8)
#define DRP_T3_OCH3FIFODT4L (*(volatile unsigned long *)0xEA7D19F0)
#define DRP_T3_OCH3FIFODT4M (*(volatile unsigned long *)0xEA7D19F4)
#define DRP_T3_OCH3FIFODT4H (*(volatile unsigned long *)0xEA7D19F8)
#define DRP_T3_WRITECMDSTS (*(volatile unsigned long *)0xEA7D1C00)
#define DRP_T3_WRITECMD (*(volatile unsigned long *)0xEA7D1C10)
#define DRP_T3_WRITEADDR (*(volatile unsigned long *)0xEA7D1C14)
#define DRP_T3_WRITESIZE (*(volatile unsigned long *)0xEA7D1C18)
#define DRP_T3_WRITESTRD (*(volatile unsigned long *)0xEA7D1C1C)
#define DRP_T3_OFIFOCMDSTS (*(volatile unsigned long *)0xEA7D1C30)
#define DRP_T3_OFIFOCMD1L (*(volatile unsigned long *)0xEA7D1C40)
#define DRP_T3_OFIFOCMD1M (*(volatile unsigned long *)0xEA7D1C44)
#define DRP_T3_OFIFOCMD1H (*(volatile unsigned long *)0xEA7D1C48)
#define DRP_T3_OFIFOCMD1HH (*(volatile unsigned long *)0xEA7D1C4C)
#define DRP_T3_OFIFOCMD2L (*(volatile unsigned long *)0xEA7D1C50)
#define DRP_T3_OFIFOCMD2M (*(volatile unsigned long *)0xEA7D1C54)
#define DRP_T3_OFIFOCMD2H (*(volatile unsigned long *)0xEA7D1C58)
#define DRP_T3_OFIFOCMD2HH (*(volatile unsigned long *)0xEA7D1C5C)
#define DRP_T3_OFIFOCMD3L (*(volatile unsigned long *)0xEA7D1C60)
#define DRP_T3_OFIFOCMD3M (*(volatile unsigned long *)0xEA7D1C64)
#define DRP_T3_OFIFOCMD3H (*(volatile unsigned long *)0xEA7D1C68)
#define DRP_T3_OFIFOCMD3HH (*(volatile unsigned long *)0xEA7D1C6C)
#define DRP_T3_OFIFOCMD4L (*(volatile unsigned long *)0xEA7D1C70)
#define DRP_T3_OFIFOCMD4M (*(volatile unsigned long *)0xEA7D1C74)
#define DRP_T3_OFIFOCMD4H (*(volatile unsigned long *)0xEA7D1C78)
#define DRP_T3_OFIFOCMD4HH (*(volatile unsigned long *)0xEA7D1C7C)
#define DRP_T3_OCTRLFLGMON (*(volatile unsigned long *)0xEA7D1E00)
#define DRP_T3_OHOLDCNTCTL (*(volatile unsigned long *)0xEA7D1F00)
#define DRP_T3_OHOLDCNT (*(volatile unsigned long *)0xEA7D1F04)
#define DRP_T3_DATAVALIDCTL (*(volatile unsigned long *)0xEA7D1F10)
#define DRP_T3_DATAVALIDCNTL (*(volatile unsigned long *)0xEA7D1F14)
#define DRP_T3_DATAVALIDCNTH (*(volatile unsigned long *)0xEA7D1F18)
#define DRP_T3_WCMDVALIDCTL (*(volatile unsigned long *)0xEA7D1F20)
#define DRP_T3_WCMDVALIDCNTL (*(volatile unsigned long *)0xEA7D1F24)
#define DRP_T3_WCMDVALIDCNTH (*(volatile unsigned long *)0xEA7D1F28)
#define DRP_T4_ICH0INP_STS (*(volatile unsigned long *)0xEA9D1000)
#define DRP_T4_ICH0INPDATAL (*(volatile unsigned long *)0xEA9D1010)
#define DRP_T4_ICH0INPDATAM (*(volatile unsigned long *)0xEA9D1014)
#define DRP_T4_ICH0INPDATAH (*(volatile unsigned long *)0xEA9D1018)
#define DRP_T4_ICH0FIFO_STS (*(volatile unsigned long *)0xEA9D1030)
#define DRP_T4_ICH0FIFODT1L (*(volatile unsigned long *)0xEA9D1040)
#define DRP_T4_ICH0FIFODT1M (*(volatile unsigned long *)0xEA9D1044)
#define DRP_T4_ICH0FIFODT1H (*(volatile unsigned long *)0xEA9D1048)
#define DRP_T4_ICH0FIFODT2L (*(volatile unsigned long *)0xEA9D1050)
#define DRP_T4_ICH0FIFODT2M (*(volatile unsigned long *)0xEA9D1054)
#define DRP_T4_ICH0FIFODT2H (*(volatile unsigned long *)0xEA9D1058)
#define DRP_T4_ICH1INP_STS (*(volatile unsigned long *)0xEA9D1080)
#define DRP_T4_ICH1INPDATAL (*(volatile unsigned long *)0xEA9D1090)
#define DRP_T4_ICH1INPDATAM (*(volatile unsigned long *)0xEA9D1094)
#define DRP_T4_ICH1INPDATAH (*(volatile unsigned long *)0xEA9D1098)
#define DRP_T4_ICH1FIFO_STS (*(volatile unsigned long *)0xEA9D10B0)
#define DRP_T4_ICH1FIFODT1L (*(volatile unsigned long *)0xEA9D10C0)
#define DRP_T4_ICH1FIFODT1M (*(volatile unsigned long *)0xEA9D10C4)
#define DRP_T4_ICH1FIFODT1H (*(volatile unsigned long *)0xEA9D10C8)
#define DRP_T4_ICH1FIFODT2L (*(volatile unsigned long *)0xEA9D10D0)
#define DRP_T4_ICH1FIFODT2M (*(volatile unsigned long *)0xEA9D10D4)
#define DRP_T4_ICH1FIFODT2H (*(volatile unsigned long *)0xEA9D10D8)
#define DRP_T4_ICH2INP_STS (*(volatile unsigned long *)0xEA9D1100)
#define DRP_T4_ICH2INPDATAL (*(volatile unsigned long *)0xEA9D1110)
#define DRP_T4_ICH2INPDATAM (*(volatile unsigned long *)0xEA9D1114)
#define DRP_T4_ICH2INPDATAH (*(volatile unsigned long *)0xEA9D1118)
#define DRP_T4_ICH2FIFO_STS (*(volatile unsigned long *)0xEA9D1130)
#define DRP_T4_ICH2FIFODT1L (*(volatile unsigned long *)0xEA9D1140)
#define DRP_T4_ICH2FIFODT1M (*(volatile unsigned long *)0xEA9D1144)
#define DRP_T4_ICH2FIFODT1H (*(volatile unsigned long *)0xEA9D1148)
#define DRP_T4_ICH2FIFODT2L (*(volatile unsigned long *)0xEA9D1150)
#define DRP_T4_ICH2FIFODT2M (*(volatile unsigned long *)0xEA9D1154)
#define DRP_T4_ICH2FIFODT2H (*(volatile unsigned long *)0xEA9D1158)
#define DRP_T4_ICH3INP_STS (*(volatile unsigned long *)0xEA9D1180)
#define DRP_T4_ICH3INPDATAL (*(volatile unsigned long *)0xEA9D1190)
#define DRP_T4_ICH3INPDATAM (*(volatile unsigned long *)0xEA9D1194)
#define DRP_T4_ICH3INPDATAH (*(volatile unsigned long *)0xEA9D1198)
#define DRP_T4_ICH3FIFO_STS (*(volatile unsigned long *)0xEA9D11B0)
#define DRP_T4_ICH3FIFODT1L (*(volatile unsigned long *)0xEA9D11C0)
#define DRP_T4_ICH3FIFODT1M (*(volatile unsigned long *)0xEA9D11C4)
#define DRP_T4_ICH3FIFODT1H (*(volatile unsigned long *)0xEA9D11C8)
#define DRP_T4_ICH3FIFODT2L (*(volatile unsigned long *)0xEA9D11D0)
#define DRP_T4_ICH3FIFODT2M (*(volatile unsigned long *)0xEA9D11D4)
#define DRP_T4_ICH3FIFODT2H (*(volatile unsigned long *)0xEA9D11D8)
#define DRP_T4_READCTLSTS (*(volatile unsigned long *)0xEA9D1400)
#define DRP_T4_READCMD (*(volatile unsigned long *)0xEA9D1410)
#define DRP_T4_READADDR (*(volatile unsigned long *)0xEA9D1414)
#define DRP_T4_READSIZE (*(volatile unsigned long *)0xEA9D1418)
#define DRP_T4_READSTRD (*(volatile unsigned long *)0xEA9D141C)
#define DRP_T4_IFIFOCMDSTS (*(volatile unsigned long *)0xEA9D1430)
#define DRP_T4_IFIFOCMD1L (*(volatile unsigned long *)0xEA9D1440)
#define DRP_T4_IFIFOCMD1M (*(volatile unsigned long *)0xEA9D1444)
#define DRP_T4_IFIFOCMD1H (*(volatile unsigned long *)0xEA9D1448)
#define DRP_T4_IFIFOCMD1HH (*(volatile unsigned long *)0xEA9D144C)
#define DRP_T4_IFIFOCMD2L (*(volatile unsigned long *)0xEA9D1450)
#define DRP_T4_IFIFOCMD2M (*(volatile unsigned long *)0xEA9D1454)
#define DRP_T4_IFIFOCMD2H (*(volatile unsigned long *)0xEA9D1458)
#define DRP_T4_IFIFOCMD2HH (*(volatile unsigned long *)0xEA9D145C)
#define DRP_T4_IFIFOCMD3L (*(volatile unsigned long *)0xEA9D1460)
#define DRP_T4_IFIFOCMD3M (*(volatile unsigned long *)0xEA9D1464)
#define DRP_T4_IFIFOCMD3H (*(volatile unsigned long *)0xEA9D1468)
#define DRP_T4_IFIFOCMD3HH (*(volatile unsigned long *)0xEA9D146C)
#define DRP_T4_IFIFOCMD4L (*(volatile unsigned long *)0xEA9D1470)
#define DRP_T4_IFIFOCMD4M (*(volatile unsigned long *)0xEA9D1474)
#define DRP_T4_IFIFOCMD4H (*(volatile unsigned long *)0xEA9D1478)
#define DRP_T4_IFIFOCMD4HH (*(volatile unsigned long *)0xEA9D147C)
#define DRP_T4_ICTRLFLGMON (*(volatile unsigned long *)0xEA9D1600)
#define DRP_T4_ISTPUPDT (*(volatile unsigned long *)0xEA9D1610)
#define DRP_T4_SPAIFTX (*(volatile unsigned long *)0xEA9D1614)
#define DRP_T4_IHOLDCNTCTL (*(volatile unsigned long *)0xEA9D1700)
#define DRP_T4_IHOLDCNT (*(volatile unsigned long *)0xEA9D1704)
#define DRP_T4_DATAREQCTL (*(volatile unsigned long *)0xEA9D1710)
#define DRP_T4_DATAREQCNTL (*(volatile unsigned long *)0xEA9D1714)
#define DRP_T4_DATAREQCNTH (*(volatile unsigned long *)0xEA9D1718)
#define DRP_T4_RCMDVALIDCTL (*(volatile unsigned long *)0xEA9D1720)
#define DRP_T4_RCMDVALIDCNTL (*(volatile unsigned long *)0xEA9D1724)
#define DRP_T4_RCMDVALIDCNTH (*(volatile unsigned long *)0xEA9D1728)
#define DRP_T4_OCH0INP_STS (*(volatile unsigned long *)0xEA9D1800)
#define DRP_T4_OCH0OUTDATAL (*(volatile unsigned long *)0xEA9D1810)
#define DRP_T4_OCH0OUTDATAM (*(volatile unsigned long *)0xEA9D1814)
#define DRP_T4_OCH0OUTDATAH (*(volatile unsigned long *)0xEA9D1818)
#define DRP_T4_OCH0FIFO_STS (*(volatile unsigned long *)0xEA9D1830)
#define DRP_T4_OCH0FIFODT1L (*(volatile unsigned long *)0xEA9D1840)
#define DRP_T4_OCH0FIFODT1M (*(volatile unsigned long *)0xEA9D1844)
#define DRP_T4_OCH0FIFODT1H (*(volatile unsigned long *)0xEA9D1848)
#define DRP_T4_OCH0FIFODT2L (*(volatile unsigned long *)0xEA9D1850)
#define DRP_T4_OCH0FIFODT2M (*(volatile unsigned long *)0xEA9D1854)
#define DRP_T4_OCH0FIFODT2H (*(volatile unsigned long *)0xEA9D1858)
#define DRP_T4_OCH0FIFODT3L (*(volatile unsigned long *)0xEA9D1860)
#define DRP_T4_OCH0FIFODT3M (*(volatile unsigned long *)0xEA9D1864)
#define DRP_T4_OCH0FIFODT3H (*(volatile unsigned long *)0xEA9D1868)
#define DRP_T4_OCH0FIFODT4L (*(volatile unsigned long *)0xEA9D1870)
#define DRP_T4_OCH0FIFODT4M (*(volatile unsigned long *)0xEA9D1874)
#define DRP_T4_OCH0FIFODT4H (*(volatile unsigned long *)0xEA9D1878)
#define DRP_T4_OCH1INP_STS (*(volatile unsigned long *)0xEA9D1880)
#define DRP_T4_OCH1OUTDATAL (*(volatile unsigned long *)0xEA9D1890)
#define DRP_T4_OCH1OUTDATAM (*(volatile unsigned long *)0xEA9D1894)
#define DRP_T4_OCH1OUTDATAH (*(volatile unsigned long *)0xEA9D1898)
#define DRP_T4_OCH1FIFO_STS (*(volatile unsigned long *)0xEA9D18B0)
#define DRP_T4_OCH1FIFODT1L (*(volatile unsigned long *)0xEA9D18C0)
#define DRP_T4_OCH1FIFODT1M (*(volatile unsigned long *)0xEA9D18C4)
#define DRP_T4_OCH1FIFODT1H (*(volatile unsigned long *)0xEA9D18C8)
#define DRP_T4_OCH1FIFODT2L (*(volatile unsigned long *)0xEA9D18D0)
#define DRP_T4_OCH1FIFODT2M (*(volatile unsigned long *)0xEA9D18D4)
#define DRP_T4_OCH1FIFODT2H (*(volatile unsigned long *)0xEA9D18D8)
#define DRP_T4_OCH1FIFODT3L (*(volatile unsigned long *)0xEA9D18E0)
#define DRP_T4_OCH1FIFODT3M (*(volatile unsigned long *)0xEA9D18E4)
#define DRP_T4_OCH1FIFODT3H (*(volatile unsigned long *)0xEA9D18E8)
#define DRP_T4_OCH1FIFODT4L (*(volatile unsigned long *)0xEA9D18F0)
#define DRP_T4_OCH1FIFODT4M (*(volatile unsigned long *)0xEA9D18F4)
#define DRP_T4_OCH1FIFODT4H (*(volatile unsigned long *)0xEA9D18F8)
#define DRP_T4_OCH2INP_STS (*(volatile unsigned long *)0xEA9D1900)
#define DRP_T4_OCH2OUTDATAL (*(volatile unsigned long *)0xEA9D1910)
#define DRP_T4_OCH2OUTDATAM (*(volatile unsigned long *)0xEA9D1914)
#define DRP_T4_OCH2OUTDATAH (*(volatile unsigned long *)0xEA9D1918)
#define DRP_T4_OCH2FIFO_STS (*(volatile unsigned long *)0xEA9D1930)
#define DRP_T4_OCH2FIFODT1L (*(volatile unsigned long *)0xEA9D1940)
#define DRP_T4_OCH2FIFODT1M (*(volatile unsigned long *)0xEA9D1944)
#define DRP_T4_OCH2FIFODT1H (*(volatile unsigned long *)0xEA9D1948)
#define DRP_T4_OCH2FIFODT2L (*(volatile unsigned long *)0xEA9D1950)
#define DRP_T4_OCH2FIFODT2M (*(volatile unsigned long *)0xEA9D1954)
#define DRP_T4_OCH2FIFODT2H (*(volatile unsigned long *)0xEA9D1958)
#define DRP_T4_OCH2FIFODT3L (*(volatile unsigned long *)0xEA9D1960)
#define DRP_T4_OCH2FIFODT3M (*(volatile unsigned long *)0xEA9D1964)
#define DRP_T4_OCH2FIFODT3H (*(volatile unsigned long *)0xEA9D1968)
#define DRP_T4_OCH2FIFODT4L (*(volatile unsigned long *)0xEA9D1970)
#define DRP_T4_OCH2FIFODT4M (*(volatile unsigned long *)0xEA9D1974)
#define DRP_T4_OCH2FIFODT4H (*(volatile unsigned long *)0xEA9D1978)
#define DRP_T4_OCH3INP_STS (*(volatile unsigned long *)0xEA9D1980)
#define DRP_T4_OCH3OUTDATAL (*(volatile unsigned long *)0xEA9D1990)
#define DRP_T4_OCH3OUTDATAM (*(volatile unsigned long *)0xEA9D1994)
#define DRP_T4_OCH3OUTDATAH (*(volatile unsigned long *)0xEA9D1998)
#define DRP_T4_OCH3FIFO_STS (*(volatile unsigned long *)0xEA9D19B0)
#define DRP_T4_OCH3FIFODT1L (*(volatile unsigned long *)0xEA9D19C0)
#define DRP_T4_OCH3FIFODT1M (*(volatile unsigned long *)0xEA9D19C4)
#define DRP_T4_OCH3FIFODT1H (*(volatile unsigned long *)0xEA9D19C8)
#define DRP_T4_OCH3FIFODT2L (*(volatile unsigned long *)0xEA9D19D0)
#define DRP_T4_OCH3FIFODT2M (*(volatile unsigned long *)0xEA9D19D4)
#define DRP_T4_OCH3FIFODT2H (*(volatile unsigned long *)0xEA9D19D8)
#define DRP_T4_OCH3FIFODT3L (*(volatile unsigned long *)0xEA9D19E0)
#define DRP_T4_OCH3FIFODT3M (*(volatile unsigned long *)0xEA9D19E4)
#define DRP_T4_OCH3FIFODT3H (*(volatile unsigned long *)0xEA9D19E8)
#define DRP_T4_OCH3FIFODT4L (*(volatile unsigned long *)0xEA9D19F0)
#define DRP_T4_OCH3FIFODT4M (*(volatile unsigned long *)0xEA9D19F4)
#define DRP_T4_OCH3FIFODT4H (*(volatile unsigned long *)0xEA9D19F8)
#define DRP_T4_WRITECMDSTS (*(volatile unsigned long *)0xEA9D1C00)
#define DRP_T4_WRITECMD (*(volatile unsigned long *)0xEA9D1C10)
#define DRP_T4_WRITEADDR (*(volatile unsigned long *)0xEA9D1C14)
#define DRP_T4_WRITESIZE (*(volatile unsigned long *)0xEA9D1C18)
#define DRP_T4_WRITESTRD (*(volatile unsigned long *)0xEA9D1C1C)
#define DRP_T4_OFIFOCMDSTS (*(volatile unsigned long *)0xEA9D1C30)
#define DRP_T4_OFIFOCMD1L (*(volatile unsigned long *)0xEA9D1C40)
#define DRP_T4_OFIFOCMD1M (*(volatile unsigned long *)0xEA9D1C44)
#define DRP_T4_OFIFOCMD1H (*(volatile unsigned long *)0xEA9D1C48)
#define DRP_T4_OFIFOCMD1HH (*(volatile unsigned long *)0xEA9D1C4C)
#define DRP_T4_OFIFOCMD2L (*(volatile unsigned long *)0xEA9D1C50)
#define DRP_T4_OFIFOCMD2M (*(volatile unsigned long *)0xEA9D1C54)
#define DRP_T4_OFIFOCMD2H (*(volatile unsigned long *)0xEA9D1C58)
#define DRP_T4_OFIFOCMD2HH (*(volatile unsigned long *)0xEA9D1C5C)
#define DRP_T4_OFIFOCMD3L (*(volatile unsigned long *)0xEA9D1C60)
#define DRP_T4_OFIFOCMD3M (*(volatile unsigned long *)0xEA9D1C64)
#define DRP_T4_OFIFOCMD3H (*(volatile unsigned long *)0xEA9D1C68)
#define DRP_T4_OFIFOCMD3HH (*(volatile unsigned long *)0xEA9D1C6C)
#define DRP_T4_OFIFOCMD4L (*(volatile unsigned long *)0xEA9D1C70)
#define DRP_T4_OFIFOCMD4M (*(volatile unsigned long *)0xEA9D1C74)
#define DRP_T4_OFIFOCMD4H (*(volatile unsigned long *)0xEA9D1C78)
#define DRP_T4_OFIFOCMD4HH (*(volatile unsigned long *)0xEA9D1C7C)
#define DRP_T4_OCTRLFLGMON (*(volatile unsigned long *)0xEA9D1E00)
#define DRP_T4_OHOLDCNTCTL (*(volatile unsigned long *)0xEA9D1F00)
#define DRP_T4_OHOLDCNT (*(volatile unsigned long *)0xEA9D1F04)
#define DRP_T4_DATAVALIDCTL (*(volatile unsigned long *)0xEA9D1F10)
#define DRP_T4_DATAVALIDCNTL (*(volatile unsigned long *)0xEA9D1F14)
#define DRP_T4_DATAVALIDCNTH (*(volatile unsigned long *)0xEA9D1F18)
#define DRP_T4_WCMDVALIDCTL (*(volatile unsigned long *)0xEA9D1F20)
#define DRP_T4_WCMDVALIDCNTL (*(volatile unsigned long *)0xEA9D1F24)
#define DRP_T4_WCMDVALIDCNTH (*(volatile unsigned long *)0xEA9D1F28)
#define DRP_T5_ICH0INP_STS (*(volatile unsigned long *)0xEABD1000)
#define DRP_T5_ICH0INPDATAL (*(volatile unsigned long *)0xEABD1010)
#define DRP_T5_ICH0INPDATAM (*(volatile unsigned long *)0xEABD1014)
#define DRP_T5_ICH0INPDATAH (*(volatile unsigned long *)0xEABD1018)
#define DRP_T5_ICH0FIFO_STS (*(volatile unsigned long *)0xEABD1030)
#define DRP_T5_ICH0FIFODT1L (*(volatile unsigned long *)0xEABD1040)
#define DRP_T5_ICH0FIFODT1M (*(volatile unsigned long *)0xEABD1044)
#define DRP_T5_ICH0FIFODT1H (*(volatile unsigned long *)0xEABD1048)
#define DRP_T5_ICH0FIFODT2L (*(volatile unsigned long *)0xEABD1050)
#define DRP_T5_ICH0FIFODT2M (*(volatile unsigned long *)0xEABD1054)
#define DRP_T5_ICH0FIFODT2H (*(volatile unsigned long *)0xEABD1058)
#define DRP_T5_ICH1INP_STS (*(volatile unsigned long *)0xEABD1080)
#define DRP_T5_ICH1INPDATAL (*(volatile unsigned long *)0xEABD1090)
#define DRP_T5_ICH1INPDATAM (*(volatile unsigned long *)0xEABD1094)
#define DRP_T5_ICH1INPDATAH (*(volatile unsigned long *)0xEABD1098)
#define DRP_T5_ICH1FIFO_STS (*(volatile unsigned long *)0xEABD10B0)
#define DRP_T5_ICH1FIFODT1L (*(volatile unsigned long *)0xEABD10C0)
#define DRP_T5_ICH1FIFODT1M (*(volatile unsigned long *)0xEABD10C4)
#define DRP_T5_ICH1FIFODT1H (*(volatile unsigned long *)0xEABD10C8)
#define DRP_T5_ICH1FIFODT2L (*(volatile unsigned long *)0xEABD10D0)
#define DRP_T5_ICH1FIFODT2M (*(volatile unsigned long *)0xEABD10D4)
#define DRP_T5_ICH1FIFODT2H (*(volatile unsigned long *)0xEABD10D8)
#define DRP_T5_ICH2INP_STS (*(volatile unsigned long *)0xEABD1100)
#define DRP_T5_ICH2INPDATAL (*(volatile unsigned long *)0xEABD1110)
#define DRP_T5_ICH2INPDATAM (*(volatile unsigned long *)0xEABD1114)
#define DRP_T5_ICH2INPDATAH (*(volatile unsigned long *)0xEABD1118)
#define DRP_T5_ICH2FIFO_STS (*(volatile unsigned long *)0xEABD1130)
#define DRP_T5_ICH2FIFODT1L (*(volatile unsigned long *)0xEABD1140)
#define DRP_T5_ICH2FIFODT1M (*(volatile unsigned long *)0xEABD1144)
#define DRP_T5_ICH2FIFODT1H (*(volatile unsigned long *)0xEABD1148)
#define DRP_T5_ICH2FIFODT2L (*(volatile unsigned long *)0xEABD1150)
#define DRP_T5_ICH2FIFODT2M (*(volatile unsigned long *)0xEABD1154)
#define DRP_T5_ICH2FIFODT2H (*(volatile unsigned long *)0xEABD1158)
#define DRP_T5_ICH3INP_STS (*(volatile unsigned long *)0xEABD1180)
#define DRP_T5_ICH3INPDATAL (*(volatile unsigned long *)0xEABD1190)
#define DRP_T5_ICH3INPDATAM (*(volatile unsigned long *)0xEABD1194)
#define DRP_T5_ICH3INPDATAH (*(volatile unsigned long *)0xEABD1198)
#define DRP_T5_ICH3FIFO_STS (*(volatile unsigned long *)0xEABD11B0)
#define DRP_T5_ICH3FIFODT1L (*(volatile unsigned long *)0xEABD11C0)
#define DRP_T5_ICH3FIFODT1M (*(volatile unsigned long *)0xEABD11C4)
#define DRP_T5_ICH3FIFODT1H (*(volatile unsigned long *)0xEABD11C8)
#define DRP_T5_ICH3FIFODT2L (*(volatile unsigned long *)0xEABD11D0)
#define DRP_T5_ICH3FIFODT2M (*(volatile unsigned long *)0xEABD11D4)
#define DRP_T5_ICH3FIFODT2H (*(volatile unsigned long *)0xEABD11D8)
#define DRP_T5_READCTLSTS (*(volatile unsigned long *)0xEABD1400)
#define DRP_T5_READCMD (*(volatile unsigned long *)0xEABD1410)
#define DRP_T5_READADDR (*(volatile unsigned long *)0xEABD1414)
#define DRP_T5_READSIZE (*(volatile unsigned long *)0xEABD1418)
#define DRP_T5_READSTRD (*(volatile unsigned long *)0xEABD141C)
#define DRP_T5_IFIFOCMDSTS (*(volatile unsigned long *)0xEABD1430)
#define DRP_T5_IFIFOCMD1L (*(volatile unsigned long *)0xEABD1440)
#define DRP_T5_IFIFOCMD1M (*(volatile unsigned long *)0xEABD1444)
#define DRP_T5_IFIFOCMD1H (*(volatile unsigned long *)0xEABD1448)
#define DRP_T5_IFIFOCMD1HH (*(volatile unsigned long *)0xEABD144C)
#define DRP_T5_IFIFOCMD2L (*(volatile unsigned long *)0xEABD1450)
#define DRP_T5_IFIFOCMD2M (*(volatile unsigned long *)0xEABD1454)
#define DRP_T5_IFIFOCMD2H (*(volatile unsigned long *)0xEABD1458)
#define DRP_T5_IFIFOCMD2HH (*(volatile unsigned long *)0xEABD145C)
#define DRP_T5_IFIFOCMD3L (*(volatile unsigned long *)0xEABD1460)
#define DRP_T5_IFIFOCMD3M (*(volatile unsigned long *)0xEABD1464)
#define DRP_T5_IFIFOCMD3H (*(volatile unsigned long *)0xEABD1468)
#define DRP_T5_IFIFOCMD3HH (*(volatile unsigned long *)0xEABD146C)
#define DRP_T5_IFIFOCMD4L (*(volatile unsigned long *)0xEABD1470)
#define DRP_T5_IFIFOCMD4M (*(volatile unsigned long *)0xEABD1474)
#define DRP_T5_IFIFOCMD4H (*(volatile unsigned long *)0xEABD1478)
#define DRP_T5_IFIFOCMD4HH (*(volatile unsigned long *)0xEABD147C)
#define DRP_T5_ICTRLFLGMON (*(volatile unsigned long *)0xEABD1600)
#define DRP_T5_ISTPUPDT (*(volatile unsigned long *)0xEABD1610)
#define DRP_T5_SPAIFTX (*(volatile unsigned long *)0xEABD1614)
#define DRP_T5_IHOLDCNTCTL (*(volatile unsigned long *)0xEABD1700)
#define DRP_T5_IHOLDCNT (*(volatile unsigned long *)0xEABD1704)
#define DRP_T5_DATAREQCTL (*(volatile unsigned long *)0xEABD1710)
#define DRP_T5_DATAREQCNTL (*(volatile unsigned long *)0xEABD1714)
#define DRP_T5_DATAREQCNTH (*(volatile unsigned long *)0xEABD1718)
#define DRP_T5_RCMDVALIDCTL (*(volatile unsigned long *)0xEABD1720)
#define DRP_T5_RCMDVALIDCNTL (*(volatile unsigned long *)0xEABD1724)
#define DRP_T5_RCMDVALIDCNTH (*(volatile unsigned long *)0xEABD1728)
#define DRP_T5_OCH0INP_STS (*(volatile unsigned long *)0xEABD1800)
#define DRP_T5_OCH0OUTDATAL (*(volatile unsigned long *)0xEABD1810)
#define DRP_T5_OCH0OUTDATAM (*(volatile unsigned long *)0xEABD1814)
#define DRP_T5_OCH0OUTDATAH (*(volatile unsigned long *)0xEABD1818)
#define DRP_T5_OCH0FIFO_STS (*(volatile unsigned long *)0xEABD1830)
#define DRP_T5_OCH0FIFODT1L (*(volatile unsigned long *)0xEABD1840)
#define DRP_T5_OCH0FIFODT1M (*(volatile unsigned long *)0xEABD1844)
#define DRP_T5_OCH0FIFODT1H (*(volatile unsigned long *)0xEABD1848)
#define DRP_T5_OCH0FIFODT2L (*(volatile unsigned long *)0xEABD1850)
#define DRP_T5_OCH0FIFODT2M (*(volatile unsigned long *)0xEABD1854)
#define DRP_T5_OCH0FIFODT2H (*(volatile unsigned long *)0xEABD1858)
#define DRP_T5_OCH0FIFODT3L (*(volatile unsigned long *)0xEABD1860)
#define DRP_T5_OCH0FIFODT3M (*(volatile unsigned long *)0xEABD1864)
#define DRP_T5_OCH0FIFODT3H (*(volatile unsigned long *)0xEABD1868)
#define DRP_T5_OCH0FIFODT4L (*(volatile unsigned long *)0xEABD1870)
#define DRP_T5_OCH0FIFODT4M (*(volatile unsigned long *)0xEABD1874)
#define DRP_T5_OCH0FIFODT4H (*(volatile unsigned long *)0xEABD1878)
#define DRP_T5_OCH1INP_STS (*(volatile unsigned long *)0xEABD1880)
#define DRP_T5_OCH1OUTDATAL (*(volatile unsigned long *)0xEABD1890)
#define DRP_T5_OCH1OUTDATAM (*(volatile unsigned long *)0xEABD1894)
#define DRP_T5_OCH1OUTDATAH (*(volatile unsigned long *)0xEABD1898)
#define DRP_T5_OCH1FIFO_STS (*(volatile unsigned long *)0xEABD18B0)
#define DRP_T5_OCH1FIFODT1L (*(volatile unsigned long *)0xEABD18C0)
#define DRP_T5_OCH1FIFODT1M (*(volatile unsigned long *)0xEABD18C4)
#define DRP_T5_OCH1FIFODT1H (*(volatile unsigned long *)0xEABD18C8)
#define DRP_T5_OCH1FIFODT2L (*(volatile unsigned long *)0xEABD18D0)
#define DRP_T5_OCH1FIFODT2M (*(volatile unsigned long *)0xEABD18D4)
#define DRP_T5_OCH1FIFODT2H (*(volatile unsigned long *)0xEABD18D8)
#define DRP_T5_OCH1FIFODT3L (*(volatile unsigned long *)0xEABD18E0)
#define DRP_T5_OCH1FIFODT3M (*(volatile unsigned long *)0xEABD18E4)
#define DRP_T5_OCH1FIFODT3H (*(volatile unsigned long *)0xEABD18E8)
#define DRP_T5_OCH1FIFODT4L (*(volatile unsigned long *)0xEABD18F0)
#define DRP_T5_OCH1FIFODT4M (*(volatile unsigned long *)0xEABD18F4)
#define DRP_T5_OCH1FIFODT4H (*(volatile unsigned long *)0xEABD18F8)
#define DRP_T5_OCH2INP_STS (*(volatile unsigned long *)0xEABD1900)
#define DRP_T5_OCH2OUTDATAL (*(volatile unsigned long *)0xEABD1910)
#define DRP_T5_OCH2OUTDATAM (*(volatile unsigned long *)0xEABD1914)
#define DRP_T5_OCH2OUTDATAH (*(volatile unsigned long *)0xEABD1918)
#define DRP_T5_OCH2FIFO_STS (*(volatile unsigned long *)0xEABD1930)
#define DRP_T5_OCH2FIFODT1L (*(volatile unsigned long *)0xEABD1940)
#define DRP_T5_OCH2FIFODT1M (*(volatile unsigned long *)0xEABD1944)
#define DRP_T5_OCH2FIFODT1H (*(volatile unsigned long *)0xEABD1948)
#define DRP_T5_OCH2FIFODT2L (*(volatile unsigned long *)0xEABD1950)
#define DRP_T5_OCH2FIFODT2M (*(volatile unsigned long *)0xEABD1954)
#define DRP_T5_OCH2FIFODT2H (*(volatile unsigned long *)0xEABD1958)
#define DRP_T5_OCH2FIFODT3L (*(volatile unsigned long *)0xEABD1960)
#define DRP_T5_OCH2FIFODT3M (*(volatile unsigned long *)0xEABD1964)
#define DRP_T5_OCH2FIFODT3H (*(volatile unsigned long *)0xEABD1968)
#define DRP_T5_OCH2FIFODT4L (*(volatile unsigned long *)0xEABD1970)
#define DRP_T5_OCH2FIFODT4M (*(volatile unsigned long *)0xEABD1974)
#define DRP_T5_OCH2FIFODT4H (*(volatile unsigned long *)0xEABD1978)
#define DRP_T5_OCH3INP_STS (*(volatile unsigned long *)0xEABD1980)
#define DRP_T5_OCH3OUTDATAL (*(volatile unsigned long *)0xEABD1990)
#define DRP_T5_OCH3OUTDATAM (*(volatile unsigned long *)0xEABD1994)
#define DRP_T5_OCH3OUTDATAH (*(volatile unsigned long *)0xEABD1998)
#define DRP_T5_OCH3FIFO_STS (*(volatile unsigned long *)0xEABD19B0)
#define DRP_T5_OCH3FIFODT1L (*(volatile unsigned long *)0xEABD19C0)
#define DRP_T5_OCH3FIFODT1M (*(volatile unsigned long *)0xEABD19C4)
#define DRP_T5_OCH3FIFODT1H (*(volatile unsigned long *)0xEABD19C8)
#define DRP_T5_OCH3FIFODT2L (*(volatile unsigned long *)0xEABD19D0)
#define DRP_T5_OCH3FIFODT2M (*(volatile unsigned long *)0xEABD19D4)
#define DRP_T5_OCH3FIFODT2H (*(volatile unsigned long *)0xEABD19D8)
#define DRP_T5_OCH3FIFODT3L (*(volatile unsigned long *)0xEABD19E0)
#define DRP_T5_OCH3FIFODT3M (*(volatile unsigned long *)0xEABD19E4)
#define DRP_T5_OCH3FIFODT3H (*(volatile unsigned long *)0xEABD19E8)
#define DRP_T5_OCH3FIFODT4L (*(volatile unsigned long *)0xEABD19F0)
#define DRP_T5_OCH3FIFODT4M (*(volatile unsigned long *)0xEABD19F4)
#define DRP_T5_OCH3FIFODT4H (*(volatile unsigned long *)0xEABD19F8)
#define DRP_T5_WRITECMDSTS (*(volatile unsigned long *)0xEABD1C00)
#define DRP_T5_WRITECMD (*(volatile unsigned long *)0xEABD1C10)
#define DRP_T5_WRITEADDR (*(volatile unsigned long *)0xEABD1C14)
#define DRP_T5_WRITESIZE (*(volatile unsigned long *)0xEABD1C18)
#define DRP_T5_WRITESTRD (*(volatile unsigned long *)0xEABD1C1C)
#define DRP_T5_OFIFOCMDSTS (*(volatile unsigned long *)0xEABD1C30)
#define DRP_T5_OFIFOCMD1L (*(volatile unsigned long *)0xEABD1C40)
#define DRP_T5_OFIFOCMD1M (*(volatile unsigned long *)0xEABD1C44)
#define DRP_T5_OFIFOCMD1H (*(volatile unsigned long *)0xEABD1C48)
#define DRP_T5_OFIFOCMD1HH (*(volatile unsigned long *)0xEABD1C4C)
#define DRP_T5_OFIFOCMD2L (*(volatile unsigned long *)0xEABD1C50)
#define DRP_T5_OFIFOCMD2M (*(volatile unsigned long *)0xEABD1C54)
#define DRP_T5_OFIFOCMD2H (*(volatile unsigned long *)0xEABD1C58)
#define DRP_T5_OFIFOCMD2HH (*(volatile unsigned long *)0xEABD1C5C)
#define DRP_T5_OFIFOCMD3L (*(volatile unsigned long *)0xEABD1C60)
#define DRP_T5_OFIFOCMD3M (*(volatile unsigned long *)0xEABD1C64)
#define DRP_T5_OFIFOCMD3H (*(volatile unsigned long *)0xEABD1C68)
#define DRP_T5_OFIFOCMD3HH (*(volatile unsigned long *)0xEABD1C6C)
#define DRP_T5_OFIFOCMD4L (*(volatile unsigned long *)0xEABD1C70)
#define DRP_T5_OFIFOCMD4M (*(volatile unsigned long *)0xEABD1C74)
#define DRP_T5_OFIFOCMD4H (*(volatile unsigned long *)0xEABD1C78)
#define DRP_T5_OFIFOCMD4HH (*(volatile unsigned long *)0xEABD1C7C)
#define DRP_T5_OCTRLFLGMON (*(volatile unsigned long *)0xEABD1E00)
#define DRP_T5_OHOLDCNTCTL (*(volatile unsigned long *)0xEABD1F00)
#define DRP_T5_OHOLDCNT (*(volatile unsigned long *)0xEABD1F04)
#define DRP_T5_DATAVALIDCTL (*(volatile unsigned long *)0xEABD1F10)
#define DRP_T5_DATAVALIDCNTL (*(volatile unsigned long *)0xEABD1F14)
#define DRP_T5_DATAVALIDCNTH (*(volatile unsigned long *)0xEABD1F18)
#define DRP_T5_WCMDVALIDCTL (*(volatile unsigned long *)0xEABD1F20)
#define DRP_T5_WCMDVALIDCNTL (*(volatile unsigned long *)0xEABD1F24)
#define DRP_T5_WCMDVALIDCNTH (*(volatile unsigned long *)0xEABD1F28)
/* ODMACIF */
#define DRP_ODIF_INT (*(volatile unsigned long *)0xEAFFA000)
#define DRP_ODIF_INTMSK (*(volatile unsigned long *)0xEAFFA004)
#define DRP_ODIF_EINT (*(volatile unsigned long *)0xEAFFA008)
#define DRP_ODIF_EINTMSK (*(volatile unsigned long *)0xEAFFA00C)
#define DRP_ODIF_INTMSKSET (*(volatile unsigned long *)0xEAFFA020)
#define DRP_ODIF_INTMSKCLR (*(volatile unsigned long *)0xEAFFA024)
#define DRP_ODIF_EINTMSKSET (*(volatile unsigned long *)0xEAFFA030)
#define DRP_ODIF_EINTMSKCLR (*(volatile unsigned long *)0xEAFFA034)
#define DRP_ODIF_ERRCSMON (*(volatile unsigned long *)0xEAFFA080)
#define DRP_ODIF_ERRADMON (*(volatile unsigned long *)0xEAFFA084)
#define DRP_ODIF_ERRSZMON (*(volatile unsigned long *)0xEAFFA088)
#define DRP_ODIF_ERRMONST (*(volatile unsigned long *)0xEAFFA08C)
#define DRP_ODIF_DMACNTO0 (*(volatile unsigned long *)0xEAFFA100)
#define DRP_ODIF_BADRO0 (*(volatile unsigned long *)0xEAFFA108)
#define DRP_ODIF_DAMONO0 (*(volatile unsigned long *)0xEAFFA10C)
#define DRP_ODIF_DSMONLO0 (*(volatile unsigned long *)0xEAFFA110)
#define DRP_ODIF_STCNTO0 (*(volatile unsigned long *)0xEAFFA114)
#define DRP_ODIF_INTCNTO0 (*(volatile unsigned long *)0xEAFFA118)
#define DRP_ODIF_LCSMONLO0 (*(volatile unsigned long *)0xEAFFA11C)
#define DRP_ODIF_LADMONMO0 (*(volatile unsigned long *)0xEAFFA120)
#define DRP_ODIF_LSZMONHO0 (*(volatile unsigned long *)0xEAFFA124)
#define DRP_ODIF_BPCTLO0 (*(volatile unsigned long *)0xEAFFA128)
#define DRP_ODIF_BPSETO0 (*(volatile unsigned long *)0xEAFFA12C)
#define DRP_ODIF_BPDISADRO0 (*(volatile unsigned long *)0xEAFFA130)
#define DRP_ODIF_BPACTLO0 (*(volatile unsigned long *)0xEAFFA134)
#define DRP_ODIF_WPMONO0 (*(volatile unsigned long *)0xEAFFA138)
#define DRP_ODIF_RPMONO0 (*(volatile unsigned long *)0xEAFFA13C)
#define DRP_ODIF_FIFOMONO0 (*(volatile unsigned long *)0xEAFFA180)
#define DRP_ODIF_DMACNTO1 (*(volatile unsigned long *)0xEAFFA200)
#define DRP_ODIF_BADRO1 (*(volatile unsigned long *)0xEAFFA208)
#define DRP_ODIF_DAMONO1 (*(volatile unsigned long *)0xEAFFA20C)
#define DRP_ODIF_DSMONLO1 (*(volatile unsigned long *)0xEAFFA210)
#define DRP_ODIF_STCNTO1 (*(volatile unsigned long *)0xEAFFA214)
#define DRP_ODIF_INTCNTO1 (*(volatile unsigned long *)0xEAFFA218)
#define DRP_ODIF_LCSMONLO1 (*(volatile unsigned long *)0xEAFFA21C)
#define DRP_ODIF_LADMONMO1 (*(volatile unsigned long *)0xEAFFA220)
#define DRP_ODIF_LSZMONHO1 (*(volatile unsigned long *)0xEAFFA224)
#define DRP_ODIF_BPCTLO1 (*(volatile unsigned long *)0xEAFFA228)
#define DRP_ODIF_BPSETO1 (*(volatile unsigned long *)0xEAFFA22C)
#define DRP_ODIF_BPDISADRO1 (*(volatile unsigned long *)0xEAFFA230)
#define DRP_ODIF_BPACTLO1 (*(volatile unsigned long *)0xEAFFA234)
#define DRP_ODIF_WPMONO1 (*(volatile unsigned long *)0xEAFFA238)
#define DRP_ODIF_RPMONO1 (*(volatile unsigned long *)0xEAFFA23C)
#define DRP_ODIF_FIFOMONO1 (*(volatile unsigned long *)0xEAFFA280)
#define DRP_ODIF_DMACNTO2 (*(volatile unsigned long *)0xEAFFA300)
#define DRP_ODIF_BADRO2 (*(volatile unsigned long *)0xEAFFA308)
#define DRP_ODIF_DAMONO2 (*(volatile unsigned long *)0xEAFFA30C)
#define DRP_ODIF_DSMONLO2 (*(volatile unsigned long *)0xEAFFA310)
#define DRP_ODIF_STCNTO2 (*(volatile unsigned long *)0xEAFFA314)
#define DRP_ODIF_INTCNTO2 (*(volatile unsigned long *)0xEAFFA318)
#define DRP_ODIF_LCSMONLO2 (*(volatile unsigned long *)0xEAFFA31C)
#define DRP_ODIF_LADMONMO2 (*(volatile unsigned long *)0xEAFFA320)
#define DRP_ODIF_LSZMONHO2 (*(volatile unsigned long *)0xEAFFA324)
#define DRP_ODIF_BPCTLO2 (*(volatile unsigned long *)0xEAFFA328)
#define DRP_ODIF_BPSETO2 (*(volatile unsigned long *)0xEAFFA32C)
#define DRP_ODIF_BPDISADRO2 (*(volatile unsigned long *)0xEAFFA330)
#define DRP_ODIF_BPACTLO2 (*(volatile unsigned long *)0xEAFFA334)
#define DRP_ODIF_WPMONO2 (*(volatile unsigned long *)0xEAFFA338)
#define DRP_ODIF_RPMONO2 (*(volatile unsigned long *)0xEAFFA33C)
#define DRP_ODIF_FIFOMONO2 (*(volatile unsigned long *)0xEAFFA380)
#define DRP_ODIF_DMACNTO3 (*(volatile unsigned long *)0xEAFFA400)
#define DRP_ODIF_BADRO3 (*(volatile unsigned long *)0xEAFFA408)
#define DRP_ODIF_DAMONO3 (*(volatile unsigned long *)0xEAFFA40C)
#define DRP_ODIF_DSMONLO3 (*(volatile unsigned long *)0xEAFFA410)
#define DRP_ODIF_STCNTO3 (*(volatile unsigned long *)0xEAFFA414)
#define DRP_ODIF_INTCNTO3 (*(volatile unsigned long *)0xEAFFA418)
#define DRP_ODIF_LCSMONLO3 (*(volatile unsigned long *)0xEAFFA41C)
#define DRP_ODIF_LADMONMO3 (*(volatile unsigned long *)0xEAFFA420)
#define DRP_ODIF_LSZMONHO3 (*(volatile unsigned long *)0xEAFFA424)
#define DRP_ODIF_BPCTLO3 (*(volatile unsigned long *)0xEAFFA428)
#define DRP_ODIF_BPSETO3 (*(volatile unsigned long *)0xEAFFA42C)
#define DRP_ODIF_BPDISADRO3 (*(volatile unsigned long *)0xEAFFA430)
#define DRP_ODIF_BPACTLO3 (*(volatile unsigned long *)0xEAFFA434)
#define DRP_ODIF_WPMONO3 (*(volatile unsigned long *)0xEAFFA438)
#define DRP_ODIF_RPMONO3 (*(volatile unsigned long *)0xEAFFA43C)
#define DRP_ODIF_FIFOMONO3 (*(volatile unsigned long *)0xEAFFA480)
#define DRP_ODIF_DMACNTO4 (*(volatile unsigned long *)0xEAFFA500)
#define DRP_ODIF_BADRO4 (*(volatile unsigned long *)0xEAFFA508)
#define DRP_ODIF_DAMONO4 (*(volatile unsigned long *)0xEAFFA50C)
#define DRP_ODIF_DSMONLO4 (*(volatile unsigned long *)0xEAFFA510)
#define DRP_ODIF_STCNTO4 (*(volatile unsigned long *)0xEAFFA514)
#define DRP_ODIF_INTCNTO4 (*(volatile unsigned long *)0xEAFFA518)
#define DRP_ODIF_LCSMONLO4 (*(volatile unsigned long *)0xEAFFA51C)
#define DRP_ODIF_LADMONMO4 (*(volatile unsigned long *)0xEAFFA520)
#define DRP_ODIF_LSZMONHO4 (*(volatile unsigned long *)0xEAFFA524)
#define DRP_ODIF_BPCTLO4 (*(volatile unsigned long *)0xEAFFA528)
#define DRP_ODIF_BPSETO4 (*(volatile unsigned long *)0xEAFFA52C)
#define DRP_ODIF_BPDISADRO4 (*(volatile unsigned long *)0xEAFFA530)
#define DRP_ODIF_BPACTLO4 (*(volatile unsigned long *)0xEAFFA534)
#define DRP_ODIF_WPMONO4 (*(volatile unsigned long *)0xEAFFA538)
#define DRP_ODIF_RPMONO4 (*(volatile unsigned long *)0xEAFFA53C)
#define DRP_ODIF_FIFOMONO4 (*(volatile unsigned long *)0xEAFFA580)
#define DRP_ODIF_DMACNTO5 (*(volatile unsigned long *)0xEAFFA600)
#define DRP_ODIF_BADRO5 (*(volatile unsigned long *)0xEAFFA608)
#define DRP_ODIF_DAMONO5 (*(volatile unsigned long *)0xEAFFA60C)
#define DRP_ODIF_DSMONLO5 (*(volatile unsigned long *)0xEAFFA610)
#define DRP_ODIF_STCNTO5 (*(volatile unsigned long *)0xEAFFA614)
#define DRP_ODIF_INTCNTO5 (*(volatile unsigned long *)0xEAFFA618)
#define DRP_ODIF_LCSMONLO5 (*(volatile unsigned long *)0xEAFFA61C)
#define DRP_ODIF_LADMONMO5 (*(volatile unsigned long *)0xEAFFA620)
#define DRP_ODIF_LSZMONHO5 (*(volatile unsigned long *)0xEAFFA624)
#define DRP_ODIF_BPCTLO5 (*(volatile unsigned long *)0xEAFFA628)
#define DRP_ODIF_BPSETO5 (*(volatile unsigned long *)0xEAFFA62C)
#define DRP_ODIF_BPDISADRO5 (*(volatile unsigned long *)0xEAFFA630)
#define DRP_ODIF_BPACTLO5 (*(volatile unsigned long *)0xEAFFA634)
#define DRP_ODIF_WPMONO5 (*(volatile unsigned long *)0xEAFFA638)
#define DRP_ODIF_RPMONO5 (*(volatile unsigned long *)0xEAFFA63C)
#define DRP_ODIF_FIFOMONO5 (*(volatile unsigned long *)0xEAFFA680)
#define DRP_ODIF_DMACNTO6 (*(volatile unsigned long *)0xEAFFA700)
#define DRP_ODIF_BADRO6 (*(volatile unsigned long *)0xEAFFA708)
#define DRP_ODIF_DAMONO6 (*(volatile unsigned long *)0xEAFFA70C)
#define DRP_ODIF_DSMONLO6 (*(volatile unsigned long *)0xEAFFA710)
#define DRP_ODIF_STCNTO6 (*(volatile unsigned long *)0xEAFFA714)
#define DRP_ODIF_INTCNTO6 (*(volatile unsigned long *)0xEAFFA718)
#define DRP_ODIF_LCSMONLO6 (*(volatile unsigned long *)0xEAFFA71C)
#define DRP_ODIF_LADMONMO6 (*(volatile unsigned long *)0xEAFFA720)
#define DRP_ODIF_LSZMONHO6 (*(volatile unsigned long *)0xEAFFA724)
#define DRP_ODIF_BPCTLO6 (*(volatile unsigned long *)0xEAFFA728)
#define DRP_ODIF_BPSETO6 (*(volatile unsigned long *)0xEAFFA72C)
#define DRP_ODIF_BPDISADRO6 (*(volatile unsigned long *)0xEAFFA730)
#define DRP_ODIF_BPACTLO6 (*(volatile unsigned long *)0xEAFFA734)
#define DRP_ODIF_WPMONO6 (*(volatile unsigned long *)0xEAFFA738)
#define DRP_ODIF_RPMONO6 (*(volatile unsigned long *)0xEAFFA73C)
#define DRP_ODIF_FIFOMONO6 (*(volatile unsigned long *)0xEAFFA780)
#define DRP_ODIF_DMACNTO7 (*(volatile unsigned long *)0xEAFFA800)
#define DRP_ODIF_BADRO7 (*(volatile unsigned long *)0xEAFFA808)
#define DRP_ODIF_DAMONO7 (*(volatile unsigned long *)0xEAFFA80C)
#define DRP_ODIF_DSMONLO7 (*(volatile unsigned long *)0xEAFFA810)
#define DRP_ODIF_STCNTO7 (*(volatile unsigned long *)0xEAFFA814)
#define DRP_ODIF_INTCNTO7 (*(volatile unsigned long *)0xEAFFA818)
#define DRP_ODIF_LCSMONLO7 (*(volatile unsigned long *)0xEAFFA81C)
#define DRP_ODIF_LADMONMO7 (*(volatile unsigned long *)0xEAFFA820)
#define DRP_ODIF_LSZMONHO7 (*(volatile unsigned long *)0xEAFFA824)
#define DRP_ODIF_BPCTLO7 (*(volatile unsigned long *)0xEAFFA828)
#define DRP_ODIF_BPSETO7 (*(volatile unsigned long *)0xEAFFA82C)
#define DRP_ODIF_BPDISADRO7 (*(volatile unsigned long *)0xEAFFA830)
#define DRP_ODIF_BPACTLO7 (*(volatile unsigned long *)0xEAFFA834)
#define DRP_ODIF_WPMONO7 (*(volatile unsigned long *)0xEAFFA838)
#define DRP_ODIF_RPMONO7 (*(volatile unsigned long *)0xEAFFA83C)
#define DRP_ODIF_FIFOMONO7 (*(volatile unsigned long *)0xEAFFA880)
#define DRP_ODIF_DMACNTCR (*(volatile unsigned long *)0xEAFFA900)
#define DRP_ODIF_BADRCR (*(volatile unsigned long *)0xEAFFA908)
#define DRP_ODIF_DAMONCR (*(volatile unsigned long *)0xEAFFA90C)
#define DRP_ODIF_DSMONLCR (*(volatile unsigned long *)0xEAFFA910)
#define DRP_ODIF_LCSMONLCR (*(volatile unsigned long *)0xEAFFA91C)
#define DRP_ODIF_LADMONMCR (*(volatile unsigned long *)0xEAFFA920)
#define DRP_ODIF_LSZMONHCR (*(volatile unsigned long *)0xEAFFA924)
#define DRP_ODIF_FIFOMONCR (*(volatile unsigned long *)0xEAFFA980)
/* STPC */
#define DRP_SFTRST (*(volatile unsigned long *)0xEAFFD800)
#define DRP_INTSTS (*(volatile unsigned long *)0xEAFFD804)
#define DRP_ERRINTSTS (*(volatile unsigned long *)0xEAFFD808)
#define DRP_CLKE (*(volatile unsigned long *)0xEAFFD810)
#define DRP_DCLKINACT (*(volatile unsigned long *)0xEAFFD820)
/* cfgctrl */
#define DRP_T0_INTOUTMON (*(volatile unsigned long *)0xEA1D2000)
#define DRP_T0_EINTSTS (*(volatile unsigned long *)0xEA1D2008)
#define DRP_T0_EINTMSK (*(volatile unsigned long *)0xEA1D200C)
#define DRP_T0_INTS (*(volatile unsigned long *)0xEA1D2040)
#define DRP_T0_INTSE (*(volatile unsigned long *)0xEA1D2044)
#define DRP_T0_INTE (*(volatile unsigned long *)0xEA1D2048)
#define DRP_T0_INTCLRE (*(volatile unsigned long *)0xEA1D204C)
#define DRP_T0_INTLVL (*(volatile unsigned long *)0xEA1D2050)
#define DRP_T0_INTCLRMODE (*(volatile unsigned long *)0xEA1D2058)
#define DRP_T0_INTOUTSEL (*(volatile unsigned long *)0xEA1D2060)
#define DRP_T0_INTBYPASS (*(volatile unsigned long *)0xEA1D2070)
#define DRP_T0_DMACHE (*(volatile unsigned long *)0xEA1D2100)
#define DRP_T0_FIFODIVCTRL (*(volatile unsigned long *)0xEA1D2104)
#define DRP_T0_SMEMCTRL (*(volatile unsigned long *)0xEA1D2108)
#define DRP_T0_DPMODE (*(volatile unsigned long *)0xEA1D2110)
#define DRP_T0_DPREG0 (*(volatile unsigned long *)0xEA1D2180)
#define DRP_T0_DPREG1 (*(volatile unsigned long *)0xEA1D2184)
#define DRP_T0_DPREG2 (*(volatile unsigned long *)0xEA1D2188)
#define DRP_T0_DPREG3 (*(volatile unsigned long *)0xEA1D218C)
#define DRP_T0_DPREG4 (*(volatile unsigned long *)0xEA1D2190)
#define DRP_T0_DPREG5 (*(volatile unsigned long *)0xEA1D2194)
#define DRP_T0_DPREG6 (*(volatile unsigned long *)0xEA1D2198)
#define DRP_T0_DPREG7 (*(volatile unsigned long *)0xEA1D219C)
#define DRP_T0_SRST (*(volatile unsigned long *)0xEA1D2200)
#define DRP_T0_DW (*(volatile unsigned long *)0xEA1D2210)
#define DRP_T0_TH (*(volatile unsigned long *)0xEA1D2214)
#define DRP_T0_THD (*(volatile unsigned long *)0xEA1D2218)
#define DRP_T0_CONVSTS (*(volatile unsigned long *)0xEA1D221C)
#define DRP_T0_VERSION0 (*(volatile unsigned long *)0xEA1D2300)
#define DRP_T0_VERSION1 (*(volatile unsigned long *)0xEA1D2304)
#define DRP_T0_VERLOCK (*(volatile unsigned long *)0xEA1D2310)
#define DRP_T0_ELC (*(volatile unsigned long *)0xEA1D2400)
#define DRP_T0_CLKSEL (*(volatile unsigned long *)0xEA1D2500)
#define DRP_T0_TILECLKE (*(volatile unsigned long *)0xEA1D2508)
#define DRP_T0_DIV (*(volatile unsigned long *)0xEA1D2510)
#define DRP_T0_DIVLAT (*(volatile unsigned long *)0xEA1D2514)
#define DRP_T0_DFCCTRL (*(volatile unsigned long *)0xEA1D2518)
#define DRP_T0_CLKECTRL (*(volatile unsigned long *)0xEA1D2530)
#define DRP_T1_INTOUTMON (*(volatile unsigned long *)0xEA3D2000)
#define DRP_T1_EINTSTS (*(volatile unsigned long *)0xEA3D2008)
#define DRP_T1_EINTMSK (*(volatile unsigned long *)0xEA3D200C)
#define DRP_T1_INTS (*(volatile unsigned long *)0xEA3D2040)
#define DRP_T1_INTSE (*(volatile unsigned long *)0xEA3D2044)
#define DRP_T1_INTE (*(volatile unsigned long *)0xEA3D2048)
#define DRP_T1_INTCLRE (*(volatile unsigned long *)0xEA3D204C)
#define DRP_T1_INTLVL (*(volatile unsigned long *)0xEA3D2050)
#define DRP_T1_INTCLRMODE (*(volatile unsigned long *)0xEA3D2058)
#define DRP_T1_INTOUTSEL (*(volatile unsigned long *)0xEA3D2060)
#define DRP_T1_INTBYPASS (*(volatile unsigned long *)0xEA3D2070)
#define DRP_T1_DMACHE (*(volatile unsigned long *)0xEA3D2100)
#define DRP_T1_FIFODIVCTRL (*(volatile unsigned long *)0xEA3D2104)
#define DRP_T1_SMEMCTRL (*(volatile unsigned long *)0xEA3D2108)
#define DRP_T1_DPMODE (*(volatile unsigned long *)0xEA3D2110)
#define DRP_T1_DPREG0 (*(volatile unsigned long *)0xEA3D2180)
#define DRP_T1_DPREG1 (*(volatile unsigned long *)0xEA3D2184)
#define DRP_T1_DPREG2 (*(volatile unsigned long *)0xEA3D2188)
#define DRP_T1_DPREG3 (*(volatile unsigned long *)0xEA3D218C)
#define DRP_T1_DPREG4 (*(volatile unsigned long *)0xEA3D2190)
#define DRP_T1_DPREG5 (*(volatile unsigned long *)0xEA3D2194)
#define DRP_T1_DPREG6 (*(volatile unsigned long *)0xEA3D2198)
#define DRP_T1_DPREG7 (*(volatile unsigned long *)0xEA3D219C)
#define DRP_T1_SRST (*(volatile unsigned long *)0xEA3D2200)
#define DRP_T1_DW (*(volatile unsigned long *)0xEA3D2210)
#define DRP_T1_TH (*(volatile unsigned long *)0xEA3D2214)
#define DRP_T1_THD (*(volatile unsigned long *)0xEA3D2218)
#define DRP_T1_CONVSTS (*(volatile unsigned long *)0xEA3D221C)
#define DRP_T1_VERSION0 (*(volatile unsigned long *)0xEA3D2300)
#define DRP_T1_VERSION1 (*(volatile unsigned long *)0xEA3D2304)
#define DRP_T1_VERLOCK (*(volatile unsigned long *)0xEA3D2310)
#define DRP_T1_ELC (*(volatile unsigned long *)0xEA3D2400)
#define DRP_T1_CLKSEL (*(volatile unsigned long *)0xEA3D2500)
#define DRP_T1_TILECLKE (*(volatile unsigned long *)0xEA3D2508)
#define DRP_T1_DIV (*(volatile unsigned long *)0xEA3D2510)
#define DRP_T1_DIVLAT (*(volatile unsigned long *)0xEA3D2514)
#define DRP_T1_DFCCTRL (*(volatile unsigned long *)0xEA3D2518)
#define DRP_T1_CLKECTRL (*(volatile unsigned long *)0xEA3D2530)
#define DRP_T2_INTOUTMON (*(volatile unsigned long *)0xEA5D2000)
#define DRP_T2_EINTSTS (*(volatile unsigned long *)0xEA5D2008)
#define DRP_T2_EINTMSK (*(volatile unsigned long *)0xEA5D200C)
#define DRP_T2_INTS (*(volatile unsigned long *)0xEA5D2040)
#define DRP_T2_INTSE (*(volatile unsigned long *)0xEA5D2044)
#define DRP_T2_INTE (*(volatile unsigned long *)0xEA5D2048)
#define DRP_T2_INTCLRE (*(volatile unsigned long *)0xEA5D204C)
#define DRP_T2_INTLVL (*(volatile unsigned long *)0xEA5D2050)
#define DRP_T2_INTCLRMODE (*(volatile unsigned long *)0xEA5D2058)
#define DRP_T2_INTOUTSEL (*(volatile unsigned long *)0xEA5D2060)
#define DRP_T2_INTBYPASS (*(volatile unsigned long *)0xEA5D2070)
#define DRP_T2_DMACHE (*(volatile unsigned long *)0xEA5D2100)
#define DRP_T2_FIFODIVCTRL (*(volatile unsigned long *)0xEA5D2104)
#define DRP_T2_SMEMCTRL (*(volatile unsigned long *)0xEA5D2108)
#define DRP_T2_DPMODE (*(volatile unsigned long *)0xEA5D2110)
#define DRP_T2_DPREG0 (*(volatile unsigned long *)0xEA5D2180)
#define DRP_T2_DPREG1 (*(volatile unsigned long *)0xEA5D2184)
#define DRP_T2_DPREG2 (*(volatile unsigned long *)0xEA5D2188)
#define DRP_T2_DPREG3 (*(volatile unsigned long *)0xEA5D218C)
#define DRP_T2_DPREG4 (*(volatile unsigned long *)0xEA5D2190)
#define DRP_T2_DPREG5 (*(volatile unsigned long *)0xEA5D2194)
#define DRP_T2_DPREG6 (*(volatile unsigned long *)0xEA5D2198)
#define DRP_T2_DPREG7 (*(volatile unsigned long *)0xEA5D219C)
#define DRP_T2_SRST (*(volatile unsigned long *)0xEA5D2200)
#define DRP_T2_DW (*(volatile unsigned long *)0xEA5D2210)
#define DRP_T2_TH (*(volatile unsigned long *)0xEA5D2214)
#define DRP_T2_THD (*(volatile unsigned long *)0xEA5D2218)
#define DRP_T2_CONVSTS (*(volatile unsigned long *)0xEA5D221C)
#define DRP_T2_VERSION0 (*(volatile unsigned long *)0xEA5D2300)
#define DRP_T2_VERSION1 (*(volatile unsigned long *)0xEA5D2304)
#define DRP_T2_VERLOCK (*(volatile unsigned long *)0xEA5D2310)
#define DRP_T2_ELC (*(volatile unsigned long *)0xEA5D2400)
#define DRP_T2_CLKSEL (*(volatile unsigned long *)0xEA5D2500)
#define DRP_T2_TILECLKE (*(volatile unsigned long *)0xEA5D2508)
#define DRP_T2_DIV (*(volatile unsigned long *)0xEA5D2510)
#define DRP_T2_DIVLAT (*(volatile unsigned long *)0xEA5D2514)
#define DRP_T2_DFCCTRL (*(volatile unsigned long *)0xEA5D2518)
#define DRP_T2_CLKECTRL (*(volatile unsigned long *)0xEA5D2530)
#define DRP_T3_INTOUTMON (*(volatile unsigned long *)0xEA7D2000)
#define DRP_T3_EINTSTS (*(volatile unsigned long *)0xEA7D2008)
#define DRP_T3_EINTMSK (*(volatile unsigned long *)0xEA7D200C)
#define DRP_T3_INTS (*(volatile unsigned long *)0xEA7D2040)
#define DRP_T3_INTSE (*(volatile unsigned long *)0xEA7D2044)
#define DRP_T3_INTE (*(volatile unsigned long *)0xEA7D2048)
#define DRP_T3_INTCLRE (*(volatile unsigned long *)0xEA7D204C)
#define DRP_T3_INTLVL (*(volatile unsigned long *)0xEA7D2050)
#define DRP_T3_INTCLRMODE (*(volatile unsigned long *)0xEA7D2058)
#define DRP_T3_INTOUTSEL (*(volatile unsigned long *)0xEA7D2060)
#define DRP_T3_INTBYPASS (*(volatile unsigned long *)0xEA7D2070)
#define DRP_T3_DMACHE (*(volatile unsigned long *)0xEA7D2100)
#define DRP_T3_FIFODIVCTRL (*(volatile unsigned long *)0xEA7D2104)
#define DRP_T3_SMEMCTRL (*(volatile unsigned long *)0xEA7D2108)
#define DRP_T3_DPMODE (*(volatile unsigned long *)0xEA7D2110)
#define DRP_T3_DPREG0 (*(volatile unsigned long *)0xEA7D2180)
#define DRP_T3_DPREG1 (*(volatile unsigned long *)0xEA7D2184)
#define DRP_T3_DPREG2 (*(volatile unsigned long *)0xEA7D2188)
#define DRP_T3_DPREG3 (*(volatile unsigned long *)0xEA7D218C)
#define DRP_T3_DPREG4 (*(volatile unsigned long *)0xEA7D2190)
#define DRP_T3_DPREG5 (*(volatile unsigned long *)0xEA7D2194)
#define DRP_T3_DPREG6 (*(volatile unsigned long *)0xEA7D2198)
#define DRP_T3_DPREG7 (*(volatile unsigned long *)0xEA7D219C)
#define DRP_T3_SRST (*(volatile unsigned long *)0xEA7D2200)
#define DRP_T3_DW (*(volatile unsigned long *)0xEA7D2210)
#define DRP_T3_TH (*(volatile unsigned long *)0xEA7D2214)
#define DRP_T3_THD (*(volatile unsigned long *)0xEA7D2218)
#define DRP_T3_CONVSTS (*(volatile unsigned long *)0xEA7D221C)
#define DRP_T3_VERSION0 (*(volatile unsigned long *)0xEA7D2300)
#define DRP_T3_VERSION1 (*(volatile unsigned long *)0xEA7D2304)
#define DRP_T3_VERLOCK (*(volatile unsigned long *)0xEA7D2310)
#define DRP_T3_ELC (*(volatile unsigned long *)0xEA7D2400)
#define DRP_T3_CLKSEL (*(volatile unsigned long *)0xEA7D2500)
#define DRP_T3_TILECLKE (*(volatile unsigned long *)0xEA7D2508)
#define DRP_T3_DIV (*(volatile unsigned long *)0xEA7D2510)
#define DRP_T3_DIVLAT (*(volatile unsigned long *)0xEA7D2514)
#define DRP_T3_DFCCTRL (*(volatile unsigned long *)0xEA7D2518)
#define DRP_T3_CLKECTRL (*(volatile unsigned long *)0xEA7D2530)
#define DRP_T4_INTOUTMON (*(volatile unsigned long *)0xEA9D2000)
#define DRP_T4_EINTSTS (*(volatile unsigned long *)0xEA9D2008)
#define DRP_T4_EINTMSK (*(volatile unsigned long *)0xEA9D200C)
#define DRP_T4_INTS (*(volatile unsigned long *)0xEA9D2040)
#define DRP_T4_INTSE (*(volatile unsigned long *)0xEA9D2044)
#define DRP_T4_INTE (*(volatile unsigned long *)0xEA9D2048)
#define DRP_T4_INTCLRE (*(volatile unsigned long *)0xEA9D204C)
#define DRP_T4_INTLVL (*(volatile unsigned long *)0xEA9D2050)
#define DRP_T4_INTCLRMODE (*(volatile unsigned long *)0xEA9D2058)
#define DRP_T4_INTOUTSEL (*(volatile unsigned long *)0xEA9D2060)
#define DRP_T4_INTBYPASS (*(volatile unsigned long *)0xEA9D2070)
#define DRP_T4_DMACHE (*(volatile unsigned long *)0xEA9D2100)
#define DRP_T4_FIFODIVCTRL (*(volatile unsigned long *)0xEA9D2104)
#define DRP_T4_SMEMCTRL (*(volatile unsigned long *)0xEA9D2108)
#define DRP_T4_DPMODE (*(volatile unsigned long *)0xEA9D2110)
#define DRP_T4_DPREG0 (*(volatile unsigned long *)0xEA9D2180)
#define DRP_T4_DPREG1 (*(volatile unsigned long *)0xEA9D2184)
#define DRP_T4_DPREG2 (*(volatile unsigned long *)0xEA9D2188)
#define DRP_T4_DPREG3 (*(volatile unsigned long *)0xEA9D218C)
#define DRP_T4_DPREG4 (*(volatile unsigned long *)0xEA9D2190)
#define DRP_T4_DPREG5 (*(volatile unsigned long *)0xEA9D2194)
#define DRP_T4_DPREG6 (*(volatile unsigned long *)0xEA9D2198)
#define DRP_T4_DPREG7 (*(volatile unsigned long *)0xEA9D219C)
#define DRP_T4_SRST (*(volatile unsigned long *)0xEA9D2200)
#define DRP_T4_DW (*(volatile unsigned long *)0xEA9D2210)
#define DRP_T4_TH (*(volatile unsigned long *)0xEA9D2214)
#define DRP_T4_THD (*(volatile unsigned long *)0xEA9D2218)
#define DRP_T4_CONVSTS (*(volatile unsigned long *)0xEA9D221C)
#define DRP_T4_VERSION0 (*(volatile unsigned long *)0xEA9D2300)
#define DRP_T4_VERSION1 (*(volatile unsigned long *)0xEA9D2304)
#define DRP_T4_VERLOCK (*(volatile unsigned long *)0xEA9D2310)
#define DRP_T4_ELC (*(volatile unsigned long *)0xEA9D2400)
#define DRP_T4_CLKSEL (*(volatile unsigned long *)0xEA9D2500)
#define DRP_T4_TILECLKE (*(volatile unsigned long *)0xEA9D2508)
#define DRP_T4_DIV (*(volatile unsigned long *)0xEA9D2510)
#define DRP_T4_DIVLAT (*(volatile unsigned long *)0xEA9D2514)
#define DRP_T4_DFCCTRL (*(volatile unsigned long *)0xEA9D2518)
#define DRP_T4_CLKECTRL (*(volatile unsigned long *)0xEA9D2530)
#define DRP_T5_INTOUTMON (*(volatile unsigned long *)0xEABD2000)
#define DRP_T5_EINTSTS (*(volatile unsigned long *)0xEABD2008)
#define DRP_T5_EINTMSK (*(volatile unsigned long *)0xEABD200C)
#define DRP_T5_INTS (*(volatile unsigned long *)0xEABD2040)
#define DRP_T5_INTSE (*(volatile unsigned long *)0xEABD2044)
#define DRP_T5_INTE (*(volatile unsigned long *)0xEABD2048)
#define DRP_T5_INTCLRE (*(volatile unsigned long *)0xEABD204C)
#define DRP_T5_INTLVL (*(volatile unsigned long *)0xEABD2050)
#define DRP_T5_INTCLRMODE (*(volatile unsigned long *)0xEABD2058)
#define DRP_T5_INTOUTSEL (*(volatile unsigned long *)0xEABD2060)
#define DRP_T5_INTBYPASS (*(volatile unsigned long *)0xEABD2070)
#define DRP_T5_DMACHE (*(volatile unsigned long *)0xEABD2100)
#define DRP_T5_FIFODIVCTRL (*(volatile unsigned long *)0xEABD2104)
#define DRP_T5_SMEMCTRL (*(volatile unsigned long *)0xEABD2108)
#define DRP_T5_DPMODE (*(volatile unsigned long *)0xEABD2110)
#define DRP_T5_DPREG0 (*(volatile unsigned long *)0xEABD2180)
#define DRP_T5_DPREG1 (*(volatile unsigned long *)0xEABD2184)
#define DRP_T5_DPREG2 (*(volatile unsigned long *)0xEABD2188)
#define DRP_T5_DPREG3 (*(volatile unsigned long *)0xEABD218C)
#define DRP_T5_DPREG4 (*(volatile unsigned long *)0xEABD2190)
#define DRP_T5_DPREG5 (*(volatile unsigned long *)0xEABD2194)
#define DRP_T5_DPREG6 (*(volatile unsigned long *)0xEABD2198)
#define DRP_T5_DPREG7 (*(volatile unsigned long *)0xEABD219C)
#define DRP_T5_SRST (*(volatile unsigned long *)0xEABD2200)
#define DRP_T5_DW (*(volatile unsigned long *)0xEABD2210)
#define DRP_T5_TH (*(volatile unsigned long *)0xEABD2214)
#define DRP_T5_THD (*(volatile unsigned long *)0xEABD2218)
#define DRP_T5_CONVSTS (*(volatile unsigned long *)0xEABD221C)
#define DRP_T5_VERSION0 (*(volatile unsigned long *)0xEABD2300)
#define DRP_T5_VERSION1 (*(volatile unsigned long *)0xEABD2304)
#define DRP_T5_VERLOCK (*(volatile unsigned long *)0xEABD2310)
#define DRP_T5_ELC (*(volatile unsigned long *)0xEABD2400)
#define DRP_T5_CLKSEL (*(volatile unsigned long *)0xEABD2500)
#define DRP_T5_TILECLKE (*(volatile unsigned long *)0xEABD2508)
#define DRP_T5_DIV (*(volatile unsigned long *)0xEABD2510)
#define DRP_T5_DIVLAT (*(volatile unsigned long *)0xEABD2514)
#define DRP_T5_DFCCTRL (*(volatile unsigned long *)0xEABD2518)
#define DRP_T5_CLKECTRL (*(volatile unsigned long *)0xEABD2530)
#define DRP_T6_INTOUTMON (*(volatile unsigned long *)0xEADD2000)
#define DRP_T6_EINTSTS (*(volatile unsigned long *)0xEADD2008)
#define DRP_T6_EINTMSK (*(volatile unsigned long *)0xEADD200C)
#define DRP_T6_INTS (*(volatile unsigned long *)0xEADD2040)
#define DRP_T6_INTSE (*(volatile unsigned long *)0xEADD2044)
#define DRP_T6_INTE (*(volatile unsigned long *)0xEADD2048)
#define DRP_T6_INTCLRE (*(volatile unsigned long *)0xEADD204C)
#define DRP_T6_INTLVL (*(volatile unsigned long *)0xEADD2050)
#define DRP_T6_INTCLRMODE (*(volatile unsigned long *)0xEADD2058)
#define DRP_T6_INTOUTSEL (*(volatile unsigned long *)0xEADD2060)
#define DRP_T6_INTBYPASS (*(volatile unsigned long *)0xEADD2070)
#define DRP_T6_DMACHE (*(volatile unsigned long *)0xEADD2100)
#define DRP_T6_FIFODIVCTRL (*(volatile unsigned long *)0xEADD2104)
#define DRP_T6_SMEMCTRL (*(volatile unsigned long *)0xEADD2108)
#define DRP_T6_DPMODE (*(volatile unsigned long *)0xEADD2110)
#define DRP_T6_DPREG0 (*(volatile unsigned long *)0xEADD2180)
#define DRP_T6_DPREG1 (*(volatile unsigned long *)0xEADD2184)
#define DRP_T6_DPREG2 (*(volatile unsigned long *)0xEADD2188)
#define DRP_T6_DPREG3 (*(volatile unsigned long *)0xEADD218C)
#define DRP_T6_DPREG4 (*(volatile unsigned long *)0xEADD2190)
#define DRP_T6_DPREG5 (*(volatile unsigned long *)0xEADD2194)
#define DRP_T6_DPREG6 (*(volatile unsigned long *)0xEADD2198)
#define DRP_T6_DPREG7 (*(volatile unsigned long *)0xEADD219C)
#define DRP_T6_SRST (*(volatile unsigned long *)0xEADD2200)
#define DRP_T6_DW (*(volatile unsigned long *)0xEADD2210)
#define DRP_T6_TH (*(volatile unsigned long *)0xEADD2214)
#define DRP_T6_THD (*(volatile unsigned long *)0xEADD2218)
#define DRP_T6_CONVSTS (*(volatile unsigned long *)0xEADD221C)
#define DRP_T6_VERSION0 (*(volatile unsigned long *)0xEADD2300)
#define DRP_T6_VERSION1 (*(volatile unsigned long *)0xEADD2304)
#define DRP_T6_VERLOCK (*(volatile unsigned long *)0xEADD2310)
#define DRP_T6_ELC (*(volatile unsigned long *)0xEADD2400)
#define DRP_T6_CLKSEL (*(volatile unsigned long *)0xEADD2500)
#define DRP_T6_TILECLKE (*(volatile unsigned long *)0xEADD2508)
#define DRP_T6_DIV (*(volatile unsigned long *)0xEADD2510)
#define DRP_T6_DIVLAT (*(volatile unsigned long *)0xEADD2514)
#define DRP_T6_DFCCTRL (*(volatile unsigned long *)0xEADD2518)
#define DRP_T6_CLKECTRL (*(volatile unsigned long *)0xEADD2530)
#define DRP_T7_INTOUTMON (*(volatile unsigned long *)0xEAFD2000)
#define DRP_T7_EINTSTS (*(volatile unsigned long *)0xEAFD2008)
#define DRP_T7_EINTMSK (*(volatile unsigned long *)0xEAFD200C)
#define DRP_T7_INTS (*(volatile unsigned long *)0xEAFD2040)
#define DRP_T7_INTSE (*(volatile unsigned long *)0xEAFD2044)
#define DRP_T7_INTE (*(volatile unsigned long *)0xEAFD2048)
#define DRP_T7_INTCLRE (*(volatile unsigned long *)0xEAFD204C)
#define DRP_T7_INTLVL (*(volatile unsigned long *)0xEAFD2050)
#define DRP_T7_INTCLRMODE (*(volatile unsigned long *)0xEAFD2058)
#define DRP_T7_INTOUTSEL (*(volatile unsigned long *)0xEAFD2060)
#define DRP_T7_INTBYPASS (*(volatile unsigned long *)0xEAFD2070)
#define DRP_T7_DMACHE (*(volatile unsigned long *)0xEAFD2100)
#define DRP_T7_FIFODIVCTRL (*(volatile unsigned long *)0xEAFD2104)
#define DRP_T7_SMEMCTRL (*(volatile unsigned long *)0xEAFD2108)
#define DRP_T7_DPMODE (*(volatile unsigned long *)0xEAFD2110)
#define DRP_T7_DPREG0 (*(volatile unsigned long *)0xEAFD2180)
#define DRP_T7_DPREG1 (*(volatile unsigned long *)0xEAFD2184)
#define DRP_T7_DPREG2 (*(volatile unsigned long *)0xEAFD2188)
#define DRP_T7_DPREG3 (*(volatile unsigned long *)0xEAFD218C)
#define DRP_T7_DPREG4 (*(volatile unsigned long *)0xEAFD2190)
#define DRP_T7_DPREG5 (*(volatile unsigned long *)0xEAFD2194)
#define DRP_T7_DPREG6 (*(volatile unsigned long *)0xEAFD2198)
#define DRP_T7_DPREG7 (*(volatile unsigned long *)0xEAFD219C)
#define DRP_T7_SRST (*(volatile unsigned long *)0xEAFD2200)
#define DRP_T7_DW (*(volatile unsigned long *)0xEAFD2210)
#define DRP_T7_TH (*(volatile unsigned long *)0xEAFD2214)
#define DRP_T7_THD (*(volatile unsigned long *)0xEAFD2218)
#define DRP_T7_CONVSTS (*(volatile unsigned long *)0xEAFD221C)
#define DRP_T7_VERSION0 (*(volatile unsigned long *)0xEAFD2300)
#define DRP_T7_VERSION1 (*(volatile unsigned long *)0xEAFD2304)
#define DRP_T7_VERLOCK (*(volatile unsigned long *)0xEAFD2310)
#define DRP_T7_ELC (*(volatile unsigned long *)0xEAFD2400)
#define DRP_T7_CLKSEL (*(volatile unsigned long *)0xEAFD2500)
#define DRP_T7_TILECLKE (*(volatile unsigned long *)0xEAFD2508)
#define DRP_T7_DIV (*(volatile unsigned long *)0xEAFD2510)
#define DRP_T7_DIVLAT (*(volatile unsigned long *)0xEAFD2514)
#define DRP_T7_DFCCTRL (*(volatile unsigned long *)0xEAFD2518)
#define DRP_T7_CLKECTRL (*(volatile unsigned long *)0xEAFD2530)
/* OTHER */
#define DRP_T0_RegBResetZ (*(volatile unsigned long *)0xEA1B0070)
#define DRP_T1_RegBResetZ (*(volatile unsigned long *)0xEA3B0070)
#define DRP_T2_RegBResetZ (*(volatile unsigned long *)0xEA5B0070)
#define DRP_T3_RegBResetZ (*(volatile unsigned long *)0xEA7B0070)
#define DRP_T4_RegBResetZ (*(volatile unsigned long *)0xEA9B0070)
#define DRP_T5_RegBResetZ (*(volatile unsigned long *)0xEABB0070)
#define DRP_T6_RegBResetZ (*(volatile unsigned long *)0xEADB0070)
#define DRP_T7_RegBResetZ (*(volatile unsigned long *)0xEAFB0070)
#define DRP_T0_RegCtrlEn (*(volatile unsigned long *)0xEA1B0000)
#define DRP_T1_RegCtrlEn (*(volatile unsigned long *)0xEA3B0000)
#define DRP_T2_RegCtrlEn (*(volatile unsigned long *)0xEA5B0000)
#define DRP_T3_RegCtrlEn (*(volatile unsigned long *)0xEA7B0000)
#define DRP_T4_RegCtrlEn (*(volatile unsigned long *)0xEA9B0000)
#define DRP_T5_RegCtrlEn (*(volatile unsigned long *)0xEABB0000)
#define DRP_T6_RegCtrlEn (*(volatile unsigned long *)0xEADB0000)
#define DRP_T7_RegCtrlEn (*(volatile unsigned long *)0xEAFB0000)
#define DRP_T0_RegRun (*(volatile unsigned long *)0xEA118008)
#define DRP_T0_RegReset (*(volatile unsigned long *)0xEA118010)
#define DRP_T0_RegCfgmReadEn (*(volatile unsigned long *)0xEA118040)
#define DRP_T0_RegConfigEn (*(volatile unsigned long *)0xEA118048)
#define DRP_T0_RegRunSel (*(volatile unsigned long *)0xEA118078)
#define DRP_T1_RegRun (*(volatile unsigned long *)0xEA318008)
#define DRP_T1_RegReset (*(volatile unsigned long *)0xEA318010)
#define DRP_T1_RegCfgmReadEn (*(volatile unsigned long *)0xEA318040)
#define DRP_T1_RegConfigEn (*(volatile unsigned long *)0xEA318048)
#define DRP_T1_RegRunSel (*(volatile unsigned long *)0xEA318078)
#define DRP_T2_RegRun (*(volatile unsigned long *)0xEA518008)
#define DRP_T2_RegReset (*(volatile unsigned long *)0xEA518010)
#define DRP_T2_RegCfgmReadEn (*(volatile unsigned long *)0xEA518040)
#define DRP_T2_RegConfigEn (*(volatile unsigned long *)0xEA518048)
#define DRP_T2_RegRunSel (*(volatile unsigned long *)0xEA518078)
#define DRP_T3_RegRun (*(volatile unsigned long *)0xEA718008)
#define DRP_T3_RegReset (*(volatile unsigned long *)0xEA718010)
#define DRP_T3_RegCfgmReadEn (*(volatile unsigned long *)0xEA718040)
#define DRP_T3_RegConfigEn (*(volatile unsigned long *)0xEA718048)
#define DRP_T3_RegRunSel (*(volatile unsigned long *)0xEA718078)
#define DRP_T4_RegRun (*(volatile unsigned long *)0xEA918008)
#define DRP_T4_RegReset (*(volatile unsigned long *)0xEA918010)
#define DRP_T4_RegCfgmReadEn (*(volatile unsigned long *)0xEA918040)
#define DRP_T4_RegConfigEn (*(volatile unsigned long *)0xEA918048)
#define DRP_T4_RegRunSel (*(volatile unsigned long *)0xEA918078)
#define DRP_T5_RegRun (*(volatile unsigned long *)0xEAB18008)
#define DRP_T5_RegReset (*(volatile unsigned long *)0xEAB18010)
#define DRP_T5_RegCfgmReadEn (*(volatile unsigned long *)0xEAB18040)
#define DRP_T5_RegConfigEn (*(volatile unsigned long *)0xEAB18048)
#define DRP_T5_RegRunSel (*(volatile unsigned long *)0xEAB18078)
#define DRP_IDMAC_INTME (*(volatile unsigned long *)0xEAFFB024)
#define DRP_IDMAC_INTMES (*(volatile unsigned long *)0xEAFFB028)
#define DRP_ODMAC_INTME (*(volatile unsigned long *)0xEAFFC024)
#define DRP_DRPK0_FIFODATA (*(volatile unsigned long *)0xEAFD3000)
#define DRP_DRPK1_FIFODATA (*(volatile unsigned long *)0xEAFD3200)
#define DRP_DRPK2_FIFODATA (*(volatile unsigned long *)0xEAFD3400)
#define DRP_DRPK3_FIFODATA (*(volatile unsigned long *)0xEAFD3600)
#define DRP_DRPK4_FIFODATA (*(volatile unsigned long *)0xEAFD3800)
#define DRP_DRPK5_FIFODATA (*(volatile unsigned long *)0xEAFD3A00)


#define DRP_RAC_DMMY (*(volatile unsigned long *)0xEAFFD000)

#define DRP_CFGL_INT_STS (*(volatile unsigned long *)0xEAFF0000)
#define DRP_CFGL_INT_MSK (*(volatile unsigned long *)0xEAFF0004)

#define DRPK_BASE_ADDR  (0xEA000000)
#define DRPK_TILE0_ADDR (DRPK_BASE_ADDR + 0x00000000)
#define REG_CFGMREADEN  (0x00118040)

/*******************************************************************************
Typedef definitions
*******************************************************************************/

/*******************************************************************************
Public Functions
*******************************************************************************/

#endif /* DRP_IODEFINE_H */
