#include "mbed.h"
#include "Serial_Interrupt.h"

#ifdef __cplusplus
extern "C" {
#endif

Serial  uart1(TX_1, RX_1, 9600);
Serial  uart2(TX_2, RX_2, 9600);
Serial  uart3(TX_3, RX_3, 9600);
Serial  uart4(TX_4, RX_4, 9600);
Serial  uart5(TX_5, RX_5, 9600);
Serial  uart6(TX_6, RX_6, 9600); 
Serial  uart7(TX_7, RX_7, 9600);
Serial  uart8(TX_8, RX_8, 115200);


int uart1_buffer[UART_BUFFER_SIZE];
int uart2_buffer[UART_BUFFER_SIZE];
int uart3_buffer[UART_BUFFER_SIZE];
int uart4_buffer[UART_BUFFER_SIZE];
int uart5_buffer[UART_BUFFER_SIZE];
int uart6_buffer[UART_BUFFER_SIZE];
int uart7_buffer[UART_BUFFER_SIZE];
int uart8_buffer[UART_BUFFER_SIZE];

int uart1_rx_head = 0;
int uart1_rx_tail = 0;

int uart2_rx_head = 0;
int uart2_rx_tail = 0;

int uart3_rx_head = 0;
int uart3_rx_tail = 0;

int uart4_rx_head = 0;
int uart4_rx_tail = 0;

int uart5_rx_head = 0;
int uart5_rx_tail = 0;

int uart6_rx_head = 0;
int uart6_rx_tail = 0;

int uart7_rx_head = 0;
int uart7_rx_tail = 0;

int uart8_rx_head = 0;
int uart8_rx_tail = 0;

int uart_data1;
int uart_data2;
int uart_data3;
int uart_data4;
int uart_data5;
int uart_data6;
int uart_data7;
int uart_data8;

int uart1_state = 0;
int uart1_checksum = 0;
int uart1_distance = 0;
float   range1 = 0;

int uart2_state = 0;
int uart2_checksum = 0;
int uart2_distance = 0;
float   range2 = 0;

int uart3_state = 0;
int uart3_checksum = 0;
int uart3_distance = 0;
float   range3 = 0;

int uart4_state = 0;
int uart4_checksum = 0;
int uart4_distance = 0;
float   range4 = 0;

int uart5_state = 0;
int uart5_checksum = 0;
int uart5_distance = 0;
float   range5 = 0;

int uart6_state = 0;
int uart6_checksum = 0;
int uart6_distance = 0;
float   range6 = 0;


void Uart1RxHandler()
{
    while(uart1.readable())
    {
        write_uart1_buffer(uart1.getc());
    }    
}

void Uart2RxHandler()
{
    while(uart2.readable())
    {
        write_uart2_buffer(uart2.getc());
    }    
}

void Uart3RxHandler()
{
    while(uart3.readable())
    {
        write_uart3_buffer(uart3.getc());
    }    
}

void Uart4RxHandler()
{
    while(uart4.readable())
    {
        write_uart4_buffer(uart4.getc());
    }    
}

void Uart5RxHandler()
{
    while(uart5.readable())
    {
        write_uart5_buffer(uart5.getc());
    }    
}

void Uart6RxHandler()
{
    while(uart6.readable())
    {
        write_uart6_buffer(uart6.getc());
    }    
}

void Uart7RxHandler()
{
    while(uart7.readable())
    {
        write_uart7_buffer(uart7.getc());
    }    
}

void Uart8RxHandler()
{
    while(uart8.readable())
    {
        write_uart8_buffer(uart8.getc());
    }    
}

void range_finder_init(void)
{
    uart1.attach(&Uart1RxHandler, Serial::RxIrq);
    uart2.attach(&Uart2RxHandler, Serial::RxIrq);
    uart3.attach(&Uart3RxHandler, Serial::RxIrq);
    uart4.attach(&Uart4RxHandler, Serial::RxIrq);
    uart5.attach(&Uart5RxHandler, Serial::RxIrq);
    uart6.attach(&Uart6RxHandler, Serial::RxIrq);
    uart7.attach(&Uart7RxHandler, Serial::RxIrq);
#ifdef DEBUG8
    uart8.attach(&Uart8RxHandler, Serial::RxIrq);    
#endif
}

void parse_range(void)
{
    uart_data1 = read_uart1();
    if(uart_data1 != 0x00)
    {
#ifdef DEBUG1
        uart8.printf("1 : 0x%02x\r\n",uart_data1);
#endif
        if(uart_data1 == 0xFF)
        {
            uart1_state = 1;
            uart1_checksum = 0xFF;
            uart1_distance = 0;     
            range1 = 0;       
        } else if(uart1_state == 1)
        {
            uart1_state = 2;
            uart1_distance = uart_data1;
            uart1_checksum += uart_data1;
        } else if(uart1_state == 2)
        {
            uart1_checksum &= 0x00FF;
            if(uart1_checksum == uart_data1)
            {
                uart1_state = 0;
                range1 = uart1_distance / 10.;
#ifdef DEBUG1
                uart8.printf("1: %05.1f cm \r\n", range1);
#endif
            } else
            {
                uart1_state = 3;
                uart1_distance <<= 8;
                uart1_distance += uart_data1;
                uart1_checksum += uart_data1;
            }
        } else if(uart1_state == 3)
        {
            uart1_checksum &= 0x00FF;
            if(uart1_checksum == uart_data1)
            {
                uart1_state = 0;
                range1 = uart1_distance / 10.;
#ifdef DEBUG1
                uart8.printf("1: %05.1f cm \r\n", range1);
#endif
            }
        }
        // 
    }
    
    uart_data2 = read_uart2();
    if(uart_data2 != 0x00)
    {
#ifdef DEBUG2
        uart8.printf("2 : 0x%02x\r\n",uart_data2);
#endif
        if(uart_data2 == 0xFF)
        {
            uart2_state = 1;
            uart2_checksum = 0xFF;
            uart2_distance = 0;        
            range2 = 0;    
        } else if(uart2_state == 1)
        {
            uart2_state = 2;
            uart2_distance = uart_data2;
            uart2_checksum += uart_data2;
        } else if(uart2_state == 2)
        {
            uart2_checksum &= 0x00FF;
            if(uart2_checksum == uart_data2)
            {
                uart2_state = 0;
                range2 = uart2_distance / 10.;
#ifdef DEBUG2
                uart8.printf("2: %05.1f cm \r\n", range2);
#endif
            } else
            {
                uart2_state = 3;
                uart2_distance <<= 8;
                uart2_distance += uart_data2;
                uart2_checksum += uart_data2;
            }
        } else if(uart2_state == 3)
        {
            uart2_checksum &= 0x00FF;
            if(uart2_checksum == uart_data2)
            {
                uart2_state = 0;
                range2 = uart2_distance / 10.;
#ifdef DEBUG2
                uart8.printf("2: %05.1f cm \r\n", range2);
#endif
            }
        }        // 
    }
    
    uart_data3 = read_uart3();
    if(uart_data3 != 0x00)
    {
#ifdef DEBUG3
        uart8.printf("3 : 0x%02x\r\n",uart_data3);
#endif
        if(uart_data3 == 0xFF)
        {
            uart3_state = 1;
            uart3_checksum = 0xFF;
            uart3_distance = 0;       
            range3 = 0;     
        } else if(uart3_state == 1)
        {
            uart3_state = 2;
            uart3_distance = uart_data3;
            uart3_checksum += uart_data3;
        } else if(uart3_state == 2)
        {
            uart3_checksum &= 0x00FF;
            if(uart3_checksum == uart_data3)
            {
                uart3_state = 0;
                range3 = uart3_distance / 10.;
#ifdef DEBUG3
                uart8.printf("3: %05.1f cm \r\n", range3);
#endif
            } else
            {
                uart3_state = 3;
                uart3_distance <<= 8;
                uart3_distance += uart_data3;
                uart3_checksum += uart_data3;
            }
        } else if(uart3_state == 3)
        {
            uart3_checksum &= 0x00FF;
            if(uart3_checksum == uart_data3)
            {
                uart3_state = 0;
                range3 = uart3_distance / 10.;
#ifdef DEBUG3
                uart8.printf("3: %05.1f cm \r\n", range3);
#endif
            }
        }        // 
    }
    
    uart_data4 = read_uart4();
    if(uart_data4 != 0x00)
    {
#ifdef DEBUG4
        uart8.printf("4 : 0x%02x\r\n",uart_data4);
#endif
        if(uart_data4 == 0xFF)
        {
            uart4_state = 1;
            uart4_checksum = 0xFF;
            uart4_distance = 0;       
            range4 = 0;     
        } else if(uart4_state == 1)
        {
            uart4_state = 2;
            uart4_distance = uart_data4;
            uart4_checksum += uart_data4;
        } else if(uart4_state == 2)
        {
            uart4_checksum &= 0x00FF;
            if(uart4_checksum == uart_data4)
            {
                uart4_state = 0;
                range4 = uart4_distance / 10.;
#ifdef DEBUG4
                uart8.printf("4: %05.1f cm \r\n", range4);
#endif
            } else
            {
                uart4_state = 3;
                uart4_distance <<= 8;
                uart4_distance += uart_data4;
                uart4_checksum += uart_data4;
            }
        } else if(uart4_state == 3)
        {
            uart4_checksum &= 0x00FF;
            if(uart4_checksum == uart_data4)
            {
                uart4_state = 0;
                range4 = uart4_distance / 10.;
#ifdef DEBUG4
                uart8.printf("4: %05.1f cm \r\n", range4);
#endif
            }
        }        // 
    }
    
    uart_data5 = read_uart5();
    if(uart_data5 != 0x00)
    {
#ifdef DEBUG5
        uart8.printf("5 : 0x%02x\r\n",uart_data5);
#endif
        if(uart_data5 == 0xFF)
        {
            uart5_state = 1;
            uart5_checksum = 0xFF;
            uart5_distance = 0;       
            range5 = 0;     
        } else if(uart5_state == 1)
        {
            uart5_state = 2;
            uart5_distance = uart_data5;
            uart5_checksum += uart_data5;
        } else if(uart5_state == 2)
        {
            uart5_checksum &= 0x00FF;
            if(uart5_checksum == uart_data5)
            {
                uart5_state = 0;
                range5 = uart5_distance / 10.;
#ifdef DEBUG5
                uart8.printf("5: %05.1f cm \r\n", range5);
#endif
            } else
            {
                uart5_state = 3;
                uart5_distance <<= 8;
                uart5_distance += uart_data5;
                uart5_checksum += uart_data5;
            }
        } else if(uart5_state == 3)
        {
            uart5_checksum &= 0x00FF;
            if(uart5_checksum == uart_data5)
            {
                uart5_state = 0;
                range5 = uart5_distance / 10.;
#ifdef DEBUG5
                uart8.printf("5: %05.1f cm \r\n", range5);
#endif
            }
        }        // 
    }
    
    uart_data6 = read_uart6();
    if(uart_data6 != 0x00)
    {
#ifdef DEBUG6
        uart8.printf("6 : 0x%02x\r\n",uart_data6);
#endif
        if(uart_data6 == 0xFF)
        {
            uart6_state = 1;
            uart6_checksum = 0xFF;
            uart6_distance = 0;       
            range6 = 0;     
        } else if(uart6_state == 1)
        {
            uart6_state = 2;
            uart6_distance = uart_data6;
            uart6_checksum += uart_data6;
        } else if(uart6_state == 2)
        {
            uart6_checksum &= 0x00FF;
            if(uart6_checksum == uart_data6)
            {
                uart6_state = 0;
                range6 = uart6_distance / 10.;
#ifdef DEBUG6
                uart8.printf("6: %05.1f cm \r\n", range6);
#endif
            } else
            {
                uart6_state = 3;
                uart6_distance <<= 8;
                uart6_distance += uart_data6;
                uart6_checksum += uart_data6;
            }
        } else if(uart6_state == 3)
        {
            uart6_checksum &= 0x00FF;
            if(uart6_checksum == uart_data6)
            {
                uart6_state = 0;
                range6 = uart6_distance / 10.;
#ifdef DEBUG6
                uart8.printf("6: %05.1f cm \r\n", range6);
#endif
            }
        }        // 
    }
    
//    uart_data7 = read_uart7();
//    if(uart_data7 != 0x00)
//    {
//#ifdef DEBUG7
//        uart8.printf("7 : 0x%02x\r\n",uart_data7);
//#endif        // 
//    }
    
    uart_data8 = read_uart8();
    if(uart_data8 != 0x00)
    {
#ifdef DEBUG8
        uart8.printf("8 : 0x%02x\r\n",uart_data8);
#endif        // 
    }
}

int read_uart1(void)
{
    int read_data;
    if(uart1_rx_tail == uart1_rx_head)
    {
        return 0;
    } else
    {
        read_data = uart1_buffer[uart1_rx_tail];
        uart1_rx_tail++;
        uart1_rx_tail %= UART_BUFFER_SIZE;
        return read_data;
    }
}

int read_uart2(void)
{
    int read_data;
    if(uart2_rx_tail == uart2_rx_head)
    {
        return 0;
    } else
    {
        read_data = uart2_buffer[uart2_rx_tail];
        uart2_rx_tail++;
        uart2_rx_tail %= UART_BUFFER_SIZE;
        return read_data;
    }
}

int read_uart3(void)
{
    int read_data;
    if(uart3_rx_tail == uart3_rx_head)
    {
        return 0;
    } else
    {
        read_data = uart3_buffer[uart3_rx_tail];
        uart3_rx_tail++;
        uart3_rx_tail %= UART_BUFFER_SIZE;
        return read_data;
    }
}

int read_uart4(void)
{
    int read_data;
    if(uart4_rx_tail == uart4_rx_head)
    {
        return 0;
    } else
    {
        read_data = uart4_buffer[uart4_rx_tail];
        uart4_rx_tail++;
        uart4_rx_tail %= UART_BUFFER_SIZE;
        return read_data;
    }
}

int read_uart5(void)
{
    int read_data;
    if(uart5_rx_tail == uart5_rx_head)
    {
        return 0;
    } else
    {
        read_data = uart5_buffer[uart5_rx_tail];
        uart5_rx_tail++;
        uart5_rx_tail %= UART_BUFFER_SIZE;
        return read_data;
    }
}

int read_uart6(void)
{
    int read_data;
    if(uart6_rx_tail == uart6_rx_head)
    {
        return 0;
    } else
    {
        read_data = uart6_buffer[uart6_rx_tail];
        uart6_rx_tail++;
        uart6_rx_tail %= UART_BUFFER_SIZE;
        return read_data;
    }
}

int read_uart7(void)
{
    int read_data;
    if(uart7_rx_tail == uart7_rx_head)
    {
        return 0;
    } else
    {
        read_data = uart7_buffer[uart7_rx_tail];
        uart7_rx_tail++;
        uart7_rx_tail %= UART_BUFFER_SIZE;
        return read_data;
    }
}

int read_uart8(void)
{
    int read_data;
    if(uart8_rx_tail == uart8_rx_head)
    {
        return 0;
    } else
    {
        read_data = uart8_buffer[uart8_rx_tail];
        uart8_rx_tail++;
        uart8_rx_tail %= UART_BUFFER_SIZE;
        return read_data;
    }
}

void write_uart1_buffer(int in_data)
{
    uart1_buffer[uart1_rx_head++] = in_data;
    uart1_rx_head %= UART_BUFFER_SIZE;
}

void write_uart2_buffer(int in_data)
{
    uart2_buffer[uart2_rx_head++] = in_data;
    uart2_rx_head %= UART_BUFFER_SIZE;
}

void write_uart3_buffer(int in_data)
{
    uart3_buffer[uart3_rx_head++] = in_data;
    uart3_rx_head %= UART_BUFFER_SIZE;
}

void write_uart4_buffer(int in_data)
{
    uart4_buffer[uart4_rx_head++] = in_data;
    uart4_rx_head %= UART_BUFFER_SIZE;
}

void write_uart5_buffer(int in_data)
{
    uart5_buffer[uart5_rx_head++] = in_data;
    uart5_rx_head %= UART_BUFFER_SIZE;
}

void write_uart6_buffer(int in_data)
{
    uart6_buffer[uart6_rx_head++] = in_data;
    uart6_rx_head %= UART_BUFFER_SIZE;
}

void write_uart7_buffer(int in_data)
{
    uart7_buffer[uart7_rx_head++] = in_data;
    uart7_rx_head %= UART_BUFFER_SIZE;
}

void write_uart8_buffer(int in_data)
{
    uart8_buffer[uart8_rx_head++] = in_data;
    uart8_rx_head %= UART_BUFFER_SIZE;
}


#ifdef __cplusplus
}
#endif