#include "mbed.h"
#include "SoftSerial.h"
//#include "DFPlayer.h"

#ifdef __cplusplus
extern "C" {
#endif
SoftSerial  mp3(PF_13, PF_14);

uint8_t is_replay   =   0;

uint8_t send_buf[10] = {0x7E, 0xFF, 0x06, 0x03, 00, 00, 01, 0xFE, 0xF6, 0xEF};


void fill_uint16_bigend (uint8_t *thebuf, uint16_t data) 
{
    *thebuf =   (uint8_t)(data>>8);
    *(thebuf+1) =   (uint8_t)data;
}

uint16_t mp3_get_checksum (uint8_t *thebuf) 
{
    uint16_t sum = 0;
    for (int i=1; i<7; i++) {
        sum += thebuf[i];
    }
    return -sum;
}

void mp3_fill_checksum () 
{
    uint16_t checksum = mp3_get_checksum (send_buf);
    fill_uint16_bigend (send_buf+7, checksum);
}
 
void send_func () 
{
    int i;
    for (i = 0; i < 10; i++) {
        mp3.putc(send_buf[i]);
//        uart8.printf("%02X ",send_buf[i]);
    } 
//    uart8.printf("\r\n");
//    uart8.printf("\r\n");
    
}
 
void mp3_send_cmd1 (uint8_t cmd, uint16_t arg) 
{
    send_buf[3] = cmd;
    fill_uint16_bigend ((send_buf+5), arg);
    mp3_fill_checksum ();
    send_func ();
}
 
void mp3_send_cmd (uint8_t cmd) 
{
    send_buf[3] = cmd;
    fill_uint16_bigend ((send_buf+5), 0);
    mp3_fill_checksum ();
    send_func ();
}

void mp3_set_reply (uint8_t state) 
{
    is_replay = state;
    send_buf[4] = is_replay;
}

void mp3_play_physical1 (uint16_t num) 
{
    mp3_send_cmd1 (0x03, num);
}

void mp3_play_physical () 
{
    mp3_send_cmd (0x03);
}
 
void mp3_next () 
{
    mp3_send_cmd (0x01);
}
 
void mp3_prev () 
{
    mp3_send_cmd (0x02);
}
 
//0x06 set volume 0-30
void mp3_set_volume (uint16_t volume) 
{
    if(volume > 30)
    {
        volume = 30;
    }
    mp3_send_cmd1 (0x06, volume);
}
 
//0x07 set EQ0/1/2/3/4/5    Normal/Pop/Rock/Jazz/Classic/Bass
void mp3_set_EQ (uint16_t eq) 
{
    mp3_send_cmd1 (0x07, eq);
}
 
//0x09 set device 1/2/3/4/5 U/SD/AUX/SLEEP/FLASH
void mp3_set_device (uint16_t device) 
{
    mp3_send_cmd1 (0x09, device);
}
 
void mp3_sleep () 
{
    mp3_send_cmd (0x0a);
}
 
void mp3_reset () 
{
    mp3_send_cmd (0x0c);
}
 
void mp3_play () 
{
    mp3_send_cmd (0x0d);
}
 
void mp3_pause () 
{
    mp3_send_cmd (0x0e);
}
 
void mp3_stop () 
{
    mp3_send_cmd (0x16);
}
 
// play mp3 file in mp3 folder in your tf card
void mp3_play1 (uint16_t num) 
{
    mp3_send_cmd1 (0x12, num);
}
 
void mp3_get_state () 
{
    mp3_send_cmd (0x42);
}
 
void mp3_get_volume () 
{
    mp3_send_cmd (0x43);
}
 
void mp3_get_u_sum () 
{
    mp3_send_cmd (0x47);
}
 
void mp3_get_tf_sum () 
{
    mp3_send_cmd (0x48);
}
 
void mp3_get_flash_sum () 
{
    mp3_send_cmd (0x49);
}
 
void mp3_get_tf_current () 
{
    mp3_send_cmd (0x4c);
}
 
void mp3_get_u_current () 
{
    mp3_send_cmd (0x4b);
}
 
void mp3_get_flash_current () 
{
    mp3_send_cmd (0x4d);
}
 
void mp3_single_loop (uint8_t state) 
{
    mp3_send_cmd1 (0x19, !state);
}
 
void mp3_single_play (uint16_t num) 
{
    mp3_play1 (num);
    wait_ms (10);
    mp3_single_loop (true); 
}
 
void mp3_DAC (uint8_t state) 
{
    mp3_send_cmd1 (0x1a, !state);
}
 
void mp3_random_play () 
{
    mp3_send_cmd (0x18);
}

#ifdef __cplusplus
}
#endif