#ifndef SERIAL_INTERRUPT_H
#define SERIAL_INTERRUPT_H

#ifdef __cplusplus
extern "C" {
#endif

#define DEBUG1  1
#define DEBUG2  1
#define DEBUG3  1
#define DEBUG4  1
#define DEBUG5  1
#define DEBUG6  1
//#define DEBUG7  1
#define DEBUG8  1

#define TX_1    PB_6
#define RX_1    PB_7
#define TX_2    PD_5
#define RX_2    PD_6
#define TX_3    PD_8
#define RX_3    PD_9
#define TX_4    PC_10
#define RX_4    PC_11
#define TX_5    PC_12
#define RX_5    PD_2
#define TX_6    PC_6
#define RX_6    PC_7
#define TX_7    PF_7
#define RX_7    PF_6
#define TX_8    PE_1
#define RX_8    PE_0

#define UART_BUFFER_SIZE 16

void    Uart1RxHandler();
void    Uart2RxHandler();
void    Uart3RxHandler();
void    Uart4RxHandler();
void    Uart5RxHandler();
void    Uart6RxHandler();
void    Uart7RxHandler();
void    Uart8RxHandler();

void    write_uart1_buffer(int in_data);
void    write_uart2_buffer(int in_data);
void    write_uart3_buffer(int in_data);
void    write_uart4_buffer(int in_data);
void    write_uart5_buffer(int in_data);
void    write_uart6_buffer(int in_data);
void    write_uart7_buffer(int in_data);
void    write_uart8_buffer(int in_data);

int read_uart1(void);
int read_uart2(void);
int read_uart3(void);
int read_uart4(void);
int read_uart5(void);
int read_uart6(void);
int read_uart7(void);
int read_uart8(void);

void    range_finder_init(void);
void    parse_range(void);
void    read_nano(void);


#ifdef __cplusplus
}
#endif
#endif