#include "mbed.h"
#include "string.h"
#include "stdio.h"
#include "stdlib.h"
#include "Serial.h"
#include "ATCmdParser.h"
#include "UARTSerial.h"

// Dimensione massima del vettore MRxB
#define MRxBDIM 50

// Dimensione massima del vettore ARxB
#define ARxBDIM 200

// Numero di byte da inviare per l'accensione del led tramite il protocollo SPI
#define NumByte 16

// Configurazione della porta seriale del PC
Serial pc(USBTX, USBRX);     

// Dichiarazione del LED di diagnostica
DigitalOut led(LED2);

// Configurazione della porta seriale UART
UARTSerial serial = UARTSerial(PA_9, PA_10);
ATCmdParser at = ATCmdParser(&serial, "\r\n");

// Configurazione dei parametri del protocollo SPI
SPI myspi(PA_7, PA_6, PA_5, NC);
     
// Vettore che conterrà i byte ricevuti in risposta al comando AT inviato
char MRxB[MRxBDIM];

// Vettore che conterrà i byte ricevuti in risposta all'invio automatico della sequenza di comandi AT
char ARxB[ARxBDIM];

// Vettore che conterrà i byte da trasmettere al led tramite il protocollo SPI
uint8_t Vled[NumByte];

// Dichiarazione del parametro temporale t
Timer t;

// Variabili globali
char c;
int i=0;
int j=0;
int E=0;
int R=0;
int ER=0;
int ERR=0;
int end=0;

volatile char input;

// Funzione per l'emissione di luce verde tramite il protocollo SPI
void LedGREEN();

// Funzione per l'emissione di luce rossa tramite il protocollo SPI
void LedRED();

// Funzione per lo spegnimento del led tramite il protocollo SPI
void LedOFF();

// Funzione per la ricerca della parola ERROR nel vettore ricevuto dal modem in risposta al comando digitato
void ERR1();

// Funzione per la ricerca della parola ERROR nel vettore ricevuto dal modem in risposta alla sequenza prestabilita di comandi
void ERR2();

// Funzione che legge la risposta del modem
void ReadModem();

// Funzione che esegue il reset dei vettori MRxB e ARxB
void Vreset();


int main()
{
    start:
   
    // Configurazione del baud rate per la comunicazione col PC
    pc.baud(9600);
    
    // Configurazione dei parametri del protocollo SPI
    myspi.format(16, 0);
    myspi.frequency(3333333.3);
    
    pc.printf("\r\n");
    pc.printf("              PROGRAMMA PER L'INVIO DI COMANDI AT SU PORTA SERIALE\r\n");
    pc.printf("________________________________________________________________________________\r\n");  
    pc.printf("\r\n");   
    pc.printf("  ----------------------------------------------------------------------------\r\n");
    pc.printf(" | Premere il tasto 'i' per inserire un comando                               |\r\n");
    pc.printf(" | Premere il tasto 'a' per l'invio automatico della sequenza di comandi      |\r\n");
    pc.printf(" | Premere il tasto 'r' per rinviare l'ultimo comando                         |\r\n");
    pc.printf(" | Premere il tasto 't' per testare il tempo di risposta del modem            |\r\n");
    pc.printf(" | Premere il tasto 's' per riavviare il programma                            |\r\n");
    pc.printf(" | Premere il tasto 'e' per uscire dal programma                              |\r\n");
    pc.printf("  ----------------------------------------------------------------------------\r\n");
    pc.printf("________________________________________________________________________________\r\n");
    pc.printf("\r\n");

    while(1)
    {
        Vreset();
        
        input=pc.getc();
    
        if((input=='i')||(input=='I'))
        {
            LedOFF();
            
            pc.printf("Inserire un comando:  ");
            
            while(1)
            { 
                char c = pc.getc();
                pc.putc(c);
            
                at.write(&c,1);
    
                if(c=='\r') 
                {
                    goto esc1;
                }
            }
        
            esc1:
            
            pc.printf("\r\n\r\nRisposta:\r\n");
            
            at.read(MRxB, MRxBDIM); 
            
            for(i=0;i<MRxBDIM;i++)
            {
                pc.printf("%c",MRxB[i]);
            }
            
            pc.printf("________________________________________________________________________________\r\n");
            pc.printf("\r\n");
            
            ERR1();
            
            Vreset();
            
        } // End if
         
         
        if ((input=='a')||(input=='A'))
        {
            LedOFF();
            
            pc.printf("...invio automatico della sequenza di comandi..."); 
            pc.printf("\r\n");
            
            pc.printf("\r\nRisposta:\r\n\r\n");   
            
            at.send("AT");
            
            ReadModem();
            
            at.send("AT+CSQ=?");
      
            ReadModem();
            
            at.send("AT+CSQ");
            
            ReadModem();
            
            at.send("AT+COPN");
            
            ReadModem();
            
            pc.printf("________________________________________________________________________________\r\n");
            pc.printf("\r\n");
        
         } // End if
         
         if ((input=='r')||(input=='R'))
         {
            LedOFF();
            
            pc.printf("...rinvio dell'ultimo comando..."); 
            pc.printf("\r\n");
            
            pc.printf("\r\nRisposta:\r\n\r\n");   
            
            at.send("AT#/");
            
            ReadModem();
            
            pc.printf("________________________________________________________________________________\r\n");
            pc.printf("\r\n");
        
         } // End if
         
         
         if ((input=='t')||(input=='T'))
         {
             LedOFF();
             
             pc.printf("Inserire un comando per testare il tempo di risposta del modem: "); 
            
             while(1)
             { 
                char c = pc.getc();
                pc.putc(c);
            
                at.write(&c,1);
    
                if(c=='\r') 
                {
                    t.reset();
                    t.start();
                    goto esc2;
                }
             }
        
            esc2:
            
            printf("\r\n\r\n");
            
            if  (at.recv("AT")==true)
            {
                t.stop();
            }
    
            at.read(ARxB, ARxBDIM); 
        
            Vreset();
            
            pc.printf("Tempo di risposta: %f secondi\r\n", t.read());    
                 
            if (t.read()<1)
            {
                LedGREEN();
            }
            else
            {
                pc.printf("\r\nTempo di risposta superiore ad 1 secondo\r\n");
                LedRED();
            }
            
            pc.printf("________________________________________________________________________________\r\n");
            pc.printf("\r\n");
            
         } // End if
         
         
         if ((input=='s')||(input=='S'))
         {
             LedOFF();
             Vreset();
             
             goto start;
         }
         
         
         if ((input=='e')||(input=='E'))
         {
             pc.printf("Il programma e' stato chiuso\n\r\n\r");
             LedOFF();
    
             exit(0);
         }
     
    } // End while

}    

void ReadModem()
{
        
        at.read(ARxB, ARxBDIM); 
            
        for(i=0;i<ARxBDIM;i++)
        {
            pc.printf("%c",ARxB[i]);
        }
        
        printf("\r\n");
        
        ERR2();
        
        Vreset();
          
}
 
void ERR1()
{
            
            end=0;
            
            E=0;
            R=0;
            ER=0;
            ERR=0;
            
            // Ciclo per la ricerca della parola ERROR nel vettore ricevuto dal modem in risposta al comando inviato
            for(i=0;i<MRxBDIM;i++)
            {
                if(ERR==0)
                { 
                    if((MRxB[i])==' ') {goto jump1;}
                
                    if(E==0)
                    { 
                        if ((MRxB[i])=='E')
                        {
                            end++;
                            E=1;
                            goto jump1;
                        }
                    }
                    if(ER==0)
                    {
                        if(E==1)
                        {
                            if((MRxB[i])=='R') 
                            {
                                end++;
                                R=1;
                                ER=1;
                                goto jump1;
                            }
                            else
                            {
                                E=0;
                                end=0;
                                goto jump1;
                            }
                        }
                    }
                    if(R==1)
                    {
                        if((MRxB[i])=='R')
                        {
                            end++;
                            ERR=1;
                            goto jump1;
                        }
                        else
                        {
                            end=0;
                            E=0;
                            R=0;
                            ER=0;
                        }
                    }
                
                } // End if(ERR==0)
                     
            jump1: 
            
            led=1;
                      
            } // End ciclo for
            
            if(end==3) 
            {
                LedRED();
            }
            else
            {
                LedGREEN();
            }

}

void ERR2()
{
              
            end=0;
            
            E=0;
            R=0;
            ER=0;
            ERR=0;
            
            // Ciclo per la ricerca della parola ERROR nel vettore ricevuto dal modem in risposta alla sequenza prestabilita di comandi
            for(i=0;i<ARxBDIM;i++)
            {
                if(ERR==0)
                { 
                    if((ARxB[i])==' ') {goto jump2;}
                
                    if(E==0)
                    { 
                        if ((ARxB[i])=='E')
                        {
                            end++;
                            E=1;
                            goto jump2;
                        }
                    }
                    if(ER==0)
                    {
                        if(E==1)
                        {
                            if((ARxB[i])=='R') 
                            {
                                end++;
                                R=1;
                                ER=1;
                                goto jump2;
                            }
                            else
                            {
                                E=0;
                                end=0;
                                goto jump2;
                            }
                        }
                    }
                    if(R==1)
                    {
                        if((ARxB[i])=='R')
                        {
                            end++;
                            ERR=1;
                            goto jump2;
                        }
                        else
                        {
                            end=0;
                            E=0;
                            R=0;
                            ER=0;
                        }
                    }
                
                } // End if(ERR==0)
                     
                jump2:
                
                led=1;
                              
            } // End ciclo for
            
            if(end==3) 
            {
                LedRED();
            }
            else
            {
                LedGREEN();
            }

}

void Vreset()
{
        
        // Reset del vettore MRxB
        for(i=0;i<MRxBDIM;i++)
        {
            MRxB[i]='\0';
        }
    
        // Reset del vettore ARxB
        for(j=0;j<ARxBDIM;j++)
        {
            ARxB[j]='\0';
        }
           
}      

void LedGREEN()
{
                       
          // Cicli per la configurazione del vettore Vled
          for(i = 0; i <= 3; i++)      
              Vled[i]=204; 
                 
          for(i = 4; i <= 7; i++)     
              Vled[i]=136;      
             
          for(i = 8; i <= 11; i++)    
              Vled[i]=136; 
                      
          for(i = 12; i <= NumByte-1; i++)     
              Vled[i]=136; 
    
          // Ciclo per l'invio dei frame al led   
          for(j = 0; j < NumByte; j++)  
              myspi.write(Vled[j]);      
              
}

void LedRED()
{
                 
          // Cicli per la configurazione del vettore Vled
          for(i = 0; i <= 3; i++)      
              Vled[i]=136; 
                 
          for(i = 4; i <= 7; i++)     
              Vled[i]=204;      
             
          for(i = 8; i <= 11; i++)    
              Vled[i]=136; 
                      
          for(i = 12; i <= NumByte-1; i++)     
              Vled[i]=136; 
    
          // Ciclo per l'invio dei frame al led   
          for(j = 0; j < NumByte; j++)  
              myspi.write(Vled[j]);      

}

void LedOFF()
{
         
          // Cicli per la configurazione del vettore Vled    
          for(i = 0; i <= 3; i++)      
              Vled[i]=136; 
                 
          for(i = 4; i <= 7; i++)     
              Vled[i]=136;      
             
          for(i = 8; i <= 11; i++)    
              Vled[i]=136; 
                      
          for(i = 12; i <= NumByte-1; i++)     
              Vled[i]=136; 
    
          // Ciclo per l'invio dei frame al led   
          for(j = 0; j < NumByte; j++)  
              myspi.write(Vled[j]);      

}


    
    
    
    
    
    
    
    
    
    
    
    
    
  


          
          
          
          
          
          
          
          
          
          
          
          
               
         






























