//PARA PODER UTILIZARLO SE DEBE REALIZAR EL REGISTRO EN LA PÁGINA DE SUPERTWEET http://www.supertweet.net/
//REALIZADO POR GALO BECERRA - TAS 2012 - ECUADOR

#include "mbed.h"
#include "ID12RFID.h"
#include "EthernetNetIf.h"
#include "HTTPClient.h"

#define TWITTER_USER "USER_NAME"
#define TWITTER_PASSWORD "PASWWORD"

#define IDS_COUNT 3
const int ids_list[IDS_COUNT] = {8984648, 9541172, 89481811};
const char* names_list[IDS_COUNT] = {"Usuario1", "Usuario2", "Usuario3"};

EthernetNetIf ethernet;
HTTPClient twitter;

ID12RFID rfid(p14);
DigitalOut tag_present(LED1);
PwmOut eth_status(LED2);
DigitalOut tweet_ok(LED4);

int main() {
    int contador=0;
    char mensaje[BUFSIZ];
    
    EthernetErr err = ethernet.setup();
    
    if(err){
        eth_status = 1;        
    }
    else{
        for(float x=0.0; x<1; x+=0.01){
            eth_status = x;
            wait(0.03);
        }
        for(float x=1; x>0; x-=0.01){
            eth_status = x;
            wait(0.03);
        }
    }
        
    twitter.basicAuth(TWITTER_USER, TWITTER_PASSWORD);
    
    while(true) {
        int id = rfid.read();
        tag_present = 1;
        contador++;
                                
        for(int i=0; i<IDS_COUNT; i++){
            if (ids_list[i] == id){
                HTTPMap msg;
                snprintf(mensaje, sizeof(mensaje), "Acceso de: %s numero: %u",names_list[i],contador);
                msg["status"] = mensaje;
                HTTPResult r = twitter.post("http://api.supertweet.net/1/statuses/update.xml", msg, NULL);
                                
                if( r == HTTP_OK ){
                    printf("Tweet sent with success!\n");
                    for(int j=0; j<5; j++){
                        tweet_ok = 1;
                        wait(0.1);
                        tweet_ok = 0;
                        wait(0.1);
                    }
                }
                else{
                    printf("Problem during tweeting, return code %d\n", r);
                    tweet_ok = 1;
                }
                
            }            
        }        
        tag_present = 0;        
    }
}

//Código para leer los tag RFID
/*#include "mbed.h"
#include "ID12RFID.h"
 
ID12RFID rfid (p14);
Serial pc (USBTX,USBRX);
int main() {
pc.printf("Tag ID = %d\n\r", 50);     // Prints the RFID Tag into the Terminal
  while (1){
    int id = rfid.read();                // Reads the RFID Tag
    pc.printf("Tag ID = %d\n\r",id);     // Prints the RFID Tag into the Terminal
    }
}*/