/*
ECE 4180 Final Project: Rainwater Harvesting System with IoT

SAMPLE DATA: There's a lot of noise specially in the beginning when water just bounces around the empty tank
reading the sensor at longer intervals of time might help reduce the noise but the data in general looks like 
this with bounds (~empty : ~full) => (~192mm : ~ 34mm) 

*/

//adding the libraries
    #include "mbed.h"
    #include "ultrasonic.h"
    #include "uLCD_4DGL.h"
    #include "Servo.h"


//defining the pinouts
    uLCD_4DGL uLCD(p28,p27,p30); // serial tx, serial rx, reset pin;
    //ultrasonic mu(p6, p7, .1, 1, &dist); 
    //I2C rangefinder(p9, p10); //sda, sc1 
    Serial pc(USBTX, USBRX); //tx, rx 
    //Servo myservo(p21);

//defining arbitrary variables
int height;
//bool LidClosed = false;
//bool empty;
//float p = 0;


//sensor function for height
void dist(int distance)
 { 
        height = distance;
        //height = mu.getCurrentDistance(void);   
        printf("DISTANC %d mm\r\n", distance);
        
 }
 
ultrasonic mu(p6, p7, .5, 1, &dist); 
 
 //pass on the height return volume
int Volume(int h)
 {
   double pi = 3.14;
   double radius = 6.5;
   return(pi*radius*radius*h); 
 }
 
 
 
 //Displays the water level and volume on LCD
 void Display()
 {
    int V = height/3; 
    volatile int level = 27 + V;
    uLCD.baudrate(BAUD_3000000);
    uLCD.background_color(BLACK);
    uLCD.cls(); //replace with a black retangle instead oc clear screen
    uLCD.locate(3,12);
    uLCD.printf("VOLUME= %d",Volume(height));
    //uLCD.printf("Volume =  ");    
    //void rectangle(int, int, int, int, int);
    //uLCD.locate(1,1);
    uLCD.rectangle(50, 25, 102, 92, 0x0FFFFF);
    // dynamic rectangle size -> second argument of rectangle should be based on the sonar reading level.
    uLCD.filled_rectangle(52, level, 100, 90, 0x00FF00); // fill rectangle based on current volume levels
    wait(0.5);             
 }



//void tankLid()
//{
// //check is tank is empty and lid is closed then opens 
//     if(( empty == 1) && (LidClosed == true))
//      {  
//        for(p=0; p<=10; p++) 
//        {
//         myservo = p/10.0;
//        
//        }
//        LidClosed = false;
//        
//      }
//      
//     //checks if tank is full and lid is open then closes  
//     else if((empty == 0) &&(LidClosed == false))  
//      { 
//        for(p=10; p>=0; p--) 
//         {
//           myservo = p/10.0;
//           
//         }
//         LidClosed = true;
//      }
// }    

   int main() 
   {
     mu.startUpdates();
     
     while (1) 
     {
        
        //tank empty == 1 open lid
        mu.checkDistance();   //checks height value fro sonar
        //height = mu.getCurrentDistance();
         wait(0.5);
        Display(); //computes volume and display volume level
         wait(0.5);
        //stream current level value to SDcard repeat  
         //pc.printf("DISTANCE %d mm\r\n", height);//
         //pc.printf("TEST\n");
         
     } 
     
  }
  