#include "mbed.h"
#include "HEPTA_COM.h"
#include "HEPTA_EPS.h"
#include "HEPTA_SENSOR.h"

Serial pc(USBTX,USBRX);
HEPTA_COM com(p9,p10);
HEPTA_EPS eps(p16,p26);
HEPTA_SENSOR sensor(p17,
                  p28,p27,0x19,0x69,0x13,
                  p13, p14,p25,p24);

int main() {
    pc.baud(9600);
    com.baud(9600);
    sensor.gps_setting();
    int quality=0,stnum=0,gps_check=0;
    char ns='A',ew='B',aunit='m';
    float time=0.0,latitude=0.0,longitude=0.0,hacu=0.0,altitude=0.0;
    for(int i=1; i<700; i++) {
        sensor.gga_sensing(&time, &latitude, &ns, &longitude, &ew, &quality, &stnum, &hacu, &altitude, &aunit, &gps_check);
        if((gps_check==0)|(gps_check==1)) {
            pc.printf("This is GST,SOS,%f,%f,%f,%f %\r\n",time,latitude,longitude,altitude);
            com.printf("This is GST,SOS,%f,%f,%f,%f %\r\n",time,latitude,longitude,altitude);
        }
    }
}
