#ifndef MBED_KEYPAD_H
#define MBED_KEYPAD_H

#include "mbed.h"
#include <vector>
#include <algorithm>
#include <time.h>

//Keypad class.  A 4x3 keypad class.  Documentation is available on wiki @ ___________
//Usage:  Instantiate object, and use getkey method to retrieve keys pressed.  Might want to play around with switchrate to get better responsiveness (decides how fast we switch powering columns)
//Important note:  Can only reliably detect a keypress in a single row at any given time, although multiple key detection in different rows is supported (eg 1 and 4 is detected simulataneously, 1 and 3 will just detect one of those)

/*  Keypad      Representations
    1 2 3       1   2  3 
    4 5 6   ->  4   5  6 
    7 8 9       7   8  9
    * 0 #       10  11 12
    
*/
class KeyPad2{
    public:
      
        KeyPad2(PinName pin3, PinName pin1 ,PinName pin5 ,PinName pin2, PinName pin7,PinName pin6, PinName pin4);
        
        void setswitchrate(double switchrate);
        
        // sets function to be called when any button is pressed 
        // function should take in one parameter which will represent the button pressed (int)
        void setinterrupthandler(const void* func);     
        
        ~KeyPad2();
        
        
        // takes roughly 3x switchrate + processing time
        std::vector<int> getkey();
        
    private:
    
        // the time in milliseconds which each power will be powered for before switching to the next 
        // default = 10 milliseconds           
        double switchrate;   
       
          
        DigitalOut* columnoneout;      // pin 3 on keypad 
        DigitalOut* columntwoout;      // pin 1 on keypad
        DigitalOut* columnthreeout;    // pin 5 on keypad

    
        DigitalIn* rowonein;           // pin 2 on keypad 
        DigitalIn* rowtwoin;           // pin 7 on keypad
        DigitalIn* rowthreein;         // pin 6 on keypad
        DigitalIn* rowfourin;          // pin 4 on keypard  
        
       
        
        
        
    
};
#endif