#include "KeyPad.h"
//#include "mbed.h"


KeyPad2::KeyPad2(PinName pin3, PinName pin1 ,PinName pin5 ,PinName pin2, PinName pin7,PinName pin6, PinName pin4){
    // KeyPad2 keypad(p25, p27, p23, p26, p21, p22, p24);
    switchrate = 0.001;
 
    
    columnoneout = new DigitalOut   ( pin3 );      // pin 3 on keypad 
    columntwoout = new DigitalOut   ( pin1 );      // pin 1 on keypad
    columnthreeout = new DigitalOut ( pin5 );      // pin 5 on keypad

    rowonein = new DigitalIn        ( pin2 );      // pin 2 on keypad 
    rowtwoin = new DigitalIn        ( pin7 );      // pin 7 on keypad
    rowthreein = new DigitalIn      ( pin6 );      // pin 6 on keypad
    rowfourin = new DigitalIn       ( pin4 );      // pin 4 on keypad
    
}


KeyPad2::~KeyPad2(){
    delete[] columnoneout;
    delete[] columntwoout;
    delete[] columnthreeout;
    delete[] rowonein;
    delete[] rowtwoin;
    delete[] rowthreein;
    delete[] rowfourin;   
}

void KeyPad2::setswitchrate(double switchrate){ // sets the rate which you switch between powering each column
    this->switchrate = switchrate;   
}




std::vector<int> KeyPad2::getkey(){ // powers each column of the keypad once based upon the time divisions of switchrate, returns keys in sorted order
    std::vector<int> keyspressed;
    
    bool addedone, addedtwo, addedthree, addedfour;
    clock_t start;
    //check 2nd column
    *columnoneout = 0;
    *columntwoout = 1;
    *columnthreeout = 0;
    
    start = clock();
   
    addedone = false;
    addedtwo =false;
    addedthree = false;
    addedfour = false;
     
    while (clock() - start < switchrate*CLOCKS_PER_SEC){
        if ( *rowonein == 1 && !addedone ){
             keyspressed.push_back(2);
             addedone = true;
        }
    
        if ( *rowtwoin == 1 && !addedtwo){
            keyspressed.push_back(5);  
            addedtwo = true; 
        }
    
        if ( *rowthreein == 1 && !addedthree ){
            keyspressed.push_back(8);  
            addedthree = true; 
        }
    
        if ( *rowfourin == 1 && !addedfour){
            keyspressed.push_back(11);   
            addedfour = true;
        }
    }
    
    
    //check first column
    *columnoneout = 1;
    *columntwoout = 0;
    *columnthreeout = 0;
    
    start = clock();
   
    addedone = false;
    addedtwo =false;
    addedthree = false;
    addedfour = false;
     
     
    // check first column   
    while (clock() - start < switchrate*CLOCKS_PER_SEC){
        if ( *rowonein == 1 && !addedone ){
             keyspressed.push_back(1);
             addedone = true;
        }
    
        if ( *rowtwoin == 1 && !addedtwo){
            keyspressed.push_back(4);  
            addedtwo = true; 
        }
    
        if ( *rowthreein == 1 && !addedthree ){
            keyspressed.push_back(7);  
            addedthree = true; 
        }
    
        if ( *rowfourin == 1 && !addedfour){
            keyspressed.push_back(10);   
            addedfour = true;
        }
    }
    
    
    
    //check 3rd column
    
    *columnoneout = 0;
    *columntwoout = 0;
    *columnthreeout = 1;
    
    start = clock();
   
    addedone = false;
    addedtwo =false;
    addedthree = false;
    addedfour = false;
     
    while (clock() - start < switchrate*CLOCKS_PER_SEC){
        if ( *rowonein == 1 && !addedone ){
             keyspressed.push_back(3);
             addedone = true;
        }
    
        if ( *rowtwoin == 1 && !addedtwo){
            keyspressed.push_back(6);  
            addedtwo = true; 
        }
    
        if ( *rowthreein == 1 && !addedthree ){
            keyspressed.push_back(9);  
            addedthree = true; 
        }
    
        if ( *rowfourin == 1 && !addedfour){
            keyspressed.push_back(12);   
            addedfour = true;
        }
    }
    
    std::sort(keyspressed.begin(), keyspressed.end());          
    return keyspressed; 
}