#ifndef WavDis_H
#define WavDis_H

#include "mbed.h"
#include "uLCD_4DGL.h"
#include "SystemState.h"
#include <string>


using std::string;

class WavDis
{ 
 
public:
    WavDis(): led1(LED1) , led2(LED2), led3(LED3), led4(LED4), lcd(p28, p27, p30)
    {
        currentState = stop;
        currentSong = "";
        screen_lock = false;
    }
   
    void UpdateSong(string);
    void UpdateState(SystemState);
    void UpdateTemp(float);
    void UpdateVolume(int);
    
private:

    void Update();
    void UpdateLEDs();

    DigitalOut led1;
    DigitalOut led2;
    DigitalOut led3;
    DigitalOut led4;
    
    SystemState currentState;
    string currentSong;    
    bool screen_lock;
    //LCD
    uLCD_4DGL lcd;
    
};

#endif