#include "WavDis.h"

void WavDis::Update()
{
    UpdateLEDs();
    
    string s = "";
         
    switch (currentState)
    {
        case stop:
            s = currentSong.substr(0,(currentSong.size() - 4));
             //FirstLine
            if (screen_lock == false) {
                screen_lock = true;
                lcd.text_width(1.5); //4X size text
                lcd.text_height(1.5);
                lcd.color(GREEN);
                lcd.locate(0,1);
                lcd.printf("%s         ", s.c_str());
                //SecondLine
                lcd.locate(0,2);
                lcd.printf("Stopped      ");
                screen_lock = false;
            }  
            break;
        case play_state:
            s = currentSong.substr(0,(currentSong.size() - 4));
             //FirstLine
            if (screen_lock == false) {
                screen_lock = true;
                lcd.text_width(1.5); //4X size text
                lcd.text_height(1.5);
                lcd.color(GREEN);
                lcd.locate(0,1);
                lcd.printf("%s  ", s.c_str());
                //SecondLine
                lcd.locate(0,2);
                lcd.printf("Now Playing");
                screen_lock = false;
            }    
            break;
        case Need_SD:
            lcd.locate(0,0);
            lcd.printf("Insert SD Card");    
            break; 
    }       
}

void WavDis::UpdateTemp(float temp) {
    if (screen_lock == false) {
        screen_lock = true;
            lcd.text_width(1.5); //4X size text
            lcd.text_height(1.5);
            lcd.color(WHITE);
            lcd.locate(0,7);
        if (temp < 60.00) {
            lcd.filled_circle(60, 100, 20, BLUE);
            //lcd.locate(0,8);
            lcd.printf("Temperature: \n%.2f", temp);
        } else if (temp >= 60.00) {
            lcd.filled_circle(60, 100, 20, RED);
            //lcd.locate(0,8);
            lcd.printf("Temperature: \n%.2f", temp);
        }
        screen_lock = false;
    }    
    return;
}

void WavDis::UpdateSong(string songName)
{
    currentSong = songName;
    Update();
}

void WavDis::UpdateState(SystemState state)
{
    currentState = state;    
    Update();
}

void WavDis::UpdateVolume(int volume)
{
    if (screen_lock == false) {
        screen_lock = true;
            lcd.text_width(1); //4X size text
            lcd.text_height(1);
            lcd.color(GREEN);
            lcd.locate(0,3);
            lcd.printf("Volume: \n%d ", volume);
        screen_lock = false;
    } 
}

void WavDis::UpdateLEDs()
{    
    led1 = 1;
    switch (currentState)
    {
        case stop:
            led2 = 0;
            led3 = 0;
            led4 = 0;
            break;
        case play_state:
            led2 = 1;
            led3 = 1;
            led4 = 1;
            break;  
    }   
      
}
