#include "mbed.h"
#include "TMP36.h"
#include "PinDetect.h"
#include "SDFileSystem.h"
#include "SystemState.h"
#include "wave_player.h"
#include "WavDis.h"
#include "time.h"
#include <vector>
#include <string>
#include <stdio.h>

using std::string;

PinDetect fwdButton(p17, PullUp);
PinDetect revButton(p16, PullUp);
PinDetect playButton(p12, PullUp);
PinDetect volumeButton(p20, PullUp);

Serial rn42(p13,p14);  // Bluetooth Module
Serial pc(USBTX, USBRX);

SDFileSystem sd(p5, p6, p7, p8, p9, "sd"); //SD card extra pin p9

AnalogOut DACout(p18);
wave_player waver(&DACout);

float Current_temp = 0.0;
float Current_temp1 = 0.0;
float Current_temp2 = 0.0;

TMP36 myTMP36(p15);
Timer t;

const char* cmds[] = {"MUSIC:UP", "MUSIC:STOP", "MUSIC:PLAY", "MUSIC:NEXT", "MUSIC:PREV", "MUSIC:DOWN"};
SystemState currentState = stop;
string currentSong;
string fileDirectory;
int currentIndex;
int librarySize;
int volumeControl;
bool playStop;
float const rate = 1.0;
string fileName = "";

WavDis display;


vector<string> filenames; //filenames are stored in a vector string

//PROTOCOL:
// ex) TEMPERATURE:30   --> reading of 30 degrees
//
bool writeLine (char* towrite, int length)
{
    if (rn42.writeable()) {
        for (int i = 0; i < length; i++) {
            if (towrite[i] == NULL ) {
                break;
            }
            pc.printf("|%c",towrite[i]);
            rn42.putc(towrite[i]);
        }
        rn42.putc('\n');
        rn42.putc(0);
        return true;
    }

    return false;
}


bool readLine (char* buffer, int sizebuffer)
{
    char tmpRead = 0;

    if (rn42.readable() == 0){
        return false;   
    }
    int i;
    for (i= 0 ; i< sizebuffer-1; i++) {

        //if (rn42.readable()) {
            tmpRead = rn42.getc();
        //} else {
          //  break;
        //}

        if (tmpRead == '\n' || tmpRead == 0) {
            break;
        }
        buffer[i] = tmpRead;
        if (i == 0 && tmpRead == 0) {
            return false;
        }
    }

    buffer[i] = 0;
    if (i == 0 ) {
        return false;
    }

    return true;

}
/*
void Rx_interrupt(void) {
    pc.printf("I blocked you bitch");
    pc.putc(rn42.getc());
     pc.printf("jk");
}*/

//UPDATE NECESSARY VARIABLES EACH TIME A BUTTON EVEN OCCURS
void Update(int index, SystemState state)
{
    currentState = state;
    currentIndex = index;
    currentSong = filenames[currentIndex];
    display.UpdateState(currentState);
    display.UpdateSong(currentSong);
    display.UpdateVolume(15-volumeControl);
    Current_temp = (1.8*myTMP36.read())+32;
    display.UpdateTemp(Current_temp);
    switch(currentState) {
        case stop:
            playStop = false;
            break;
        case play_state:
            playStop = true;
            break;
    }
}


void getWaveFiles()
{
    if (!sd.SDInserted()) {
        while (!sd.SDInserted()) {
            //check for sd card until true
            display.UpdateState(Need_SD);
            printf("SD Card Not Found\n");
            wait(1);
        }
        wait(2);
        sd.disk_initialize();
        wait(2);
    }

    wait(2);
    DIR *dp;
    struct dirent *dirp;
    dp = opendir(fileDirectory.c_str());

    while((dirp = readdir(dp)) != NULL) {
        filenames.push_back(string(dirp->d_name));
    }
    // print filename strings from vector using an iterator
    for(vector<string>::iterator it=filenames.begin(); it < filenames.end(); it++) {
        printf("%s\n\r",(*it).c_str());
    }

    librarySize = filenames.size();
    if (librarySize == 0) {
        printf("Library Empty\n\n");
        return;
    }

    fileDirectory.append("/");

    Update(0,stop);
}



void fwdButton_Event(void)
{
    if (currentState == stop) {
        currentIndex++; //INCREMENT CURRENT INDEX (0 TO NUMBER OF SONGS -1)
        if(currentIndex >= librarySize) {
            currentIndex = 0;
        }
        Update(currentIndex,currentState);
    }
}
void revButton_Event(void)
{
    if (currentState == stop) {
        currentIndex--; //DECREMENT CURRENT INDEX (0 TO NUMBER OF SONGS -1)
        if(currentIndex < 0) {
            currentIndex = (librarySize - 1);
        }
        Update(currentIndex,currentState);
    }
}

void playButton_Event(void)
{

    switch (currentState) {
        case stop:
            Update(currentIndex, play_state);
            break;
        case play_state:
            Update(currentIndex, stop);
            break;
    }
}
void volumeUpButton_Event(void)
{
    if ((volumeControl >= 0) && (volumeControl < 15)){
        volumeControl++;
    }
     display.UpdateVolume(15-volumeControl);
}
void volumeButton_Event(void)
{
    if(volumeControl >= 15) {
        volumeControl = 0;
    } else {
        volumeControl++;
    }
     display.UpdateVolume(15-volumeControl);
}

void volumeDownButton_Event(void)
{
    if(volumeControl > 0) {
        volumeControl--;
    }
     display.UpdateVolume(15-volumeControl);
}

int main()
{

    // BlueTooth Module
    rn42.baud(19600);
    pc.baud(9600);

    // MP3 Player
    currentState = stop;
    currentSong = "";
    librarySize = 0;
    volumeControl = 0;
    currentIndex = -1;
    fileDirectory = "/sd/myMusic";
    char output[50];
    string temp;
    bool didRead = false;
    char buf [100];

    fwdButton.attach_asserted(&fwdButton_Event);
    fwdButton.setSampleFrequency();
    revButton.attach_asserted(&revButton_Event);
    revButton.setSampleFrequency();
    playButton.attach_asserted(&playButton_Event);
    playButton.setSampleFrequency();
    volumeButton.attach_asserted(&volumeButton_Event);
    volumeButton.setSampleFrequency();
    //rn42.attach(&Rx_interrupt, Serial::RxIrq);

    getWaveFiles();
    pc.printf("init");

    while(1) {
        switch (currentState) {
            case stop:
                break;
            case play_state:
                string fileName = "";
                fileName.append(fileDirectory + currentSong);
                printf("%s\n\r",fileName.c_str());
                FILE *wave_file;
                wave_file=fopen(fileName.c_str(),"r");

                waver.play(wave_file, &playStop, &volumeControl);

                fclose(wave_file);
                Update(currentIndex,stop);
                break;
        }
        wait(0.1);
        t.start();

        if (t.read() >= rate) {
            Current_temp = (1.8*myTMP36.read())+32;
            Current_temp1 = (1.8*myTMP36.read())+32;
            Current_temp2 = (1.8*myTMP36.read())+32;
            Current_temp = (Current_temp + Current_temp1 + Current_temp2) / 3.00;
            display.UpdateTemp(Current_temp);
            snprintf(output,50,"%.2f", Current_temp);
            writeLine (output, 50);
            t.reset();
            t.start();
        }


        didRead = readLine(buf, 100);
        pc.printf("(%s)\n",buf);
        if (didRead) {
            if (strcmp(buf,cmds[0]) == 0) {
                pc.printf("Volume Increase");
                volumeUpButton_Event();
            }
            if (strcmp(buf,cmds[1]) == 0) {
                pc.printf("STOP");
                playButton_Event();
            }
            if (strcmp(buf,cmds[2]) == 0) {
                pc.printf("PLAY");
                playButton_Event();
            }
            if (strcmp(buf,cmds[3]) == 0) {
                pc.printf("FORWARD");
                fwdButton_Event();
            }
            if (strcmp(buf,cmds[4]) == 0) {
                pc.printf("REVERSE");
                revButton_Event();
            }
            if (strcmp(buf,cmds[5]) == 0) {
                pc.printf("DOWN");
                volumeDownButton_Event();
            }

        }
    }

}
