#include <mbed.h>
#include <DigitDisplay.h>
#include <time.h>

#define RUNTIMES 5

DigitDisplay display(P4_29, P4_28);
DigitalIn button(D6);

void Merge(int a[], int b[], int low, int mid, int high);
void MergePass(int a[], int b[], int seg, int size);
void MergeSort(int a[], int size);

int r_number,number[RUNTIMES],times=0;

int main()
{
    srand( (unsigned)time(NULL));
    while(1) 
    {
           r_number=rand()%(9999)+1; 
           display.write(r_number);
           if(button)
           {
               number[times]=r_number;
               display.write(number[times]);
               wait(2);
               times++;
           }
           if(times==RUNTIMES)
           {
               break;
           }
           wait(0.1);
    }
    MergeSort(number, sizeof(number) / sizeof(*number));
    for(int i = 0; i < sizeof(number) / sizeof(*number); i++)
    {
        display.write(number[i]);
        wait(1);
    }
}

void Merge(int a[], int b[], int low, int mid, int high)
{
    int k = low;
    int begin1 = low;
    int end1 = mid;
    int begin2 = mid + 1;
    int end2 = high;
    while(k <= high )
    {
        if(begin1 > end1)
            b[k++] = a[begin2++];
        else if(begin2 > end2)
            b[k++] = a[begin1++];
        else
    {
        if(a[begin1] <= a[begin2])
        b[k++] = a[begin1++];
        else
        b[k++] = a[begin2++];
    }
    }
 
}
 
void MergePass(int a[], int b[], int seg, int size)
{
    int seg_start_ind = 0;
    while(seg_start_ind <= size - 2 * seg)
    {
    Merge(a, b, seg_start_ind, seg_start_ind + seg - 1, seg_start_ind + seg * 2 - 1);
    seg_start_ind += 2 * seg;
    }
    if(seg_start_ind + seg < size)
    Merge(a, b, seg_start_ind, seg_start_ind + seg - 1, size - 1);
    else
    for(int j = seg_start_ind; j < size; j++)
        b[j] = a[j];
}
 
void MergeSort(int a[], int size)
{
    int* temp = new int[size];
    int seg = 1;
    while(seg < size)
    {
    MergePass(a, temp, seg, size);
    seg += seg;
    MergePass(temp, a, seg, size);
    seg += seg;
    }
    delete [] temp;
}